/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.ContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledRead;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledReadBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.ConsedConsensusQualityComputer;
import org.jcvi.jillion.assembly.consed.ace.DefaultAceAssembledRead;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageMapBuilder;
import org.jcvi.jillion.assembly.util.CoverageRegion;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceBuilder;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.assembly.DefaultContig;

public final class AceContigBuilder
implements ContigBuilder<AceAssembledRead, AceContig> {
    private static final PhredQuality DEFAULT_QUALITY = PhredQuality.valueOf(30);
    private ConsensusCaller consensusCaller = null;
    private QualitySequenceDataStore qualityDataStore = null;
    private GapQualityValueStrategy qualityValueStrategy = GapQualityValueStrategy.LOWEST_FLANKING;
    private NucleotideSequence initialConsensus;
    private NucleotideSequenceBuilder mutableConsensus;
    private String contigId;
    private final Map<String, AceAssembledReadBuilder> aceReadBuilderMap;
    private int contigLeft = -1;
    private int contigRight = -1;
    private volatile boolean built = false;
    private boolean complemented = false;
    private boolean computeConsensusQualities = false;
    private QualitySequenceBuilder mutableConsensusQualities;

    public AceContigBuilder(String contigId, String initialConsensus) {
        this(contigId, new NucleotideSequenceBuilder(initialConsensus).build());
    }

    public AceContigBuilder setInitialConsensusQualities(QualitySequence consensusQualities) {
        this.mutableConsensusQualities = new QualitySequenceBuilder(consensusQualities);
        return this;
    }

    private QualitySequenceBuilder createDefaultQualitySequenceBuilder(int ungappedConsensusLength) {
        byte[] quals = new byte[ungappedConsensusLength];
        Arrays.fill(quals, DEFAULT_QUALITY.getQualityScore());
        return new QualitySequenceBuilder(quals);
    }

    public AceContigBuilder(String contigId, NucleotideSequence initialConsensus) {
        this.checkNotNull(contigId);
        if (initialConsensus == null) {
            throw new NullPointerException("consensus can not be null");
        }
        this.initialConsensus = initialConsensus;
        this.contigId = contigId;
        this.mutableConsensus = new NucleotideSequenceBuilder(initialConsensus);
        this.aceReadBuilderMap = new HashMap<String, AceAssembledReadBuilder>(200);
    }

    public void checkNotNull(String contigId) {
        if (contigId == null) {
            throw new NullPointerException("contig id can not be null");
        }
    }

    public AceContigBuilder(String contigId, ConsensusCaller consensusCaller) {
        this.checkNotNull(contigId);
        if (consensusCaller == null) {
            throw new NullPointerException("consensusCaller can not be null");
        }
        this.contigId = contigId;
        this.mutableConsensus = null;
        this.recallConsensus(consensusCaller);
        this.aceReadBuilderMap = new HashMap<String, AceAssembledReadBuilder>(200);
    }

    public AceContigBuilder(String contigId, ConsensusCaller consensusCaller, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy) {
        this.checkNotNull(contigId);
        if (consensusCaller == null) {
            throw new NullPointerException("consensusCaller can not be null");
        }
        this.contigId = contigId;
        this.mutableConsensus = null;
        this.recallConsensus(consensusCaller, qualityDataStore, qualityValueStrategy);
        this.aceReadBuilderMap = new HashMap<String, AceAssembledReadBuilder>(200);
    }

    public AceContigBuilder(String contigId, NucleotideSequence initialConsensus, int estimatedNumberOfReads) {
        this.checkNotNull(contigId);
        if (initialConsensus == null) {
            throw new NullPointerException("consensus can not be null");
        }
        this.initialConsensus = initialConsensus;
        this.contigId = contigId;
        this.mutableConsensus = new NucleotideSequenceBuilder(initialConsensus);
        int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(estimatedNumberOfReads);
        this.aceReadBuilderMap = new HashMap<String, AceAssembledReadBuilder>(capacity);
    }

    public AceContigBuilder(AceContig copy) {
        this.contigId = copy.getId();
        this.initialConsensus = copy.getConsensusSequence();
        this.mutableConsensus = new NucleotideSequenceBuilder(this.initialConsensus);
        this.aceReadBuilderMap = new HashMap<String, AceAssembledReadBuilder>(MapUtil.computeMinHashMapSizeWithoutRehashing(copy.getNumberOfReads()));
        StreamingIterator<AceAssembledRead> readIter = null;
        try {
            readIter = copy.getReadIterator();
            while (readIter.hasNext()) {
                this.addRead(readIter.next());
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(readIter);
        }
    }

    public AceContigBuilder setComplemented(boolean complemented) {
        this.complemented = complemented;
        return this;
    }

    public AceContigBuilder recallConsensus(ConsensusCaller consensusCaller, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy) {
        if (consensusCaller == null) {
            throw new NullPointerException("consensus caller can not be null");
        }
        if (qualityDataStore == null) {
            throw new NullPointerException("quality datastore can not be null");
        }
        if (qualityValueStrategy == null) {
            throw new NullPointerException("quality value strategy can not be null");
        }
        this.consensusCaller = consensusCaller;
        this.qualityDataStore = qualityDataStore;
        this.qualityValueStrategy = qualityValueStrategy;
        return this;
    }

    public AceContigBuilder updateConsensusRecaller(ConsensusCaller consensusCaller) {
        if (consensusCaller == null) {
            throw new NullPointerException("consensus caller can not be null");
        }
        this.consensusCaller = consensusCaller;
        return this;
    }

    public AceContigBuilder computeConsensusQualities() {
        this.computeConsensusQualities = true;
        return this;
    }

    public AceContigBuilder computeConsensusQualities(QualitySequenceDataStore readQualityDataStore) {
        if (readQualityDataStore == null) {
            throw new NullPointerException("read quality datastore can not be null");
        }
        this.computeConsensusQualities = true;
        this.qualityDataStore = readQualityDataStore;
        return this;
    }

    public AceContigBuilder recallConsensus(ConsensusCaller consensusCaller) {
        if (consensusCaller == null) {
            throw new NullPointerException("consensus caller can not be null");
        }
        this.consensusCaller = consensusCaller;
        this.qualityDataStore = null;
        this.qualityValueStrategy = GapQualityValueStrategy.LOWEST_FLANKING;
        return this;
    }

    public AceContigBuilder setContigId(String contigId) {
        this.checkNotNull(contigId);
        this.contigId = contigId;
        return this;
    }

    @Override
    public String getContigId() {
        return this.contigId;
    }

    @Override
    public int numberOfReads() {
        return this.aceReadBuilderMap.size();
    }

    public AceContigBuilder addRead(AceAssembledRead acePlacedRead) {
        return this.addRead(acePlacedRead.getId(), acePlacedRead.getNucleotideSequence(), (int)acePlacedRead.getGappedStartOffset(), acePlacedRead.getDirection(), acePlacedRead.getReadInfo().getValidRange(), acePlacedRead.getPhdInfo(), acePlacedRead.getReadInfo().getUngappedFullLength());
    }

    public AceContigBuilder addAllReads(Iterable<AceAssembledRead> reads) {
        for (AceAssembledRead read : reads) {
            this.addRead(read);
        }
        return this;
    }

    @Override
    public Collection<AceAssembledReadBuilder> getAllAssembledReadBuilders() {
        return this.aceReadBuilderMap.values();
    }

    public AceAssembledReadBuilder getAssembledReadBuilder(String readId) {
        return this.aceReadBuilderMap.get(readId);
    }

    public AceContigBuilder removeRead(String readId) {
        if (readId == null) {
            throw new NullPointerException("read id can not be null");
        }
        this.aceReadBuilderMap.remove(readId);
        return this;
    }

    public AceContigBuilder addRead(String readId, NucleotideSequence validBases, int offset, Direction dir, Range clearRange, PhdInfo phdInfo, int ungappedFullLength) {
        if (readId == null) {
            throw new NullPointerException("readId can not be null");
        }
        if (this.aceReadBuilderMap.containsKey(readId)) {
            throw new IllegalArgumentException("read with same id already in contig" + readId);
        }
        if (validBases == null) {
            throw new NullPointerException("valid bases can not be null");
        }
        int correctedOffset = Math.max(0, offset);
        this.adjustContigLeftAndRight(validBases, correctedOffset);
        AceAssembledReadBuilder aceReadBuilder = this.createNewAceReadBuilder(readId, validBases, correctedOffset, dir, clearRange, phdInfo, ungappedFullLength);
        this.aceReadBuilderMap.put(readId, aceReadBuilder);
        return this;
    }

    private AceAssembledReadBuilder createNewAceReadBuilder(String readId, NucleotideSequence validBases, int offset, Direction dir, Range clearRange, PhdInfo phdInfo, int ungappedFullLength) {
        return DefaultAceAssembledRead.createBuilder(readId, validBases, offset, dir, clearRange, phdInfo, ungappedFullLength, this);
    }

    private void adjustContigLeftAndRight(NucleotideSequence validBases, int offset) {
        this.adjustContigLeft(offset);
        this.adjustContigRight(validBases, offset);
    }

    private void adjustContigRight(NucleotideSequence validBases, int offset) {
        int endOfNewRead = offset + (int)validBases.getLength() - 1;
        this.adjustContigRight(endOfNewRead);
    }

    private void adjustContigRight(int endOfNewRead) {
        if (this.contigRight == -1 || endOfNewRead > this.contigRight) {
            this.contigRight = endOfNewRead;
        }
    }

    private void adjustContigLeft(int offset) {
        if (this.contigLeft == -1 || offset < this.contigLeft) {
            this.contigLeft = offset;
        }
    }

    void updatedReadRange(String id, long begin, long end) {
        if (this.aceReadBuilderMap.containsKey(id)) {
            this.adjustContigLeft((int)begin);
            this.adjustContigRight((int)end);
        }
    }

    @Override
    public NucleotideSequenceBuilder getConsensusBuilder() {
        return this.mutableConsensus;
    }

    @Override
    public AceContig build() {
        if (this.built) {
            throw new IllegalStateException("this contig has already been built");
        }
        if (this.numberOfReads() == 0) {
            this.built = true;
            return new DefaultAceContigImpl(this.contigId, new NucleotideSequenceBuilder().build(), Collections.emptySet(), this.complemented, new QualitySequenceBuilder().build());
        }
        if (this.consensusCaller != null) {
            this.recallConsensusNow();
        }
        TreeSet<AceAssembledRead> placedReads = new TreeSet<AceAssembledRead>(ConsedReadComparator.INSTANCE);
        this.contigLeft = Math.max(this.contigLeft, 0);
        this.contigRight = Math.min(this.contigRight, (int)this.mutableConsensus.getLength() - 1);
        Range contigTrimRange = Range.of(this.contigLeft, (long)this.contigRight);
        NucleotideSequence validConsensus = this.mutableConsensus.copy().trim(contigTrimRange).build();
        for (AceAssembledReadBuilder aceReadBuilder : this.aceReadBuilderMap.values()) {
            int newOffset = (int)aceReadBuilder.getBegin() - this.contigLeft;
            ((DefaultAceAssembledRead.Builder)aceReadBuilder).setParentContigBuilder(null);
            aceReadBuilder.setStartOffset(newOffset);
            placedReads.add((AceAssembledRead)aceReadBuilder.build(validConsensus));
        }
        if (this.mutableConsensusQualities == null) {
            if (this.computeConsensusQualities) {
                if (this.qualityDataStore == null) {
                    throw new NullPointerException("quality datastore can not be null");
                }
                try {
                    this.mutableConsensusQualities = new QualitySequenceBuilder(ConsedConsensusQualityComputer.computeConsensusQualities(this.mutableConsensus.build(), placedReads, this.qualityDataStore));
                }
                catch (DataStoreException e) {
                    throw new IllegalStateException("error computing consensus quality sequence", e);
                }
            } else {
                this.mutableConsensusQualities = this.createDefaultQualitySequenceBuilder((int)this.mutableConsensus.getUngappedLength());
            }
        } else {
            long ungappedLength;
            long qualLength = this.mutableConsensusQualities.getLength();
            if (qualLength != (ungappedLength = this.mutableConsensus.getUngappedLength())) {
                throw new IllegalStateException("given consensus quality length does not match ungapped consensus length");
            }
        }
        NucleotideSequence fullConsensus = this.mutableConsensus.build();
        Range ungappedContigTrimRange = Range.of(fullConsensus.getUngappedOffsetFor(this.contigLeft), (long)fullConsensus.getUngappedOffsetFor(this.contigRight));
        QualitySequence consensusQualitySequence = this.mutableConsensusQualities.trim(ungappedContigTrimRange).build();
        this.built = true;
        this.aceReadBuilderMap.clear();
        this.initialConsensus = null;
        return new DefaultAceContigImpl(this.contigId, validConsensus, placedReads, this.complemented, consensusQualitySequence);
    }

    public AceContigBuilder recallConsensusNow() {
        SliceBuilder builder;
        if (this.consensusCaller == null) {
            throw new IllegalStateException("must set consensus caller");
        }
        SliceBuilder[] builders = this.mutableConsensus == null ? this.initializeSliceBuilders(this.contigRight + 1) : this.initializeSliceBuilders(this.mutableConsensus.build());
        for (AceAssembledReadBuilder aceReadBuilder : this.aceReadBuilderMap.values()) {
            int start = (int)aceReadBuilder.getBegin();
            String id = aceReadBuilder.getId();
            Direction dir = aceReadBuilder.getDirection();
            QualitySequence fullQualities = null;
            if (this.qualityDataStore != null) {
                try {
                    fullQualities = (QualitySequence)this.qualityDataStore.get(id);
                }
                catch (DataStoreException e) {
                    throw new IllegalStateException("error recalling consensus", e);
                }
                if (fullQualities == null) {
                    throw new NullPointerException("could not get qualities for " + id);
                }
            }
            NucleotideSequence readSequence = aceReadBuilder.getCurrentNucleotideSequence();
            if (fullQualities == null) {
                byte[] qualArray = new byte[aceReadBuilder.getUngappedFullLength()];
                Arrays.fill(qualArray, DEFAULT_QUALITY.getQualityScore());
                fullQualities = new QualitySequenceBuilder(qualArray).build();
            }
            QualitySequence gappedValidRangequalities = this.qualityValueStrategy.getGappedValidRangeQualitySequenceFor(readSequence, fullQualities, aceReadBuilder.getClearRange(), dir);
            Iterator baseIter = readSequence.iterator();
            Iterator qualIter = gappedValidRangequalities.iterator();
            int i = 0;
            while (baseIter.hasNext()) {
                Nucleotide base = (Nucleotide)baseIter.next();
                PhredQuality quality = (PhredQuality)qualIter.next();
                builders[start + i].add(id, base, quality, dir);
                ++i;
            }
        }
        if (this.mutableConsensus == null) {
            this.mutableConsensus = new NucleotideSequenceBuilder(builders.length);
            for (int i = 0; i < builders.length; ++i) {
                builder = builders[i];
                Slice slice = builder.build();
                this.mutableConsensus.append(this.consensusCaller.callConsensus(slice).getConsensus());
            }
        } else {
            for (int i = 0; i < builders.length; ++i) {
                builder = builders[i];
                if (builder.getCurrentCoverageDepth() <= 0) continue;
                Slice slice = builder.build();
                this.mutableConsensus.replace(i, this.consensusCaller.callConsensus(slice).getConsensus());
            }
        }
        return this;
    }

    private SliceBuilder[] initializeSliceBuilders(int length) {
        SliceBuilder[] builders = new SliceBuilder[length];
        for (int i = 0; i < length; ++i) {
            builders[i] = new SliceBuilder();
        }
        return builders;
    }

    private SliceBuilder[] initializeSliceBuilders(NucleotideSequence consensus) {
        SliceBuilder[] builders = new SliceBuilder[(int)consensus.getLength()];
        int i = 0;
        Iterator iter = consensus.iterator();
        while (iter.hasNext()) {
            builders[i++] = new SliceBuilder().setConsensus((Nucleotide)iter.next());
        }
        return builders;
    }

    public SortedMap<Range, AceContigBuilder> split(Collection<Range> rangesToKeep) {
        TreeMap<Range, AceContigBuilder> splitContigs = new TreeMap<Range, AceContigBuilder>(Range.Comparators.ARRIVAL);
        CoverageMap<AceAssembledReadBuilder> coverageMap = new CoverageMapBuilder<AceAssembledReadBuilder>(this.aceReadBuilderMap.values()).build();
        for (Range rangeTokeep : rangesToKeep) {
            AceContigBuilder splitContig;
            if (this.mutableConsensus == null) {
                splitContig = new AceContigBuilder(this.contigId, this.consensusCaller);
            } else {
                NucleotideSequence contigConsensus = this.mutableConsensus.copy().trim(rangeTokeep).build();
                splitContig = new AceContigBuilder(this.contigId, contigConsensus);
                splitContig.consensusCaller = this.consensusCaller;
            }
            splitContig.qualityDataStore = this.qualityDataStore;
            splitContig.qualityValueStrategy = this.qualityValueStrategy;
            HashSet<String> contigReads = new HashSet<String>();
            for (CoverageRegion<AceAssembledReadBuilder> region : coverageMap.getRegionsWhichIntersect(rangeTokeep)) {
                for (AceAssembledReadBuilder read : region) {
                    contigReads.add(read.getId());
                }
            }
            for (String readId : contigReads) {
                AceAssembledReadBuilder readBuilder = this.aceReadBuilderMap.get(readId).copy();
                Range.Builder readTrimRangeBuilder = new Range.Builder(readBuilder.asRange().intersection(rangeTokeep)).shift(-readBuilder.getBegin());
                NucleotideSequence untrimmedReadSequence = readBuilder.getCurrentNucleotideSequence();
                int firstNonGapTrimOffset = AssemblyUtil.getRightFlankingNonGapIndex(untrimmedReadSequence, (int)readTrimRangeBuilder.getBegin());
                int lastNonGapTrimOffset = AssemblyUtil.getLeftFlankingNonGapIndex(untrimmedReadSequence, (int)readTrimRangeBuilder.getEnd());
                ((DefaultAceAssembledRead.Builder)readBuilder).setParentContigBuilder(null);
                readBuilder.trim(Range.of(firstNonGapTrimOffset, (long)lastNonGapTrimOffset));
                splitContig.addRead(readId, readBuilder.getCurrentNucleotideSequence(), (int)(readBuilder.getBegin() - rangeTokeep.getBegin()), readBuilder.getDirection(), readBuilder.getClearRange(), readBuilder.getPhdInfo(), readBuilder.getUngappedFullLength());
            }
            splitContigs.put(rangeTokeep, splitContig);
        }
        return splitContigs;
    }

    private static final class DefaultAceContigImpl
    implements AceContig {
        private final boolean complemented;
        private final QualitySequence consensusQualities;
        private final Contig<AceAssembledRead> contig;

        private DefaultAceContigImpl(String id, NucleotideSequence consensus, Set<AceAssembledRead> reads, boolean complemented, QualitySequence consensusQualities) {
            this.contig = new DefaultContig<AceAssembledRead>(id, consensus, reads);
            this.complemented = complemented;
            this.consensusQualities = consensusQualities;
        }

        @Override
        public ThrowingStream<AceAssembledRead> reads() {
            return this.contig.reads();
        }

        @Override
        public QualitySequence getConsensusQualitySequence() {
            return this.consensusQualities;
        }

        @Override
        public boolean isComplemented() {
            return this.complemented;
        }

        @Override
        public String getId() {
            return this.contig.getId();
        }

        @Override
        public long getNumberOfReads() {
            return this.contig.getNumberOfReads();
        }

        @Override
        public NucleotideSequence getConsensusSequence() {
            return this.contig.getConsensusSequence();
        }

        @Override
        public AceAssembledRead getRead(String id) {
            return this.contig.getRead(id);
        }

        @Override
        public boolean containsRead(String readId) {
            return this.contig.containsRead(readId);
        }

        @Override
        public StreamingIterator<AceAssembledRead> getReadIterator() {
            return this.contig.getReadIterator();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.complemented ? 1231 : 1237);
            result = 31 * result + this.contig.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AceContig)) {
                return false;
            }
            AceContig other = (AceContig)obj;
            if (this.complemented != other.isComplemented()) {
                return false;
            }
            if (!this.contig.getId().equals(other.getId())) {
                return false;
            }
            if (!this.contig.getConsensusSequence().equals(other.getConsensusSequence())) {
                return false;
            }
            if (this.contig.getNumberOfReads() != other.getNumberOfReads()) {
                return false;
            }
            try (StreamingIterator<AceAssembledRead> readIter = this.contig.getReadIterator();){
                while (readIter.hasNext()) {
                    AceAssembledRead read = readIter.next();
                    String readId = read.getId();
                    if (!other.containsRead(readId)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (read.equals(other.getRead(readId))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
    }

    private static enum ConsedReadComparator implements Comparator<AceAssembledRead>
    {
        INSTANCE;


        @Override
        public int compare(AceAssembledRead o1, AceAssembledRead o2) {
            int comp = Range.Comparators.ARRIVAL.compare(o1.asRange(), o2.asRange());
            if (comp != 0) {
                return comp;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

