/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.Date;
import org.jcvi.jillion.assembly.consed.ace.AceTag;

abstract class AbstractDefaultAceTag
implements AceTag {
    private final String type;
    private final String creator;
    private final Date creationDate;
    private final String data;

    public AbstractDefaultAceTag(String type, String creator, Date creationDate, String data) {
        if (type == null) {
            throw new NullPointerException("type can not be null");
        }
        if (creator == null) {
            throw new NullPointerException("creator can not be null");
        }
        if (creationDate == null) {
            throw new NullPointerException("creationDate can not be null");
        }
        this.type = type;
        this.creator = creator;
        this.creationDate = new Date(creationDate.getTime());
        this.data = data;
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.creationDate.getTime());
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getData() {
        return this.data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.creationDate.hashCode();
        result = 31 * result + this.creator.hashCode();
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractDefaultAceTag)) {
            return false;
        }
        AbstractDefaultAceTag other = (AbstractDefaultAceTag)obj;
        if (!this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (!this.creator.equals(other.creator)) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return this.type.equals(other.type);
    }
}

