/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledRead;
import org.jcvi.jillion.assembly.consed.ace.AceBaseSegment;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceFileUtil;
import org.jcvi.jillion.assembly.consed.ace.AceFileWriter;
import org.jcvi.jillion.assembly.consed.ace.BaseSegmentUtil;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.util.JillionUtil;

@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\n character is required for .ace format (?) we don't want to accidentally put in a \r\n on diffent OSand break consed")
abstract class AbstractAceFileWriter
implements AceFileWriter {
    protected static final String CR = "\n";
    protected static final int DEFAULT_BUFFER_SIZE = 32768;
    private final boolean createBsRecords;

    protected AbstractAceFileWriter(boolean createBsRecords) {
        this.createBsRecords = createBsRecords;
    }

    protected void writeAceContigHeader(Writer tempWriter, String contigId, long consensusLength, long numberOfReads, int numberOfBaseSegments, boolean isComplimented) throws IOException {
        String formattedHeader = String.format("CO %s %d %d %d %s\n", contigId, consensusLength, numberOfReads, numberOfBaseSegments, isComplimented ? "C" : "U");
        tempWriter.write(formattedHeader);
    }

    public void write(Writer tempWriter, AceContig contig, PhdDataStore phdDataStore) throws IOException {
        NucleotideSequence consensus = contig.getConsensusSequence();
        this.writeAceContigHeader(tempWriter, contig.getId(), consensus.getLength(), contig.getNumberOfReads(), 0, contig.isComplemented());
        tempWriter.write(String.format("%s\n\n\n", AceFileUtil.convertToAcePaddedBasecalls(consensus)));
        this.writeConsensusQualities(tempWriter, contig.getConsensusQualitySequence());
        tempWriter.write(CR);
        List<IdAlignedReadInfo> assembledFroms = IdAlignedReadInfo.getSortedAssembledFromsFor(contig);
        StringBuilder assembledFromBuilder = new StringBuilder();
        StringBuilder placedReadBuilder = new StringBuilder();
        for (IdAlignedReadInfo assembledFrom : assembledFroms) {
            String id = assembledFrom.getId();
            AceAssembledRead realPlacedRead = (AceAssembledRead)contig.getRead(id);
            long fullLength = realPlacedRead.getReadInfo().getUngappedFullLength();
            assembledFromBuilder.append(this.createAssembledFromRecord(realPlacedRead, fullLength));
            placedReadBuilder.append(this.createPlacedReadRecord(realPlacedRead, phdDataStore));
        }
        placedReadBuilder.append(CR);
        tempWriter.write(assembledFromBuilder.toString());
        if (this.createBsRecords) {
            for (AceBaseSegment bs : BaseSegmentUtil.computeBestSegmentsFor(contig)) {
                Range gappedRange = bs.getGappedConsensusRange();
                tempWriter.write(String.format("BS %d %d %s\n", gappedRange.getBegin(Range.CoordinateSystem.RESIDUE_BASED), gappedRange.getEnd(Range.CoordinateSystem.RESIDUE_BASED), bs.getReadName()));
            }
        }
        tempWriter.write(CR);
        tempWriter.write(placedReadBuilder.toString());
    }

    private void writeConsensusQualities(Writer tempWriter, QualitySequence consensusQualities) throws IOException {
        if (consensusQualities == null) {
            throw new NullPointerException("consensus qualities can not be null");
        }
        int qualityLength = (int)consensusQualities.getLength();
        int numberOfLines = qualityLength / 50 + 1;
        StringBuilder formattedString = new StringBuilder(3 + 3 * qualityLength + numberOfLines);
        formattedString.append("BQ\n");
        Iterator iter = consensusQualities.iterator();
        for (int i = 1; i < qualityLength; ++i) {
            formattedString.append(String.format("%02d", ((PhredQuality)iter.next()).getQualityScore()));
            if (i % 50 == 0) {
                formattedString.append(CR);
                continue;
            }
            formattedString.append(' ');
        }
        formattedString.append(String.format("%02d%s", ((PhredQuality)iter.next()).getQualityScore(), CR));
        tempWriter.write(formattedString.toString());
    }

    private String createAssembledFromRecord(AceAssembledRead read, long fullLength) {
        IdAlignedReadInfo assembledFrom = IdAlignedReadInfo.createFrom(read, fullLength);
        return String.format("AF %s %s %d\n", assembledFrom.getId(), assembledFrom.getDirection() == Direction.FORWARD ? "U" : "C", assembledFrom.getStartOffset());
    }

    private String createPlacedReadRecord(AceAssembledRead read, PhdDataStore phdDatastore) throws IOException {
        Phd phd;
        try {
            phd = (Phd)phdDatastore.get(read.getId());
        }
        catch (DataStoreException e) {
            throw new IOException("error writing quality values for read " + read.getId(), e);
        }
        return AceFileUtil.createAcePlacedReadRecord(read.getId(), read, phd, read.getPhdInfo());
    }

    private static final class IdAlignedReadInfo
    implements Comparable<IdAlignedReadInfo> {
        private static final int TO_STRING_BUFFER_SIZE = 30;
        private final String id;
        private final byte dir;
        private final int startOffset;
        private static final Direction[] DIRECTION_VALUES = Direction.values();

        public static IdAlignedReadInfo createFrom(AssembledRead read, long ungappedFullLength) {
            Direction dir = read.getDirection();
            Range readValidRange = read.getReadInfo().getValidRange();
            Range validRange = dir == Direction.REVERSE ? AssemblyUtil.reverseComplementValidRange(readValidRange, ungappedFullLength) : readValidRange;
            return new IdAlignedReadInfo(read.getId(), (int)(read.getGappedStartOffset() - validRange.getBegin() + 1L), dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<IdAlignedReadInfo> getSortedAssembledFromsFor(Contig<AceAssembledRead> contig) {
            ArrayList<IdAlignedReadInfo> assembledFroms = new ArrayList<IdAlignedReadInfo>((int)contig.getNumberOfReads());
            StreamingIterator<AceAssembledRead> iter = null;
            try {
                iter = contig.getReadIterator();
                while (iter.hasNext()) {
                    AceAssembledRead read = iter.next();
                    long fullLength = read.getReadInfo().getUngappedFullLength();
                    assembledFroms.add(IdAlignedReadInfo.createFrom(read, fullLength));
                }
            }
            finally {
                IOUtil.closeAndIgnoreErrors(iter);
            }
            Collections.sort(assembledFroms);
            return assembledFroms;
        }

        private IdAlignedReadInfo(String id, int startOffset, Direction dir) {
            this.id = id;
            this.dir = (byte)dir.ordinal();
            this.startOffset = startOffset;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IdAlignedReadInfo)) {
                return false;
            }
            IdAlignedReadInfo other = (IdAlignedReadInfo)obj;
            return this.id.equals(other.getId());
        }

        public String getId() {
            return this.id;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public Direction getDirection() {
            return DIRECTION_VALUES[this.dir];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(30);
            builder.append(this.id).append(' ').append(this.startOffset).append("is complemented? ").append(this.getDirection() == Direction.REVERSE);
            return builder.toString();
        }

        @Override
        public int compareTo(IdAlignedReadInfo o) {
            return JillionUtil.compare(this.getStartOffset(), o.getStartOffset());
        }
    }
}

