/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AlignedReadInfo;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.MapUtil;

public abstract class AbstractAceContigBuilderVisitor
implements AceContigVisitor {
    private final String contigId;
    private final NucleotideSequenceBuilder consensusBuilder;
    private AceContigBuilder builder;
    private final Map<String, AlignedReadInfo> currentAlignedReadInfoMap;

    public AbstractAceContigBuilderVisitor(String contigId, int consensusLength, int numberOfReads) {
        this.contigId = contigId;
        this.consensusBuilder = new NucleotideSequenceBuilder(consensusLength);
        int mapCapacity = MapUtil.computeMinHashMapSizeWithoutRehashing(numberOfReads);
        this.currentAlignedReadInfoMap = new HashMap<String, AlignedReadInfo>(mapCapacity);
    }

    @Override
    public final void visitBasesLine(String mixedCaseBasecalls) {
        this.consensusBuilder.append(mixedCaseBasecalls);
    }

    @Override
    public void visitConsensusQualities(QualitySequence ungappedConsensusQualities) {
    }

    @Override
    public final void visitAlignedReadInfo(String readId, Direction dir, int gappedStartOffset) {
        this.createContigBuilderIfNeeded();
        AlignedReadInfo alignedInfo = new AlignedReadInfo(gappedStartOffset, dir);
        this.currentAlignedReadInfoMap.put(readId, alignedInfo);
    }

    private void createContigBuilderIfNeeded() {
        if (this.builder == null) {
            this.builder = new AceContigBuilder(this.contigId, this.consensusBuilder.build(), this.currentAlignedReadInfoMap.size());
        }
    }

    @Override
    public void visitBaseSegment(Range gappedConsensusRange, String readId) {
    }

    protected void readIgnored(String readId, String reason) {
    }

    @Override
    public final AceContigReadVisitor visitBeginRead(String readId, int gappedLength) {
        return new ReadVisitor(readId, gappedLength, this.currentAlignedReadInfoMap.get(readId));
    }

    @Override
    public final void visitEnd() {
        this.createContigBuilderIfNeeded();
        this.visitContig(this.builder);
    }

    protected abstract void visitContig(AceContigBuilder var1);

    @Override
    public void halted() {
    }

    private final class ReadVisitor
    implements AceContigReadVisitor {
        private final String readId;
        private final AlignedReadInfo alignedInfo;
        private final NucleotideSequenceBuilder fullLengthSequenceBuilder;
        private boolean skipCurrentRead = false;
        private NucleotideSequence validSequence;
        private int ungappedFullLength;
        private int currentOffset;
        private Range currentClearRange;
        private PhdInfo currentPhdInfo;

        public ReadVisitor(String readId, int fullGappedLength, AlignedReadInfo alignedInfo) {
            this.readId = readId;
            this.alignedInfo = alignedInfo;
            this.fullLengthSequenceBuilder = new NucleotideSequenceBuilder(fullGappedLength);
        }

        @Override
        public void visitQualityLine(int qualLeft, int qualRight, int alignLeft, int alignRight) {
            ConsedUtil.ClipPointsType clipPointsType = ConsedUtil.ClipPointsType.getType(qualLeft, qualRight, alignLeft, alignRight);
            if (clipPointsType != ConsedUtil.ClipPointsType.VALID) {
                this.handleInvalidRead(qualLeft, qualRight, clipPointsType);
                return;
            }
            Range gappedValidRange = Range.of(Range.CoordinateSystem.RESIDUE_BASED, alignLeft, alignRight);
            this.currentOffset = this.computeReadOffset(gappedValidRange.getBegin(Range.CoordinateSystem.RESIDUE_BASED));
            this.validSequence = this.fullLengthSequenceBuilder.copy().trim(gappedValidRange).build();
            NucleotideSequence gappedFullLengthSequence = this.fullLengthSequenceBuilder.build();
            int numberOfFullLengthGaps = gappedFullLengthSequence.getNumberOfGaps();
            this.ungappedFullLength = (int)gappedFullLengthSequence.getLength() - numberOfFullLengthGaps;
            int ungappedClearLeft = gappedFullLengthSequence.getUngappedOffsetFor((int)gappedValidRange.getBegin());
            int ungappedClearRight = gappedFullLengthSequence.getUngappedOffsetFor((int)gappedValidRange.getEnd());
            Range ungappedValidRange = Range.of(ungappedClearLeft, (long)ungappedClearRight);
            if (this.alignedInfo.getDirection() == Direction.REVERSE) {
                ungappedValidRange = AssemblyUtil.reverseComplementValidRange(ungappedValidRange, this.ungappedFullLength);
            }
            this.currentClearRange = ungappedValidRange;
        }

        private void handleInvalidRead(int qualLeft, int qualRight, ConsedUtil.ClipPointsType clipPointsType) {
            this.skipCurrentRead = true;
            switch (clipPointsType) {
                case NEGATIVE_VALID_RANGE: {
                    AbstractAceContigBuilderVisitor.this.readIgnored(this.readId, String.format("has a negative valid range %d%n", qualRight - qualLeft));
                    break;
                }
                case ALL_LOW_QUALITY: {
                    AbstractAceContigBuilderVisitor.this.readIgnored(this.readId, "entire read is low quality");
                    break;
                }
                case NO_HIGH_QUALITY_ALIGNMENT_INTERSECTION: {
                    AbstractAceContigBuilderVisitor.this.readIgnored(this.readId, "read does not have a high quality aligned range");
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown clipPointType " + (Object)((Object)clipPointsType));
                }
            }
        }

        private int computeReadOffset(long startPosition) {
            return this.alignedInfo.getStartOffset() + (int)startPosition - 2;
        }

        @Override
        public void visitTraceDescriptionLine(String traceName, String phdName, Date date) {
            this.currentPhdInfo = new PhdInfo(traceName, phdName, date);
        }

        @Override
        public void visitBasesLine(String mixedCaseBasecalls) {
            this.fullLengthSequenceBuilder.append(mixedCaseBasecalls);
        }

        @Override
        public void visitEnd() {
            if (this.skipCurrentRead) {
                return;
            }
            if (this.validSequence == null) {
                throw new IllegalStateException(String.format("Incomplete visitation : did not visit quality line for read %s", this.readId));
            }
            if (this.currentPhdInfo == null) {
                throw new IllegalStateException(String.format("Incomplete visitation : did not visit trace line for read %s", this.readId));
            }
            AbstractAceContigBuilderVisitor.this.builder.addRead(this.readId, this.validSequence, this.currentOffset, this.alignedInfo.getDirection(), this.currentClearRange, this.currentPhdInfo, this.ungappedFullLength);
        }

        @Override
        public void halted() {
        }
    }
}

