/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.jcvi.jillion.assembly.consed.PhdConsedTransformerHelper;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallWriter;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdFileDataStoreBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdWriter;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.DateUtil;

class PhdBallConsedTransformerHelper
implements PhdConsedTransformerHelper {
    private final File phdDir;
    private final File phdBallFile;
    private final PhdWriter phdBallWriter;

    PhdBallConsedTransformerHelper(File consedRootDir) throws IOException {
        this.phdDir = new File(consedRootDir, "phdball_dir");
        IOUtil.mkdirs(this.phdDir);
        this.phdBallFile = new File(this.phdDir, "phd.ball.1");
        this.phdBallWriter = new PhdBallWriter(this.phdBallFile);
    }

    @Override
    public PhdInfo writePhd(Phd phd, Date phdDate) throws IOException {
        PhdInfo info = new PhdInfo(phd.getId(), String.format("%s.phd.1", phd.getId()), phdDate);
        this.phdBallWriter.write(phd);
        return info;
    }

    @Override
    public PhdDataStore createDataStore() throws IOException {
        this.phdBallWriter.close();
        return new PhdFileDataStoreBuilder(this.phdBallFile).build();
    }

    @Override
    public WholeAssemblyAceTag createPhdBallWholeAssemblyTag() {
        return new WholeAssemblyAceTag("phdBall", "consed", DateUtil.getCurrentDate(), "../phdball_dir/" + this.phdBallFile.getName());
    }
}

