/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.jcvi.jillion.assembly.consed.PhdConsedTransformerHelper;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallWriter;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdDirDataStore;
import org.jcvi.jillion.core.io.IOUtil;

class IndividualPhdConsedTransformerHelper
implements PhdConsedTransformerHelper {
    private final File phdDir;

    IndividualPhdConsedTransformerHelper(File consedRootDir) throws IOException {
        this.phdDir = new File(consedRootDir, "phd_dir");
        IOUtil.mkdirs(this.phdDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PhdInfo writePhd(Phd phd, Date phdDate) throws IOException {
        PhdInfo phdInfo;
        String id = phd.getId();
        File phdFile = new File(this.phdDir, String.format("%s.phd.1", id));
        PhdInfo info = new PhdInfo(phd.getId(), phdFile.getName(), phdDate);
        PhdBallWriter writer = null;
        try {
            writer = new PhdBallWriter(phdFile);
            writer.write(phd);
            phdInfo = info;
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(writer);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)writer);
        return phdInfo;
    }

    @Override
    public PhdDataStore createDataStore() throws IOException {
        return new PhdDirDataStore(this.phdDir);
    }

    @Override
    public WholeAssemblyAceTag createPhdBallWholeAssemblyTag() {
        return null;
    }
}

