/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledReadBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.ConsensusAceTag;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdDirDataStore;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageMapBuilder;
import org.jcvi.jillion.assembly.util.CoverageRegion;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Ranges;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public final class ConsedUtil {
    private static final String CONTIG_RENAME_TAG_TYPE = "contigName";
    private static final Pattern CONTIG_RENAME_PATTERN = Pattern.compile("U(\\w+)");
    private static final Pattern CONSED_ACE_PATTERN = Pattern.compile("((.+?)\\.)?ace(\\.(\\d+))?$");
    private static final Pattern CONSED_ACE_VERSION_PATTERN = Pattern.compile("((.+?)\\.)?ace\\.(\\d+)$");
    private static final Pattern ACE_CONTIG_ID_PATTERN = Pattern.compile("(\\S+)_(\\d+)_\\d+");

    private ConsedUtil() {
    }

    public static String convertAceGapsToContigGaps(String basecallsWithAceGaps) {
        return basecallsWithAceGaps.replace('*', '-');
    }

    public static PhdInfo generateDefaultPhdInfoFor(File traceFile, String readId, Date phdDate) {
        String extension;
        String id = traceFile == null ? readId : ("sff".equals(extension = FileUtil.getExtension(traceFile.getName())) ? "sff:" + traceFile.getName() + ":" + readId : ("scf".equals(extension) ? traceFile.getName() : readId));
        return new PhdInfo(id, readId + ".phd.1", phdDate);
    }

    public static SortedMap<Range, AceContig> split0xContig(AceContigBuilder contigBuilder, boolean adjustIdCoordinates) {
        Matcher matcher;
        ArrayList<Range> coveredRegions = new ArrayList<Range>();
        NucleotideSequence unSplitConsensus = contigBuilder.getConsensusBuilder().build();
        CoverageMap<AceAssembledReadBuilder> coverageMap = new CoverageMapBuilder<AceAssembledReadBuilder>(contigBuilder.getAllAssembledReadBuilders()).build();
        for (CoverageRegion coverageRegion : coverageMap) {
            if (coverageRegion.getCoverageDepth() <= 0) continue;
            Range contigRange = coverageRegion.asRange();
            coveredRegions.add(contigRange);
        }
        List<Range> contigRanges = Ranges.merge(coveredRegions);
        TreeMap<Range, AceContig> treeMap = new TreeMap<Range, AceContig>(Range.Comparators.ARRIVAL);
        String originalContigId = contigBuilder.getContigId();
        int oldStart = 1;
        if (adjustIdCoordinates && (matcher = ACE_CONTIG_ID_PATTERN.matcher(originalContigId)).matches()) {
            originalContigId = matcher.group(1);
            oldStart = Integer.parseInt(matcher.group(2));
        }
        if (contigRanges.size() == 1) {
            Range gappedContigRange = contigRanges.get(0);
            Range ungappedContigRange = AssemblyUtil.toUngappedRange(unSplitConsensus, gappedContigRange);
            if (ungappedContigRange.getLength() < unSplitConsensus.getUngappedLength()) {
                String newContigId = ConsedUtil.computeSplitContigId(unSplitConsensus, originalContigId, oldStart, gappedContigRange);
                contigBuilder.setContigId(newContigId);
            }
            treeMap.put(gappedContigRange, contigBuilder.build());
            return treeMap;
        }
        for (Map.Entry<Range, AceContigBuilder> splitContigEntry : contigBuilder.split(contigRanges).entrySet()) {
            AceContigBuilder splitContigBuilder = splitContigEntry.getValue();
            Range contigRange = splitContigEntry.getKey();
            String newContigId = ConsedUtil.computeSplitContigId(unSplitConsensus, originalContigId, oldStart, contigRange);
            splitContigBuilder.setContigId(newContigId);
            treeMap.put(contigRange, splitContigBuilder.build());
        }
        return treeMap;
    }

    private static String computeSplitContigId(NucleotideSequence consensus, String originalContigId, int oldStart, Range contigRange) {
        String contigId = String.format("%s_%d_%d", originalContigId, oldStart + consensus.getUngappedOffsetFor((int)contigRange.getBegin()), oldStart + consensus.getUngappedOffsetFor((int)contigRange.getEnd()));
        return contigId;
    }

    public static boolean isContigRename(ConsensusAceTag consensusTag) {
        return CONTIG_RENAME_TAG_TYPE.equals(consensusTag.getType());
    }

    public static String getRenamedContigId(ConsensusAceTag contigRenameTag) {
        if (!ConsedUtil.isContigRename(contigRenameTag)) {
            throw new IllegalArgumentException("not a contig rename");
        }
        String data = contigRenameTag.getData();
        Matcher matcher = CONTIG_RENAME_PATTERN.matcher(data);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("consensus tag does not contain rename info : " + contigRenameTag);
    }

    public static File getAceFile(File editDir, String filenamePrefix, int version) {
        if (filenamePrefix == null) {
            throw new NullPointerException("file name prefix can not be null");
        }
        if (version < 0) {
            throw new IllegalArgumentException("version must be >= 1");
        }
        if (editDir == null) {
            return null;
        }
        File aceFile = new File(editDir, String.format("%s.ace.%d", filenamePrefix, version));
        if (aceFile.exists()) {
            return aceFile;
        }
        return null;
    }

    public static File getLatestAceFile(File editDir, final String filenamePrefix) {
        if (editDir == null || !editDir.exists()) {
            return null;
        }
        int highestAceFileVersion = Integer.MIN_VALUE;
        File highestAceFile = null;
        for (File file : editDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.startsWith(filenamePrefix) && CONSED_ACE_PATTERN.matcher(name).find();
            }
        })) {
            int version = ConsedUtil.getAceVersionFor(file);
            if (version <= highestAceFileVersion) continue;
            highestAceFileVersion = version;
            highestAceFile = file;
        }
        return highestAceFile;
    }

    public static File generateNextAceFileFor(File editDir, String filenamePrefix) {
        File latestAceFile = ConsedUtil.getLatestAceFile(editDir, filenamePrefix);
        if (latestAceFile == null) {
            return new File(editDir, filenamePrefix + ".ace.1");
        }
        return new File(editDir, ConsedUtil.generateNextAceVersionNameFor(latestAceFile));
    }

    public static File getPhdDirFor(File consedDir) {
        ConsedUtil.verifyNotNull(consedDir);
        return new File(consedDir, "phd_dir");
    }

    private static void verifyNotNull(File consedDir) {
        if (consedDir == null) {
            throw new NullPointerException("consedDir can not be null");
        }
    }

    public static File getEditDirFor(File consedDir) {
        ConsedUtil.verifyNotNull(consedDir);
        return new File(consedDir, "edit_dir");
    }

    public static File getChromatDirFor(File consedDir) {
        ConsedUtil.verifyNotNull(consedDir);
        return new File(consedDir, "chromat_dir");
    }

    public static File getPhdBallDirFor(File consedDir) {
        ConsedUtil.verifyNotNull(consedDir);
        return new File(consedDir, "phdball_dir");
    }

    public static int getAceVersionFor(File consedAceFile) {
        String name = consedAceFile.getName();
        Matcher matcher = CONSED_ACE_VERSION_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("could not parse version from " + name);
        }
        return Integer.parseInt(matcher.group(3));
    }

    public static File getConsedDirFor(File aceFile) {
        return aceFile.getParentFile().getParentFile();
    }

    public static String getAcePrefixFor(File aceFile) {
        return ConsedUtil.getAcePrefixFor(aceFile.getName());
    }

    public static String getAcePrefixFor(String aceFileName) {
        return aceFileName.replaceAll("\\.ace(\\.\\d+)?$", "");
    }

    public static String generateNextAceVersionNameFor(File consedAceFile) {
        String name = consedAceFile.getName();
        Matcher matcher = CONSED_ACE_VERSION_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("could not parse version from " + name);
        }
        String prefix = matcher.group(2);
        int version = Integer.parseInt(matcher.group(3));
        return String.format("%sace.%d", prefix == null ? "" : prefix + ".", version + 1);
    }

    public static PhdDataStore createPhdDataStoreFor(File consedDir) throws IOException {
        if (consedDir == null) {
            throw new NullPointerException("consed dir can not be null");
        }
        File phdDir = ConsedUtil.getPhdDirFor(consedDir);
        File phdballDir = ConsedUtil.getPhdBallDirFor(consedDir);
        ArrayList<PhdDirDataStore> datastores = new ArrayList<PhdDirDataStore>();
        if (phdDir.exists()) {
            datastores.add(new PhdDirDataStore(phdDir));
        }
        if (phdballDir.exists()) {
            datastores.add(new PhdDirDataStore(phdballDir));
        }
        return DataStore.chain(PhdDataStore.class, datastores);
    }

    public static enum ClipPointsType {
        VALID,
        NEGATIVE_VALID_RANGE,
        ALL_LOW_QUALITY,
        NO_HIGH_QUALITY_ALIGNMENT_INTERSECTION;


        public static ClipPointsType getType(int qualLeft, int qualRight, int alignLeft, int alignRight) {
            Range alignmentRange;
            if (qualLeft == -1 && qualRight == -1) {
                return ALL_LOW_QUALITY;
            }
            if (qualRight - qualLeft < 0) {
                return NEGATIVE_VALID_RANGE;
            }
            Range qualityRange = Range.of(Range.CoordinateSystem.RESIDUE_BASED, qualLeft, qualRight);
            if (qualityRange.intersects(alignmentRange = Range.of(Range.CoordinateSystem.RESIDUE_BASED, alignLeft, alignRight))) {
                return VALID;
            }
            return NO_HIGH_QUALITY_ALIGNMENT_INTERSECTION;
        }
    }
}

