/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.time.Clock;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jcvi.jillion.assembly.AssemblyTransformer;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.assembly.consed.AceAssemblyTransformerPostProcessor;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.IndividualPhdConsedTransformerHelper;
import org.jcvi.jillion.assembly.consed.PhdBallConsedTransformerHelper;
import org.jcvi.jillion.assembly.consed.PhdConsedTransformerHelper;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceFileWriter;
import org.jcvi.jillion.assembly.consed.ace.AceFileWriterBuilder;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdUtil;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public class ConsedAssemblyTransformerBuilder {
    public static final PhredQuality DEFAULT_QUALITY_VALUE = PhredQuality.valueOf(26);
    private final File rootDir;
    private final String filePrefix;
    private boolean createPhdBall = true;
    private File chromatInputDir = null;
    private byte defaultQualityValue = DEFAULT_QUALITY_VALUE.getQualityScore();
    private Clock clock = Clock.systemDefaultZone();
    private AceAssemblyTransformerPostProcessor postProcessor = null;

    public ConsedAssemblyTransformerBuilder(File consedRootDir, String filePrefix) {
        if (consedRootDir == null) {
            throw new NullPointerException("root dir can not be null");
        }
        if (filePrefix == null) {
            throw new NullPointerException("file prefix can not be null");
        }
        if (filePrefix.isEmpty()) {
            throw new IllegalArgumentException("file prefix can not be empty");
        }
        this.rootDir = consedRootDir;
        this.filePrefix = filePrefix;
    }

    public ConsedAssemblyTransformerBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock);
        this.clock = clock;
        return this;
    }

    public ConsedAssemblyTransformerBuilder createIndividualPhdFiles(boolean createIndividualPhdFiles) {
        this.createPhdBall = !createIndividualPhdFiles;
        return this;
    }

    public ConsedAssemblyTransformerBuilder inputChromatogramDir(File chromatDir) {
        this.chromatInputDir = chromatDir;
        return this;
    }

    public ConsedAssemblyTransformerBuilder postProcessor(AceAssemblyTransformerPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
        return this;
    }

    public ConsedAssemblyTransformerBuilder setDefaultQualityValue(int qualityValue) {
        PhredQuality qual = PhredQuality.valueOf(qualityValue);
        this.defaultQualityValue = qual.getQualityScore();
        return this;
    }

    public AssemblyTransformer build() throws IOException {
        return new ConsedAssemblyTransformer(this);
    }

    private static enum NullAceAssemblyTransformerPostProcessor implements AceAssemblyTransformerPostProcessor
    {
        INSTANCE;


        @Override
        public Map<String, AceContigBuilder> postProcess(Map<String, AceContigBuilder> builderMap, PhdDataStore phdDataStore) {
            return builderMap;
        }

        @Override
        public void postProcess(AceContig contig) {
        }
    }

    private static final class ConsedAssemblyTransformer
    implements AssemblyTransformer {
        private final File rootDir;
        private final File editDir;
        private final File chromatInputDir;
        private final File chromatDir;
        private final String filePrefix;
        private final AceAssemblyTransformerPostProcessor postProcessor;
        private final PhdConsedTransformerHelper phdHelper;
        private final byte defaultQualityValue;
        private final Map<String, AceContigBuilder> builderMap = new LinkedHashMap<String, AceContigBuilder>();
        private final Map<URI, Date> uriDates = new HashMap<URI, Date>();
        private final Map<URI, File> uri2File = new HashMap<URI, File>();
        private final Map<URI, Map<String, String>> comments = new HashMap<URI, Map<String, String>>();

        public ConsedAssemblyTransformer(ConsedAssemblyTransformerBuilder builder) throws IOException {
            this.rootDir = builder.rootDir;
            this.filePrefix = builder.filePrefix;
            this.chromatInputDir = builder.chromatInputDir;
            this.postProcessor = builder.postProcessor == null ? NullAceAssemblyTransformerPostProcessor.INSTANCE : builder.postProcessor;
            IOUtil.mkdirs(this.rootDir);
            this.editDir = new File(this.rootDir, "edit_dir");
            if (this.chromatInputDir == null) {
                this.chromatDir = null;
            } else {
                this.chromatDir = new File(this.rootDir, "chromat_dir");
                IOUtil.mkdirs(this.chromatDir);
            }
            this.phdHelper = builder.createPhdBall ? new PhdBallConsedTransformerHelper(this.rootDir) : new IndividualPhdConsedTransformerHelper(this.rootDir);
            this.defaultQualityValue = builder.defaultQualityValue;
            Date currentDate = new Date(builder.clock.millis());
            this.uriDates.put(null, currentDate);
            this.comments.put(null, this.computeRequiredCommentsFor(null, currentDate));
        }

        @Override
        public void referenceOrConsensus(String id, NucleotideSequence gappedReference) {
            if (this.builderMap.containsKey(id)) {
                throw new IllegalStateException("reference with id " + id + " already exists");
            }
            this.builderMap.put(id, new AceContigBuilder(id, gappedReference));
        }

        @Override
        public void endAssembly() {
            AceFileWriter aceWriter;
            PhdDataStore phdDataStore;
            try {
                phdDataStore = this.phdHelper.createDataStore();
            }
            catch (IOException e) {
                throw new IllegalStateException("error reading phd data", e);
            }
            Map<String, AceContigBuilder> updatedBuilders = this.postProcessor.postProcess(this.builderMap, phdDataStore);
            File outputAceFile = new File(this.editDir, String.format("%s.ace.1", this.filePrefix));
            try {
                aceWriter = new AceFileWriterBuilder(outputAceFile, phdDataStore).build();
            }
            catch (IOException e) {
                throw new IllegalStateException("error creating ace writer", e);
            }
            try {
                for (AceContigBuilder builder : updatedBuilders.values()) {
                    try {
                        for (Map.Entry<Range, AceContig> entry : ConsedUtil.split0xContig(builder, true).entrySet()) {
                            AceContig splitContig = entry.getValue();
                            this.postProcessor.postProcess(splitContig);
                            aceWriter.write(splitContig);
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("error writing assembly " + builder.getContigId(), e);
                    }
                }
                WholeAssemblyAceTag phdBallTag = this.phdHelper.createPhdBallWholeAssemblyTag();
                if (phdBallTag != null) {
                    aceWriter.write(phdBallTag);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("error creating ace tag", e);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)aceWriter);
            }
        }

        @Override
        public void notAligned(String id, NucleotideSequence nucleotideSequence, QualitySequence qualitySequence, PositionSequence positions, URI uri) {
        }

        @Override
        public void aligned(String readId, NucleotideSequence nucleotideSequence, QualitySequence qualitySequence, PositionSequence positions, URI sourceFileUri, String referenceId, long gappedStartOffset, Direction direction, NucleotideSequence gappedSequence, ReadInfo readInfo) {
            PhdInfo phdInfo;
            Map<String, String> requiredComments;
            Date phdDate;
            if (!this.builderMap.containsKey(referenceId)) {
                throw new IllegalStateException("unknown reference id " + referenceId);
            }
            if (gappedStartOffset > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("gapped start offset is > int max" + readId);
            }
            QualitySequence qualities = qualitySequence == null ? this.createDefaultQualitySequenceFor(nucleotideSequence) : qualitySequence;
            if (this.uriDates.containsKey(sourceFileUri)) {
                phdDate = this.uriDates.get(sourceFileUri);
                requiredComments = this.comments.get(sourceFileUri);
            } else {
                File file = new File(sourceFileUri);
                phdDate = new Date(file.lastModified());
                this.uriDates.put(sourceFileUri, phdDate);
                this.uri2File.put(sourceFileUri, file);
                if (file.getName().endsWith(".scf")) {
                    BufferedInputStream in = null;
                    BufferedOutputStream out = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(file));
                        File newFile = new File(this.chromatDir, FileUtil.getBaseName(file));
                        out = new BufferedOutputStream(new FileOutputStream(newFile));
                        IOUtil.copy(in, out);
                    }
                    catch (IOException e) {
                        try {
                            throw new IllegalStateException("error copying chromatogram file to chromat_dir", e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.closeAndIgnoreErrors(in, out);
                            throw throwable;
                        }
                    }
                    IOUtil.closeAndIgnoreErrors(in, out);
                }
                requiredComments = this.computeRequiredCommentsFor(this.uri2File.get(sourceFileUri), phdDate);
                this.comments.put(sourceFileUri, requiredComments);
            }
            PhdBuilder phdBuilder = new PhdBuilder(readId, nucleotideSequence, qualities).comments(requiredComments);
            if (positions == null) {
                phdBuilder.fakePeaks();
            } else {
                phdBuilder.peaks(positions);
            }
            try {
                phdInfo = this.phdHelper.writePhd(phdBuilder.build(), phdDate);
            }
            catch (IOException e) {
                throw new IllegalStateException("error writing phd record for " + readId, e);
            }
            this.builderMap.get(referenceId).addRead(readId, gappedSequence, (int)gappedStartOffset, direction, readInfo.getValidRange(), phdInfo, readInfo.getUngappedFullLength());
        }

        private Map<String, String> computeRequiredCommentsFor(File file, Date phdDate) {
            if (file == null) {
                return PhdUtil.createPhdTimeStampCommentFor(phdDate);
            }
            try {
                if (this.isChromatogramFile(file)) {
                    return PhdUtil.createPhdTimeStampAndChromatFileCommentsFor(phdDate, file.getName());
                }
                return PhdUtil.createPhdTimeStampCommentFor(phdDate);
            }
            catch (Exception e) {
                return PhdUtil.createPhdTimeStampCommentFor(phdDate);
            }
        }

        private boolean isChromatogramFile(File f) {
            return !f.getName().endsWith(".fastq") && !f.getName().endsWith(".sff");
        }

        private QualitySequence createDefaultQualitySequenceFor(NucleotideSequence rawSequence) {
            int numberOfQualities = (int)rawSequence.getUngappedLength();
            byte[] qualities = new byte[numberOfQualities];
            Arrays.fill(qualities, this.defaultQualityValue);
            return new QualitySequenceBuilder(qualities).build();
        }

        @Override
        public void assemblyCommand(String name, String version, String parameters) {
        }

        @Override
        public void referenceFile(URI uri) {
        }

        @Override
        public void readFile(URI uri) {
        }
    }
}

