/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.transform;

import java.io.Closeable;
import java.io.File;
import java.net.URI;
import org.jcvi.jillion.assembly.clc.cas.transform.ReadData;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.fasta.qual.QualityFastaDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaFileDataStoreBuilder;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;

class FastaReadDataAdaptedIterator
implements StreamingIterator<ReadData> {
    private final StreamingIterator<NucleotideFastaRecord> fastaIterator;
    private final QualityFastaDataStore qualDataStore;
    private final URI fastaFileUri;

    public FastaReadDataAdaptedIterator(StreamingIterator<NucleotideFastaRecord> fastaIterator, File fastaFile) {
        this.fastaIterator = fastaIterator;
        this.fastaFileUri = fastaFile.toURI();
        File qualFile = new File(fastaFile.getParentFile(), FileUtil.getBaseName(fastaFile) + ".qual");
        if (qualFile.exists()) {
            try {
                this.qualDataStore = new QualityFastaFileDataStoreBuilder(qualFile).build();
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing corresponding qual file : " + qualFile.getAbsolutePath(), e);
            }
        } else {
            this.qualDataStore = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.fastaIterator.hasNext();
    }

    @Override
    public ReadData next() {
        NucleotideFastaRecord nextFasta = this.fastaIterator.next();
        String id = nextFasta.getId();
        ReadData.Builder builder = new ReadData.Builder(nextFasta.getId(), (NucleotideSequence)nextFasta.getSequence()).setUri(this.fastaFileUri);
        if (this.qualDataStore != null) {
            try {
                QualityFastaRecord qualRecord = (QualityFastaRecord)this.qualDataStore.get(id);
                if (qualRecord != null) {
                    builder.setQualities((QualitySequence)qualRecord.getSequence());
                }
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("error getting qualities from fasta", e);
            }
        }
        this.updateField(builder);
        return builder.build();
    }

    protected void updateField(ReadData.Builder builder) {
    }

    @Override
    public void remove() {
        this.fastaIterator.remove();
    }

    @Override
    public void close() {
        this.fastaIterator.close();
        IOUtil.closeAndIgnoreErrors((Closeable)this.qualDataStore);
    }
}

