/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.transform;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.clc.cas.transform.FastaReadDataAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.transform.ReadData;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFactory;

class ChromatDirFastaReadDataAdaptedIterator
extends FastaReadDataAdaptedIterator {
    private static List<String> EXTENSION_LIST = Arrays.asList("", ".scf", ".ztr", ".ab1");
    private final File chromatDir;

    public ChromatDirFastaReadDataAdaptedIterator(StreamingIterator<NucleotideFastaRecord> fastaIterator, File fastaFile, File chromatDir) {
        super(fastaIterator, fastaFile);
        this.chromatDir = chromatDir;
    }

    @Override
    protected void updateField(ReadData.Builder builder) {
        this.tryToParseFromChromatDir(builder);
    }

    protected void tryToParseFromChromatDir(ReadData.Builder builder) {
        String id = builder.getId();
        for (String extension : EXTENSION_LIST) {
            File chromatFile = new File(this.chromatDir, id + extension);
            if (!chromatFile.exists()) continue;
            try {
                Chromatogram chromo = ChromatogramFactory.create(id, chromatFile);
                if (chromo == null) continue;
                builder.setNucleotideSequence(chromo.getNucleotideSequence()).setPositions(chromo.getPeakSequence()).setQualities(chromo.getQualitySequence()).setUri(chromatFile.toURI());
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing chromatogram for " + id, e);
            }
        }
    }

    protected Phd createPhd(Map<String, String> requiredComments, NucleotideFastaRecord fasta, Chromatogram chromo) {
        String id = fasta.getId();
        return new PhdBuilder(id, chromo.getNucleotideSequence(), chromo.getQualitySequence()).peaks(chromo.getPeakSequence()).comments(requiredComments).build();
    }
}

