/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.transform;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import org.jcvi.jillion.assembly.AssemblyTransformationService;
import org.jcvi.jillion.assembly.AssemblyTransformer;
import org.jcvi.jillion.assembly.clc.cas.AbstractAlignedReadCasVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasFileInfo;
import org.jcvi.jillion.assembly.clc.cas.CasFileParser;
import org.jcvi.jillion.assembly.clc.cas.CasFileVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasGappedReferenceDataStore;
import org.jcvi.jillion.assembly.clc.cas.CasGappedReferenceDataStoreBuilderVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasParser;
import org.jcvi.jillion.assembly.clc.cas.CasUtil;
import org.jcvi.jillion.assembly.clc.cas.read.CasPlacedRead;
import org.jcvi.jillion.assembly.clc.cas.transform.ChromatDirFastaReadDataAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.transform.FastaReadDataAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.transform.FastqReadDatadAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.transform.FlowgramReadDataAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.transform.ReadData;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStoreBuilder;
import org.jcvi.jillion.trace.Trace;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStoreBuilder;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.sff.SffFileDataStoreBuilder;

public class CasFileTransformationService
implements AssemblyTransformationService {
    private final File chromatDir;
    private FastqQualityCodec qualityCodec;
    private final CasParser casParser;
    private FastqDataStoreSupplier fastqDataStoreSupplier;

    public CasFileTransformationService(File casFile) throws IOException {
        this(casFile, null);
    }

    public CasFileTransformationService(File casFile, File chromatDir) throws IOException {
        if (casFile == null) {
            throw new NullPointerException("cas file can not be null");
        }
        if (!casFile.exists()) {
            throw new FileNotFoundException(casFile.getAbsolutePath());
        }
        if (chromatDir != null) {
            if (!chromatDir.exists()) {
                throw new FileNotFoundException(chromatDir.getAbsolutePath());
            }
            if (!chromatDir.isDirectory()) {
                throw new IOException("chromat dir must be a directory" + chromatDir.getAbsolutePath());
            }
        }
        this.chromatDir = chromatDir;
        this.casParser = CasFileParser.create(casFile, true);
    }

    public CasFileTransformationService(CasParser parser) throws IOException {
        this(parser, null);
    }

    public void setFastqDataStoreSupplier(FastqDataStoreSupplier fastqDataStoreSupplier) {
        this.fastqDataStoreSupplier = fastqDataStoreSupplier;
    }

    public CasFileTransformationService(CasParser parser, File chromatDir) throws IOException {
        Objects.requireNonNull(parser);
        this.casParser = parser;
        this.chromatDir = chromatDir;
    }

    public FastqQualityCodec getQualityCodec() {
        return this.qualityCodec;
    }

    public void setQualityCodec(FastqQualityCodec qualityCodec) {
        this.qualityCodec = qualityCodec;
    }

    protected File getCasDir() {
        return this.casParser.getWorkingDir();
    }

    protected File getChromatDir() {
        return this.chromatDir;
    }

    @Override
    public final void transform(AssemblyTransformer transformer) throws IOException {
        if (transformer == null) {
            throw new NullPointerException("transformer can not be null");
        }
        CasGappedReferenceDataStoreBuilderVisitor gappedRefVisitor = new CasGappedReferenceDataStoreBuilderVisitor(this.casParser.getWorkingDir());
        this.casParser.parse(gappedRefVisitor);
        CasGappedReferenceDataStore gappedReferenceDataStore = gappedRefVisitor.build();
        StreamingIterator idIter = null;
        try {
            idIter = gappedReferenceDataStore.entryIterator();
            while (idIter.hasNext()) {
                DataStoreEntry entry = idIter.next();
                transformer.referenceOrConsensus(entry.getKey(), (NucleotideSequence)entry.getValue());
            }
        }
        catch (DataStoreException e) {
            throw new IOException("error getting gapped DataStore elements", e);
        }
        finally {
            IOUtil.closeAndIgnoreErrors(idIter);
        }
        Visitor visitor = new Visitor(this.casParser.getWorkingDir(), gappedReferenceDataStore, transformer, this.chromatDir, this.getFastqDataStoreSupplier());
        this.casParser.parse(this.wrapVisitor(visitor));
        transformer.endAssembly();
    }

    private FastqDataStoreSupplier getFastqDataStoreSupplier() {
        if (this.fastqDataStoreSupplier != null) {
            return this.fastqDataStoreSupplier;
        }
        FastqQualityCodec codec = this.qualityCodec;
        return file -> {
            FastqFileDataStoreBuilder builder = new FastqFileDataStoreBuilder(file);
            if (codec != null) {
                builder.qualityCodec(codec);
            }
            return builder.hint(DataStoreProviderHint.ITERATION_ONLY).build();
        };
    }

    protected CasFileVisitor wrapVisitor(CasFileVisitor transformationVisitor) {
        return transformationVisitor;
    }

    private static class Visitor
    extends AbstractAlignedReadCasVisitor {
        private final AssemblyTransformer transformer;
        private final File chromatDir;
        private FastqDataStoreSupplier fastqDataStoreSupplier;

        public Visitor(File workingDir, CasGappedReferenceDataStore gappedReferenceDataStore, AssemblyTransformer transformer, File chromatDir, FastqDataStoreSupplier fastqDataStoreSupplier) {
            super(workingDir, gappedReferenceDataStore);
            this.transformer = transformer;
            this.chromatDir = chromatDir;
            this.fastqDataStoreSupplier = fastqDataStoreSupplier;
        }

        @Override
        public void visitAssemblyProgramInfo(String name, String version, String parameters) {
            this.transformer.assemblyCommand(name, version, parameters);
            super.visitAssemblyProgramInfo(name, version, parameters);
        }

        @Override
        public void visitReferenceFileInfo(CasFileInfo referenceFileInfo) {
            for (String filename : referenceFileInfo.getFileNames()) {
                try {
                    File f = CasUtil.getFileFor(this.getWorkingDir(), filename);
                    this.transformer.referenceFile(f.toURI());
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("reference file not found :" + filename, e);
                }
            }
            super.visitReferenceFileInfo(referenceFileInfo);
        }

        @Override
        public void visitReadFileInfo(CasFileInfo readFileInfo) {
            for (String filename : readFileInfo.getFileNames()) {
                try {
                    File f = CasUtil.getFileFor(this.getWorkingDir(), filename);
                    this.transformer.readFile(f.toURI());
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("read file not found :" + filename, e);
                }
            }
            super.visitReadFileInfo(readFileInfo);
        }

        @Override
        protected void notAligned(Trace currentTrace) {
            ReadData readData = (ReadData)currentTrace;
            this.transformer.notAligned(readData.getId(), readData.getNucleotideSequence(), readData.getQualitySequence(), readData.getPositions(), readData.getUri());
        }

        @Override
        protected void aligned(Trace traceOfRead, String referenceId, CasPlacedRead read) {
            ReadData readData = (ReadData)traceOfRead;
            this.transformer.aligned(readData.getId(), readData.getNucleotideSequence(), readData.getQualitySequence(), readData.getPositions(), readData.getUri(), referenceId, read.getGappedStartOffset(), read.getDirection(), read.getNucleotideSequence(), read.getReadInfo());
        }

        @Override
        protected FastqFileDataStore createFastqDataStore(File fastqFile) throws IOException {
            return this.fastqDataStoreSupplier.apply(fastqFile);
        }

        @Override
        protected StreamingIterator<? extends Trace> createIteratorFor(FastqFileDataStore datastore) throws DataStoreException {
            return new FastqReadDatadAdaptedIterator(datastore.iterator(), datastore.getFile().get());
        }

        @Override
        protected StreamingIterator<? extends Trace> createSffIterator(File sffFile) throws DataStoreException, IOException {
            return new FlowgramReadDataAdaptedIterator(new SffFileDataStoreBuilder(sffFile).hint(DataStoreProviderHint.ITERATION_ONLY).build().iterator(), sffFile);
        }

        @Override
        protected StreamingIterator<? extends Trace> createFastaIterator(File fastaFile) throws DataStoreException {
            try {
                NucleotideFastaFileDataStore datastore = new NucleotideFastaFileDataStoreBuilder(fastaFile).hint(DataStoreProviderHint.ITERATION_ONLY).build();
                if (this.chromatDir == null) {
                    return new FastaReadDataAdaptedIterator(datastore.iterator(), fastaFile);
                }
                return new ChromatDirFastaReadDataAdaptedIterator(datastore.iterator(), fastaFile, this.chromatDir);
            }
            catch (IOException e) {
                throw new DataStoreException("error parsing fasta file", e);
            }
        }
    }

    @FunctionalInterface
    public static interface FastqDataStoreSupplier {
        public FastqFileDataStore apply(File var1) throws IOException;
    }
}

