/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.read;

import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.assembly.clc.cas.read.CasPlacedRead;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;

public final class DefaultCasPlacedRead
implements CasPlacedRead {
    private final long startOffset;
    private final Direction dir;
    private final ReadInfo readInfo;
    private final ReferenceMappedNucleotideSequence sequence;
    private final String id;

    public DefaultCasPlacedRead(String id, ReferenceMappedNucleotideSequence sequence, long startOffset, Range validRange, Direction dir, int ungappedFullLength) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        if (validRange == null) {
            throw new NullPointerException("validRange can not be null");
        }
        if (dir == null) {
            throw new NullPointerException("direction can not be null");
        }
        this.id = id;
        this.sequence = sequence;
        this.startOffset = startOffset;
        this.dir = dir;
        this.readInfo = new ReadInfo(validRange, ungappedFullLength);
    }

    @Override
    public ReadInfo getReadInfo() {
        return this.readInfo;
    }

    @Override
    public long getGappedEndOffset() {
        return this.startOffset + this.getGappedLength() - 1L;
    }

    @Override
    public long getGappedLength() {
        return this.sequence.getLength();
    }

    @Override
    public long getGappedStartOffset() {
        return this.startOffset;
    }

    @Override
    public ReferenceMappedNucleotideSequence getNucleotideSequence() {
        return this.sequence;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long toGappedValidRangeOffset(long referenceIndex) {
        long validRangeIndex = referenceIndex - this.getGappedStartOffset();
        this.checkValidRange(validRangeIndex);
        return validRangeIndex;
    }

    @Override
    public long toReferenceOffset(long validRangeIndex) {
        this.checkValidRange(validRangeIndex);
        return this.getGappedStartOffset() + validRangeIndex;
    }

    private void checkValidRange(long validRangeIndex) {
        if (validRangeIndex < 0L) {
            throw new IllegalArgumentException("reference index refers to index before valid range");
        }
        if (validRangeIndex > this.getGappedLength() - 1L) {
            throw new IllegalArgumentException("reference index refers to index after valid range");
        }
    }

    @Override
    public Direction getDirection() {
        return this.dir;
    }

    @Override
    public Range asRange() {
        return this.getGappedContigRange();
    }

    @Override
    public Range getGappedContigRange() {
        return Range.of(this.getGappedStartOffset(), this.getGappedEndOffset());
    }

    public String toString() {
        return "DefaultCasPlacedRead [id=" + this.id + ", startOffset=" + this.startOffset + ", dir=" + (Object)((Object)this.dir) + ", readInfo=" + this.readInfo + ", sequence=" + this.sequence + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dir.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.readInfo.hashCode();
        result = 31 * result + this.sequence.hashCode();
        result = 31 * result + (int)(this.startOffset ^ this.startOffset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCasPlacedRead)) {
            return false;
        }
        DefaultCasPlacedRead other = (DefaultCasPlacedRead)obj;
        if (this.dir != other.dir) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.readInfo.equals(other.readInfo)) {
            return false;
        }
        if (!this.sequence.equals(other.sequence)) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }
}

