/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.consed;

import java.io.File;
import java.util.Date;
import org.jcvi.jillion.assembly.clc.cas.consed.FastaConsedPhdAdaptedIterator;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.fasta.qual.QualityFastaDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaFileDataStoreBuilder;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;

class QualFastaConsedPhdAdaptedIterator
extends FastaConsedPhdAdaptedIterator {
    private final QualityFastaDataStore qualIter;

    public QualFastaConsedPhdAdaptedIterator(StreamingIterator<NucleotideFastaRecord> fastaIterator, File fastaFile, Date phdDate, PhredQuality defaultQualityValue) {
        super(fastaIterator, fastaFile, phdDate, defaultQualityValue);
        File qualFile = new File(fastaFile.getParentFile(), FileUtil.getBaseName(fastaFile) + ".qual");
        if (qualFile.exists()) {
            try {
                this.qualIter = new QualityFastaFileDataStoreBuilder(qualFile).build();
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing corresponding qual file : " + qualFile.getAbsolutePath(), e);
            }
        } else {
            this.qualIter = null;
        }
    }

    @Override
    protected QualitySequence getQualitiesFor(NucleotideFastaRecord nextFasta) {
        FastaRecord qualRecord = null;
        if (this.qualIter != null) {
            try {
                qualRecord = (QualityFastaRecord)this.qualIter.get(nextFasta.getId());
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("error getting quality fasta record " + nextFasta.getId(), e);
            }
        }
        if (qualRecord == null) {
            return super.getQualitiesFor(nextFasta);
        }
        return (QualitySequence)qualRecord.getSequence();
    }
}

