/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.consed;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.jcvi.jillion.assembly.clc.cas.consed.PhdReadRecord;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.trace.sff.SffFlowgram;

class FlowgramConsedPhdAdaptedIterator
implements StreamingIterator<PhdReadRecord> {
    private final StreamingIterator<? extends SffFlowgram> flowgramIterator;
    private final Map<String, String> requiredComments;
    private final Date phdDate;
    private final File sffFile;

    public FlowgramConsedPhdAdaptedIterator(StreamingIterator<? extends SffFlowgram> flowgramIterator, File sffFile, Date phdDate) {
        this.requiredComments = PhdUtil.createPhdTimeStampCommentFor(phdDate);
        this.flowgramIterator = flowgramIterator;
        this.phdDate = new Date(phdDate.getTime());
        this.sffFile = sffFile;
    }

    @Override
    public boolean hasNext() {
        return this.flowgramIterator.hasNext();
    }

    @Override
    public PhdReadRecord next() {
        SffFlowgram nextFlowgram = this.flowgramIterator.next();
        String id = nextFlowgram.getId();
        Phd phd = new PhdBuilder(id, nextFlowgram.getNucleotideSequence(), nextFlowgram.getQualitySequence()).comments(this.requiredComments).fakePeaks().build();
        PhdInfo phdInfo = ConsedUtil.generateDefaultPhdInfoFor(this.sffFile, id, this.phdDate);
        return new PhdReadRecord(phd, phdInfo);
    }

    @Override
    public void remove() {
        this.flowgramIterator.remove();
    }

    @Override
    public void close() {
        this.flowgramIterator.close();
    }
}

