/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.consed;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.jcvi.jillion.assembly.clc.cas.consed.PhdReadRecord;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.trace.fastq.FastqRecord;

class FastqConsedPhdAdaptedIterator
implements StreamingIterator<PhdReadRecord> {
    private final StreamingIterator<? extends FastqRecord> fastqIterator;
    private final Map<String, String> requiredComments;
    private final Date phdDate;
    private final File fastqFile;

    public FastqConsedPhdAdaptedIterator(StreamingIterator<? extends FastqRecord> fastqIterator, File fastqFile, Date phdDate) {
        this.requiredComments = PhdUtil.createPhdTimeStampCommentFor(phdDate);
        this.fastqIterator = fastqIterator;
        this.phdDate = new Date(phdDate.getTime());
        this.fastqFile = fastqFile;
    }

    @Override
    public boolean hasNext() {
        return this.fastqIterator.hasNext();
    }

    @Override
    public PhdReadRecord next() {
        FastqRecord nextFastq = this.fastqIterator.next();
        String id = nextFastq.getId();
        Phd phd = new PhdBuilder(id, nextFastq.getNucleotideSequence(), nextFastq.getQualitySequence()).comments(this.requiredComments).fakePeaks().build();
        PhdInfo info = ConsedUtil.generateDefaultPhdInfoFor(this.fastqFile, id, this.phdDate);
        return new PhdReadRecord(phd, info);
    }

    @Override
    public void remove() {
        this.fastqIterator.remove();
    }

    @Override
    public void close() {
        this.fastqIterator.close();
    }
}

