/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.consed;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jcvi.jillion.assembly.clc.cas.consed.PhdReadRecord;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;

class FastaConsedPhdAdaptedIterator
implements StreamingIterator<PhdReadRecord> {
    private final StreamingIterator<NucleotideFastaRecord> fastaIterator;
    private final Map<String, String> requiredComments;
    private final byte defaultQualityValue;
    private final Date phdDate;
    private final File fastaFile;

    public FastaConsedPhdAdaptedIterator(StreamingIterator<NucleotideFastaRecord> fastaIterator, File fastaFile, Date phdDate, PhredQuality defaultQualityValue) {
        this.requiredComments = PhdUtil.createPhdTimeStampCommentFor(phdDate);
        this.fastaIterator = fastaIterator;
        this.defaultQualityValue = defaultQualityValue.getQualityScore();
        this.fastaFile = fastaFile;
        this.phdDate = new Date(phdDate.getTime());
    }

    @Override
    public boolean hasNext() {
        return this.fastaIterator.hasNext();
    }

    @Override
    public PhdReadRecord next() {
        NucleotideFastaRecord nextFasta = this.fastaIterator.next();
        String id = nextFasta.getId();
        Properties comments = new Properties();
        comments.putAll(this.requiredComments);
        this.requiredComments.putAll(this.createAdditionalCommentsFor(id));
        Phd phd = this.createPhdRecordFor(nextFasta, this.requiredComments);
        PhdInfo info = ConsedUtil.generateDefaultPhdInfoFor(this.fastaFile, id, this.phdDate);
        return new PhdReadRecord(phd, info);
    }

    protected Map<String, String> createAdditionalCommentsFor(String id) {
        return Collections.emptyMap();
    }

    protected Phd createPhdRecordFor(NucleotideFastaRecord nextFasta, Map<String, String> requiredComments) {
        String id = nextFasta.getId();
        QualitySequence qualities = this.getQualitiesFor(nextFasta);
        return new PhdBuilder(id, (NucleotideSequence)nextFasta.getSequence(), qualities).comments(requiredComments).fakePeaks().build();
    }

    protected QualitySequence getQualitiesFor(NucleotideFastaRecord nextFasta) {
        int numberOfQualities = (int)((NucleotideSequence)nextFasta.getSequence()).getLength();
        byte[] qualities = new byte[numberOfQualities];
        Arrays.fill(qualities, this.defaultQualityValue);
        return new QualitySequenceBuilder(qualities).build();
    }

    @Override
    public void remove() {
        this.fastaIterator.remove();
    }

    @Override
    public void close() {
        this.fastaIterator.close();
    }
}

