/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.consed;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.clc.cas.consed.QualFastaConsedPhdAdaptedIterator;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramBuilder;

class ChromatDirFastaConsedPhdAdaptedIterator
extends QualFastaConsedPhdAdaptedIterator {
    private final File chromatDir;

    public ChromatDirFastaConsedPhdAdaptedIterator(StreamingIterator<NucleotideFastaRecord> fastaIterator, File fastaFile, Date phdDate, PhredQuality defaultQualityValue, File chromatDir) {
        super(fastaIterator, fastaFile, phdDate, defaultQualityValue);
        this.chromatDir = chromatDir;
    }

    @Override
    protected Map<String, String> createAdditionalCommentsFor(String id) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("CHROMAT_FILE", id);
        return props;
    }

    @Override
    protected Phd createPhdRecordFor(NucleotideFastaRecord fasta, Map<String, String> requiredComments) {
        Chromatogram chromo = this.tryToParseFromChromatDir(fasta.getId());
        if (chromo != null) {
            return this.createPhd(requiredComments, fasta, chromo);
        }
        return super.createPhdRecordFor(fasta, requiredComments);
    }

    protected Chromatogram tryToParseFromChromatDir(String id) {
        File chromatFile = new File(this.chromatDir, id);
        if (chromatFile.exists()) {
            try {
                return new ScfChromatogramBuilder(id, chromatFile).build();
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing chromatogram for " + id, e);
            }
        }
        return null;
    }

    protected Phd createPhd(Map<String, String> requiredComments, NucleotideFastaRecord fasta, Chromatogram chromo) {
        String id = fasta.getId();
        return new PhdBuilder(id, chromo.getNucleotideSequence(), chromo.getQualitySequence()).peaks(chromo.getPeakSequence()).comments(requiredComments).build();
    }
}

