/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas.consed;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.clc.cas.AbstractAlignedReadCasVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasGappedReferenceDataStore;
import org.jcvi.jillion.assembly.clc.cas.consed.ChromatDirFastaConsedPhdAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.consed.FastqConsedPhdAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.consed.FlowgramConsedPhdAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.consed.PhdReadRecord;
import org.jcvi.jillion.assembly.clc.cas.consed.QualFastaConsedPhdAdaptedIterator;
import org.jcvi.jillion.assembly.clc.cas.read.CasPlacedRead;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceFileWriter;
import org.jcvi.jillion.assembly.consed.ace.AceFileWriterBuilder;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallWriter;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdFileDataStoreBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdWriter;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.consensus.NextGenReferenceConsensusRecaller;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.DateUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStoreBuilder;
import org.jcvi.jillion.trace.Trace;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.sff.SffFileDataStoreBuilder;

public class Cas2Consed
extends AbstractAlignedReadCasVisitor {
    private final Map<String, AceContigBuilder> contigBuilders;
    private final File consedOutputDir;
    private final Date phdDate = new Date();
    private final PhdWriter phdOut;
    private File chromatDir = null;
    private final File phdFile;
    private final String prefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cas2Consed(File casFile, CasGappedReferenceDataStore gappedReferenceDataStore, File consedOutputDir, String prefix) throws DataStoreException, IOException {
        super(casFile.getParentFile(), gappedReferenceDataStore);
        if (consedOutputDir == null) {
            throw new NullPointerException("output dir can not be null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix can not be null");
        }
        this.prefix = prefix.trim();
        if (this.prefix.isEmpty()) {
            throw new IllegalArgumentException("prefix must contain non-whitespace");
        }
        this.contigBuilders = new LinkedHashMap<String, AceContigBuilder>();
        this.consedOutputDir = consedOutputDir;
        StreamingIterator<String> referenceIdIterator = null;
        StreamingIterator referenceSequenceIterator = null;
        referenceIdIterator = gappedReferenceDataStore.idIterator();
        referenceSequenceIterator = gappedReferenceDataStore.iterator();
        try {
            while (referenceIdIterator.hasNext()) {
                String id = referenceIdIterator.next();
                NucleotideSequence seq = (NucleotideSequence)referenceSequenceIterator.next();
                this.contigBuilders.put(id, new AceContigBuilder(id, seq));
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(referenceIdIterator, referenceSequenceIterator);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors(referenceIdIterator, referenceSequenceIterator);
        File phdDir = new File(consedOutputDir, "phdball_dir");
        this.phdFile = new File(phdDir, "phd.ball.1");
        IOUtil.mkdirs(phdDir);
        this.phdOut = new PhdBallWriter(this.phdFile);
    }

    public final File getPhdBallFile() {
        return this.phdFile;
    }

    public final void setChromatDir(File chromatDir) {
        this.chromatDir = chromatDir;
    }

    @Override
    protected void notAligned(Trace currentTrace) {
    }

    @Override
    protected final void aligned(Trace traceOfRead, String referenceId, CasPlacedRead read) {
        AceContigBuilder builder = this.contigBuilders.get(referenceId);
        if (!(traceOfRead instanceof PhdReadRecord)) {
            throw new IllegalStateException("not a valid phd record " + traceOfRead);
        }
        PhdReadRecord phdReadRecord = (PhdReadRecord)traceOfRead;
        PhdInfo phdInfo = phdReadRecord.getPhdInfo();
        builder.addRead(read.getId(), read.getNucleotideSequence(), (int)read.getGappedStartOffset(), read.getDirection(), read.getReadInfo().getValidRange(), phdInfo, read.getReadInfo().getUngappedFullLength());
        try {
            this.phdOut.write(phdReadRecord.getPhd());
        }
        catch (IOException e) {
            throw new IllegalStateException("error writing out phd record for  " + traceOfRead, e);
        }
        this.afterVisitMatch(referenceId, read, phdReadRecord.getPhd(), phdInfo);
    }

    protected void afterVisitMatch(String referenceId, CasPlacedRead read, Phd phd, PhdInfo phdInfo) {
    }

    protected void postProcess(AceContigBuilder builder) {
    }

    protected void visitAce(Range scaffoldRange, AceContig contig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitEnd() {
        try {
            this.phdOut.close();
            PhdDataStore phdDataStore = new PhdFileDataStoreBuilder(this.phdFile).build();
            File editDir = new File(this.consedOutputDir, "edit_dir");
            File aceFile = new File(editDir, this.prefix + ".ace.1");
            IOUtil.mkdirs(editDir);
            File tmpDir = IOUtil.createTempDir("cas2consed", null, editDir);
            try {
                AceFileWriter aceWriter = new AceFileWriterBuilder(aceFile, phdDataStore).tmpDir(tmpDir).build();
                Iterator<Map.Entry<String, AceContigBuilder>> referenceEntryIter = this.contigBuilders.entrySet().iterator();
                QualitySequenceDataStore qualityDataStore = phdDataStore.asQualityDataStore();
                while (referenceEntryIter.hasNext()) {
                    Map.Entry<String, AceContigBuilder> refEntry = referenceEntryIter.next();
                    AceContigBuilder contigBuilder = refEntry.getValue();
                    contigBuilder.recallConsensus(new NextGenReferenceConsensusRecaller(), qualityDataStore, GapQualityValueStrategy.LOWEST_FLANKING);
                    this.postProcess(contigBuilder);
                    this.visitBeginReference(refEntry.getKey());
                    for (Map.Entry<Range, AceContig> entry : ConsedUtil.split0xContig(contigBuilder, true).entrySet()) {
                        AceContig splitContig = entry.getValue();
                        this.visitAce(entry.getKey(), splitContig);
                        aceWriter.write(splitContig);
                    }
                    this.visitEndReference();
                    referenceEntryIter.remove();
                }
                aceWriter.write(new WholeAssemblyAceTag("phdBall", "consed", DateUtil.getCurrentDate(), "../phdball_dir/" + this.phdFile.getName()));
                aceWriter.close();
            }
            finally {
                IOUtil.recursiveDelete(tmpDir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void visitBeginReference(String key) {
    }

    protected void visitEndReference() {
    }

    @Override
    protected StreamingIterator<? extends Trace> createIteratorFor(FastqFileDataStore datastore) throws DataStoreException {
        return new FastqConsedPhdAdaptedIterator(datastore.iterator(), datastore.getFile().get(), this.phdDate);
    }

    protected StreamingIterator<PhdReadRecord> createSffIterator(File sffFile) throws DataStoreException, IOException {
        return new FlowgramConsedPhdAdaptedIterator(new SffFileDataStoreBuilder(sffFile).hint(DataStoreProviderHint.ITERATION_ONLY).build().iterator(), sffFile, this.phdDate);
    }

    protected StreamingIterator<PhdReadRecord> createFastaIterator(File file) throws DataStoreException {
        if (this.chromatDir == null) {
            try {
                NucleotideFastaFileDataStore datastore = new NucleotideFastaFileDataStoreBuilder(file).hint(DataStoreProviderHint.ITERATION_ONLY).build();
                return new QualFastaConsedPhdAdaptedIterator(datastore.iterator(), file, this.phdDate, PhredQuality.valueOf(30));
            }
            catch (IOException e) {
                throw new DataStoreException("error reading fasta file " + file.getAbsolutePath(), e);
            }
        }
        try {
            NucleotideFastaFileDataStore datastore = new NucleotideFastaFileDataStoreBuilder(file).build();
            return new ChromatDirFastaConsedPhdAdaptedIterator(datastore.iterator(), file, this.phdDate, PhredQuality.valueOf(30), this.chromatDir);
        }
        catch (IOException e) {
            throw new DataStoreException("error reading fasta file for chromatogram " + file.getAbsolutePath(), e);
        }
    }
}

