/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.internal.trace.chromat.ChromatogramUtil;

public enum ReadFileType {
    SFF,
    FASTQ,
    FASTA,
    SANGER;


    public static ReadFileType getTypeFromFile(File readFile) throws IOException {
        String readFileName = readFile.getName();
        String extension = FileUtil.getExtension(readFileName);
        if ("fastq".equals(extension) || readFileName.matches(".+\\d+_sequence\\.txt") || readFileName.endsWith(".fastq.untrimmed")) {
            return FASTQ;
        }
        if ("sff".equals(extension)) {
            return SFF;
        }
        if (ChromatogramUtil.isChromatogram(readFile)) {
            return SANGER;
        }
        return FASTA;
    }
}

