/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.util.ArrayList;
import java.util.List;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegion;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegionType;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

class ReAlignReads {
    private final NucleotideSequence gappedReference;
    private final GrowableIntArray referenceGaps;
    private final boolean referenceEncode;

    public ReAlignReads(NucleotideSequence gappedReference) {
        this(gappedReference, false);
    }

    public ReAlignReads(NucleotideSequence gappedReference, boolean referenceEncode) {
        this.gappedReference = gappedReference;
        this.referenceGaps = new GrowableIntArray(gappedReference.getGapOffsets());
        this.referenceEncode = referenceEncode;
    }

    public ReAlignResult realignValidBases(NucleotideSequence fullLengthUngappedRead, long ungappedStartOffset, Direction dir, List<CasAlignmentRegion> alignmentRegions) {
        return this.realignValidBases(fullLengthUngappedRead, ungappedStartOffset, dir, alignmentRegions, null);
    }

    public ReAlignResult realignValidBases(NucleotideSequence fullLengthUngappedRead, long ungappedStartOffset, Direction dir, List<CasAlignmentRegion> alignmentRegions, Range validRange) {
        long gappedStartOffset;
        long validRangeStart;
        NucleotideSequenceBuilder validUngappedBases = new NucleotideSequenceBuilder(fullLengthUngappedRead);
        if (validRange != null) {
            validUngappedBases.trim(validRange);
        }
        long fullUngappedLength = fullLengthUngappedRead.getLength();
        if (dir == Direction.REVERSE) {
            validUngappedBases.reverseComplement();
            validRangeStart = validRange == null ? 0L : AssemblyUtil.reverseComplementValidRange(validRange, fullUngappedLength).getBegin();
        } else {
            validRangeStart = validRange == null ? 0L : validRange.getBegin();
        }
        NucleotideSequenceBuilder gappedValidSequenceBuilder = new NucleotideSequenceBuilder((int)(validUngappedBases.getLength() * 2L));
        boolean outsideValidRange = true;
        long referenceOffset = gappedStartOffset = (long)this.gappedReference.getGappedOffsetFor((int)ungappedStartOffset);
        long currentOffset = 0L;
        for (CasAlignmentRegion region : this.getRegionsToConsider(alignmentRegions)) {
            CasAlignmentRegionType type = region.getType();
            if (outsideValidRange) {
                if (type == CasAlignmentRegionType.INSERT) {
                    validRangeStart += region.getLength();
                    currentOffset += region.getLength();
                    continue;
                }
                outsideValidRange = false;
            }
            long allBasesLength = validUngappedBases.getUngappedLength();
            if (currentOffset + region.getLength() > allBasesLength) {
                throw new IllegalStateException(String.format("alignment region %s extends beyond read; (current offset = %d total read length = %d)", region, currentOffset, allBasesLength));
            }
            for (long i = 0L; i < region.getLength(); ++i) {
                if (type != CasAlignmentRegionType.INSERT) {
                    while (this.referenceGaps.binarySearch((int)referenceOffset) >= 0) {
                        gappedValidSequenceBuilder.append(Nucleotide.Gap);
                        ++referenceOffset;
                    }
                }
                if (type == CasAlignmentRegionType.DELETION) {
                    gappedValidSequenceBuilder.append(Nucleotide.Gap);
                    ++referenceOffset;
                    continue;
                }
                gappedValidSequenceBuilder.append(validUngappedBases.get((int)(currentOffset + i)));
                ++referenceOffset;
            }
            if (type == CasAlignmentRegionType.DELETION) continue;
            currentOffset += region.getLength();
        }
        NucleotideSequence gappedValidBases = this.referenceEncode ? gappedValidSequenceBuilder.setReferenceHint(this.gappedReference, (int)gappedStartOffset).buildReferenceEncodedNucleotideSequence() : gappedValidSequenceBuilder.turnOffDataCompression(true).build();
        Range newValidRange = new Range.Builder(gappedValidSequenceBuilder.getUngappedLength()).shift(validRangeStart).build();
        if (dir == Direction.REVERSE) {
            newValidRange = AssemblyUtil.reverseComplementValidRange(newValidRange, fullUngappedLength);
        }
        return new ReAlignResult(gappedValidBases, newValidRange, (int)gappedStartOffset);
    }

    private List<CasAlignmentRegion> getRegionsToConsider(List<CasAlignmentRegion> regions) {
        ArrayList<CasAlignmentRegion> regionsToConsider = new ArrayList<CasAlignmentRegion>(regions);
        int lastIndex = regionsToConsider.size() - 1;
        while (((CasAlignmentRegion)regionsToConsider.get(lastIndex)).getType() == CasAlignmentRegionType.INSERT) {
            regionsToConsider.remove(lastIndex);
            --lastIndex;
        }
        return regionsToConsider;
    }

    public static final class ReAlignResult {
        private final NucleotideSequence gappedValidBases;
        private final Range validRange;
        private final int gappedStartOffset;

        private ReAlignResult(NucleotideSequence gappedValidBases, Range validRange, int gappedStartOffset) {
            this.gappedValidBases = gappedValidBases;
            this.validRange = validRange;
            this.gappedStartOffset = gappedStartOffset;
        }

        public int getGappedStartOffset() {
            return this.gappedStartOffset;
        }

        public NucleotideSequence getGappedValidBases() {
            return this.gappedValidBases;
        }

        public Range getValidRange() {
            return this.validRange;
        }

        public String toString() {
            return "ReAlignResult [gappedStartOffset=" + this.gappedStartOffset + ", gappedValidBases=" + this.gappedValidBases + ", validRange=" + this.validRange + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.gappedStartOffset;
            result = 31 * result + this.gappedValidBases.hashCode();
            result = 31 * result + this.validRange.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReAlignResult other = (ReAlignResult)obj;
            if (this.gappedStartOffset != other.gappedStartOffset) {
                return false;
            }
            if (!this.gappedValidBases.equals(other.gappedValidBases)) {
                return false;
            }
            return this.validRange.equals(other.validRange);
        }
    }
}

