/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import org.jcvi.jillion.assembly.clc.cas.CasAlignment;
import org.jcvi.jillion.assembly.clc.cas.CasMatch;
import org.jcvi.jillion.core.Range;

final class DefaultCasMatch
implements CasMatch {
    private final boolean hasMatch;
    private final boolean isPartOfPair;
    private final CasAlignment alignment;
    private final long numberOfMatches;
    private final long numberOfReportedAlignments;
    private final int score;
    private final Range trimRange;

    public DefaultCasMatch(boolean hasMatch, long numberOfMatches, long numberOfReportedAlignments, boolean isPartOfPair, CasAlignment chosenAlignment, int score) {
        this(hasMatch, numberOfMatches, numberOfMatches, isPartOfPair, chosenAlignment, score, null);
    }

    public DefaultCasMatch(boolean hasMatch, long numberOfMatches, long numberOfReportedAlignments, boolean isPartOfPair, CasAlignment chosenAlignment, int score, Range trimRange) {
        this.hasMatch = hasMatch;
        this.numberOfMatches = numberOfMatches;
        this.numberOfReportedAlignments = numberOfReportedAlignments;
        this.isPartOfPair = isPartOfPair;
        this.alignment = chosenAlignment;
        this.score = score;
        this.trimRange = trimRange;
    }

    @Override
    public Range getTrimRange() {
        return this.trimRange;
    }

    @Override
    public boolean hasMultipleAlignments() {
        return this.numberOfReportedAlignments > 1L;
    }

    @Override
    public boolean matchReported() {
        return this.hasMatch;
    }

    @Override
    public boolean readHasMutlipleMatches() {
        return this.numberOfMatches > 1L;
    }

    @Override
    public boolean readIsPartOfAPair() {
        return this.isPartOfPair;
    }

    @Override
    public CasAlignment getChosenAlignment() {
        return this.alignment;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("DefaultCasMatch [hasMatch=" + this.hasMatch + ", numberOfAlignments=" + this.numberOfReportedAlignments + ", numberOfMatches=" + this.numberOfMatches + ", isPartOfPair=" + this.isPartOfPair + ", alignments=");
        if (this.alignment != null) {
            result.append(String.format("%n%n\t%s", this.alignment));
        }
        result.append(String.format("%n]", new Object[0]));
        return result.toString();
    }

    @Override
    public long getNumberOfReportedAlignments() {
        return this.numberOfReportedAlignments;
    }

    @Override
    public long getNumberOfMatches() {
        return this.numberOfMatches;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alignment == null ? 0 : this.alignment.hashCode());
        result = 31 * result + (this.hasMatch ? 1231 : 1237);
        result = 31 * result + (this.isPartOfPair ? 1231 : 1237);
        result = 31 * result + (int)(this.numberOfMatches ^ this.numberOfMatches >>> 32);
        result = 31 * result + this.score;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCasMatch)) {
            return false;
        }
        DefaultCasMatch other = (DefaultCasMatch)obj;
        if (this.alignment == null ? other.alignment != null : !this.alignment.equals(other.alignment)) {
            return false;
        }
        if (this.hasMatch != other.hasMatch) {
            return false;
        }
        if (this.isPartOfPair != other.isPartOfPair) {
            return false;
        }
        if (this.numberOfMatches != other.numberOfMatches) {
            return false;
        }
        return this.score == other.score;
    }
}

