/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.assembly.clc.cas.AbstractCasFileVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasFileInfo;
import org.jcvi.jillion.assembly.clc.cas.CasFileInfoValidator;
import org.jcvi.jillion.core.datastore.DataStoreException;

class CasValidator
extends AbstractCasFileVisitor {
    private final File workingDir;

    public CasValidator(File workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public void visitReadFileInfo(CasFileInfo readFileInfo) {
        try {
            CasFileInfoValidator.validateFileInfo(this.workingDir, readFileInfo);
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error parsing read file(s)", e);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            throw new IllegalStateException("input read file(s) " + readFileInfo.getFileNames() + " do not exist or contain multiple encodings", e);
        }
    }

    @Override
    public void visitReferenceFileInfo(CasFileInfo referenceFileInfo) {
        try {
            CasFileInfoValidator.validateFileInfo(this.workingDir, referenceFileInfo);
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error parsing reference file(s)", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("input reference file(s) do not exist", e);
        }
    }
}

