/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.jcvi.jillion.core.io.IOUtil;

public final class CasUtil {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private CasUtil() {
    }

    static int numberOfBytesRequiredFor(long i) {
        if (i < 1L) {
            throw new IllegalArgumentException("input number must be > 0 : " + i);
        }
        return (int)Math.ceil(Math.log(i) / Math.log(256.0));
    }

    static long parseByteCountFrom(InputStream in) throws IOException {
        int firstByte = in.read();
        if (firstByte < 254) {
            return firstByte;
        }
        if (firstByte == 254) {
            return CasUtil.readCasUnsignedShort(in);
        }
        return CasUtil.readCasUnsignedInt(in);
    }

    static String parseCasStringFrom(InputStream in) throws IOException {
        int length = (int)CasUtil.parseByteCountFrom(in);
        byte[] bytes = IOUtil.toByteArray(in, length);
        return new String(bytes, UTF_8);
    }

    static short readCasUnsignedByte(InputStream in) throws IOException {
        return IOUtil.readUnsignedByte(in, ByteOrder.LITTLE_ENDIAN);
    }

    static int readCasUnsignedShort(InputStream in) throws IOException {
        return IOUtil.readUnsignedShort(in, ByteOrder.LITTLE_ENDIAN);
    }

    static long readCasUnsignedInt(InputStream in) throws IOException {
        return CasUtil.readCasUnsignedInt(in, 4);
    }

    static long readCasUnsignedInt(InputStream in, int numberOfBytesInNumber) throws IOException {
        byte[] array = IOUtil.readByteArray(in, numberOfBytesInNumber);
        array = IOUtil.switchEndian(array);
        return new BigInteger(1, array).longValue();
    }

    static BigInteger readCasUnsignedLong(InputStream in) throws IOException {
        return IOUtil.readUnsignedLong(in, ByteOrder.LITTLE_ENDIAN);
    }

    public static File getFileFor(File workingDir, String filePath) throws FileNotFoundException {
        if (filePath == null) {
            throw new NullPointerException("filePath can not be null");
        }
        boolean isAbsolutePath = filePath.charAt(0) == File.separatorChar;
        File dataStoreFile = isAbsolutePath ? new File(filePath) : new File(workingDir, filePath);
        if (!dataStoreFile.exists()) {
            throw new FileNotFoundException(dataStoreFile.getAbsolutePath());
        }
        return dataStoreFile;
    }
}

