/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.assembly.GappedReferenceBuilder;
import org.jcvi.jillion.assembly.clc.cas.CasAlignment;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegion;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegionType;
import org.jcvi.jillion.assembly.clc.cas.CasContigPair;
import org.jcvi.jillion.assembly.clc.cas.CasFileInfo;
import org.jcvi.jillion.assembly.clc.cas.CasFileVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasGappedReferenceDataStore;
import org.jcvi.jillion.assembly.clc.cas.CasMatch;
import org.jcvi.jillion.assembly.clc.cas.CasMatchVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasReferenceDescription;
import org.jcvi.jillion.assembly.clc.cas.CasScoringScheme;
import org.jcvi.jillion.assembly.clc.cas.CasUtil;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStoreBuilder;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;

public final class CasGappedReferenceDataStoreBuilderVisitor
implements CasFileVisitor {
    private String[] refIndexToIdMap;
    private GappedReferenceBuilder[] gappedReferenceBuilders;
    private volatile boolean halted = false;
    private volatile CasGappedReferenceDataStore builtDataStore = null;
    private final File casDir;
    private final Predicate<String> refIdFilter;
    private int refCounter = 0;

    public CasGappedReferenceDataStoreBuilderVisitor(File casDir) {
        this(casDir, DataStoreFilters.alwaysAccept());
    }

    public CasGappedReferenceDataStoreBuilderVisitor(File casDir, Predicate<String> refIdFilter) {
        Objects.requireNonNull(refIdFilter);
        this.casDir = casDir;
        this.refIdFilter = refIdFilter;
    }

    @Override
    public void visitAssemblyProgramInfo(String name, String version, String parameters) {
        this.checkNotYetBuilt();
    }

    @Override
    public void visitMetaData(long numberOfReferenceSequences, long numberOfReads) {
        this.checkNotYetBuilt();
        this.gappedReferenceBuilders = new GappedReferenceBuilder[(int)numberOfReferenceSequences];
        this.refIndexToIdMap = new String[(int)numberOfReferenceSequences];
    }

    @Override
    public void visitNumberOfReadFiles(long numberOfReadFiles) {
        this.checkNotYetBuilt();
    }

    @Override
    public void visitNumberOfReferenceFiles(long numberOfReferenceFiles) {
        this.checkNotYetBuilt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitReferenceFileInfo(CasFileInfo referenceFileInfo) {
        this.checkNotYetBuilt();
        for (String filePath : referenceFileInfo.getFileNames()) {
            try {
                File refFile = CasUtil.getFileFor(this.casDir, filePath);
                NucleotideFastaFileDataStore datastore = new NucleotideFastaFileDataStoreBuilder(refFile).build();
                StreamingIterator iter = null;
                try {
                    iter = datastore.iterator();
                    while (iter.hasNext()) {
                        String id;
                        NucleotideFastaRecord next = (NucleotideFastaRecord)iter.next();
                        this.refIndexToIdMap[this.refCounter] = id = next.getId();
                        if (this.refIdFilter.test(id)) {
                            this.gappedReferenceBuilders[this.refCounter] = new GappedReferenceBuilder((NucleotideSequence)next.getSequence());
                        }
                        ++this.refCounter;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeAndIgnoreErrors(iter, datastore);
                    throw throwable;
                }
                IOUtil.closeAndIgnoreErrors(iter, datastore);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not load read file: " + filePath, e);
            }
        }
    }

    @Override
    public void visitReadFileInfo(CasFileInfo readFileInfo) {
        this.checkNotYetBuilt();
    }

    @Override
    public void visitScoringScheme(CasScoringScheme scheme) {
        this.checkNotYetBuilt();
    }

    @Override
    public void visitReferenceDescription(CasReferenceDescription description) {
        this.checkNotYetBuilt();
    }

    @Override
    public void visitContigPair(CasContigPair contigPair) {
        this.checkNotYetBuilt();
    }

    @Override
    public void visitEnd() {
        this.checkNotYetBuilt();
        int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(this.gappedReferenceBuilders.length);
        LinkedHashMap<String, NucleotideSequence> gappedSequenceMap = new LinkedHashMap<String, NucleotideSequence>(capacity);
        for (int j = 0; j < this.gappedReferenceBuilders.length; ++j) {
            String refId = this.refIndexToIdMap[j];
            if (!this.refIdFilter.test(refId)) continue;
            gappedSequenceMap.put(refId, this.gappedReferenceBuilders[j].build());
        }
        this.builtDataStore = new CasGappedReferenceDataStoreImpl(DataStore.of(gappedSequenceMap), this.refIndexToIdMap);
    }

    private void checkNotYetBuilt() {
        if (this.builtDataStore != null) {
            throw new IllegalStateException("should only parse cas once");
        }
    }

    @Override
    public void halted() {
        this.halted = true;
    }

    @Override
    public CasMatchVisitor visitMatches(CasFileVisitor.CasVisitorCallback callback) {
        return new MaxRefGapVisitor();
    }

    public CasGappedReferenceDataStore build() {
        if (this.halted) {
            throw new IllegalStateException("visiting was halted; can not build datastore");
        }
        if (this.builtDataStore == null) {
            throw new IllegalStateException("have not yet completly visited the cas to build the datastore");
        }
        return this.builtDataStore;
    }

    private static final class CasGappedReferenceDataStoreImpl
    implements CasGappedReferenceDataStore {
        private final DataStore<NucleotideSequence> delegate;
        private final String[] refIndexToIdMap;
        private final Map<String, Long> id2IndexMap;

        public CasGappedReferenceDataStoreImpl(DataStore<NucleotideSequence> delegate, String[] refIndexToIdMap) {
            this.delegate = delegate;
            this.refIndexToIdMap = refIndexToIdMap;
            this.id2IndexMap = new HashMap<String, Long>(MapUtil.computeMinHashMapSizeWithoutRehashing(refIndexToIdMap.length));
            for (int i = 0; i < refIndexToIdMap.length; ++i) {
                String id = refIndexToIdMap[i];
                if (id == null) continue;
                this.id2IndexMap.put(id, Long.valueOf(i));
            }
        }

        @Override
        public Long getIndexById(String id) {
            return this.id2IndexMap.get(id);
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            return this.delegate.idIterator();
        }

        @Override
        public NucleotideSequence get(String id) throws DataStoreException {
            return this.delegate.get(id);
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            return this.delegate.contains(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            return this.delegate.getNumberOfRecords();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public StreamingIterator<NucleotideSequence> iterator() throws DataStoreException {
            return this.delegate.iterator();
        }

        @Override
        public StreamingIterator<DataStoreEntry<NucleotideSequence>> entryIterator() throws DataStoreException {
            return this.delegate.entryIterator();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public NucleotideSequence getReferenceByIndex(long index) throws DataStoreException {
            return this.get(this.getIdByIndex(index));
        }

        @Override
        public String getIdByIndex(long index) {
            return this.refIndexToIdMap[(int)index];
        }
    }

    private class MaxRefGapVisitor
    implements CasMatchVisitor {
        private MaxRefGapVisitor() {
        }

        private List<CasAlignmentRegion> getAlignmentRegionsToConsider(CasAlignment alignment) {
            int lastIndex;
            ArrayList<CasAlignmentRegion> regionsToConsider = new ArrayList<CasAlignmentRegion>(alignment.getAlignmentRegions());
            if (((CasAlignmentRegion)regionsToConsider.get(lastIndex = regionsToConsider.size() - 1)).getType() == CasAlignmentRegionType.INSERT) {
                regionsToConsider.remove(lastIndex);
            }
            return regionsToConsider;
        }

        @Override
        public void visitMatch(CasMatch match) {
            if (match.matchReported()) {
                this.handleMatch(match);
            }
        }

        private void handleMatch(CasMatch match) {
            CasAlignment alignment = match.getChosenAlignment();
            long referenceIndex = alignment.getReferenceIndex();
            if (this.includeReadsFromThisReference(referenceIndex)) {
                this.addInsertionsToReference(alignment, referenceIndex);
            }
        }

        private void addInsertionsToReference(CasAlignment alignment, Long referenceIndex) {
            GappedReferenceBuilder builder = CasGappedReferenceDataStoreBuilderVisitor.this.gappedReferenceBuilders[referenceIndex.intValue()];
            if (builder == null) {
                return;
            }
            List<CasAlignmentRegion> regionsToConsider = this.getAlignmentRegionsToConsider(alignment);
            boolean outsideValidRange = true;
            int currentOffset = (int)alignment.getStartOfMatch();
            for (CasAlignmentRegion region : regionsToConsider) {
                if (outsideValidRange && region.getType() != CasAlignmentRegionType.INSERT) {
                    outsideValidRange = false;
                }
                if (outsideValidRange) continue;
                if (region.getType() == CasAlignmentRegionType.INSERT) {
                    builder.addReadInsertion(currentOffset, (int)region.getLength());
                    continue;
                }
                currentOffset += (int)region.getLength();
            }
        }

        private boolean includeReadsFromThisReference(long referenceIndex) {
            int i = (int)referenceIndex;
            if (i < 0 || i >= CasGappedReferenceDataStoreBuilderVisitor.this.gappedReferenceBuilders.length) {
                throw new IllegalStateException("reference file does not contain a reference with index " + referenceIndex);
            }
            return CasGappedReferenceDataStoreBuilderVisitor.this.gappedReferenceBuilders[i] != null;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }
}

