/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegionType;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentScore;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentScoreBuilder;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentType;
import org.jcvi.jillion.assembly.clc.cas.CasFileVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasMatchVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasParser;
import org.jcvi.jillion.assembly.clc.cas.CasScoreType;
import org.jcvi.jillion.assembly.clc.cas.CasScoringScheme;
import org.jcvi.jillion.assembly.clc.cas.CasUtil;
import org.jcvi.jillion.assembly.clc.cas.CasValidator;
import org.jcvi.jillion.assembly.clc.cas.DefaultCasAlignment;
import org.jcvi.jillion.assembly.clc.cas.DefaultCasFileInfo;
import org.jcvi.jillion.assembly.clc.cas.DefaultCasMatch;
import org.jcvi.jillion.assembly.clc.cas.DefaultCasReferenceDescription;
import org.jcvi.jillion.assembly.clc.cas.DefaultCasScoringScheme;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;

public final class CasFileParser
implements CasParser {
    private static final byte[] CAS_MAGIC_NUMBER_PREFIX = new byte[]{67, 76, 67, -128, 0, 0, 0};
    private int numberOfBytesForContigPosition;
    private int numberOfBytesForContigNumber;
    private long numberOfReads;
    private CasScoringScheme scoringScheme;
    private final File casFile;

    public static CasParser create(File casFile) throws IOException {
        return new CasFileParser(casFile, false);
    }

    public static CasParser create(File casFile, boolean validate) throws IOException {
        return new CasFileParser(casFile, validate);
    }

    @Override
    public File getWorkingDir() {
        return this.casFile.getParentFile();
    }

    private CasFileParser(File file, boolean validate) throws IOException {
        if (file == null) {
            throw new NullPointerException("cas file can not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.casFile = file;
        if (validate) {
            CasValidator validator = new CasValidator(this.getWorkingDir());
            this.parse(validator);
        }
    }

    @Override
    public void parse(CasFileVisitor visitor) throws IOException {
        this.parseMetaData(visitor);
        CasVisitorCallbackImpl callback = new CasVisitorCallbackImpl();
        CasMatchVisitor matchVisitor = visitor.visitMatches(callback);
        if (matchVisitor != null) {
            this.visitMatches(callback, matchVisitor);
        }
        if (callback.keepParsing()) {
            visitor.visitEnd();
        } else {
            visitor.halted();
        }
    }

    @Override
    public boolean canParse() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitMatches(CasVisitorCallbackImpl callback, CasMatchVisitor visitor) throws IOException {
        DataInputStream dataIn = new DataInputStream(new BufferedInputStream(new FileInputStream(this.casFile)));
        try {
            IOUtil.blockingSkip(dataIn, 16L);
            int i = 0;
            while (callback.keepParsing() && (long)i < this.numberOfReads) {
                long numberOfReportedAlignments;
                byte info = dataIn.readByte();
                boolean hasMatch = (info & 1) != 0;
                boolean hasMultipleMatches = (info & 2) != 0;
                boolean hasMultipleAlignments = (info & 4) != 0;
                boolean isPartOfPair = (info & 8) != 0;
                long totalNumberOfMatches = hasMatch ? 1L : 0L;
                long l = numberOfReportedAlignments = hasMatch ? 1L : 0L;
                if (hasMultipleMatches) {
                    totalNumberOfMatches = CasUtil.parseByteCountFrom(dataIn) + 2L;
                }
                if (hasMultipleAlignments) {
                    numberOfReportedAlignments = CasUtil.parseByteCountFrom(dataIn) + 2L;
                }
                int score = 0;
                DefaultCasAlignment chosenAlignment = null;
                if (hasMatch) {
                    long numberOfBytesInForThisMatch = CasUtil.parseByteCountFrom(dataIn);
                    long contigSequenceId = CasUtil.readCasUnsignedInt(dataIn, this.numberOfBytesForContigNumber);
                    long startPosition = CasUtil.readCasUnsignedInt(dataIn, this.numberOfBytesForContigPosition);
                    boolean isreverse = dataIn.readBoolean();
                    DefaultCasAlignment.Builder builder = new DefaultCasAlignment.Builder(contigSequenceId, startPosition, isreverse);
                    for (long count = 0L; count < numberOfBytesInForThisMatch; ++count) {
                        short matchValue = CasUtil.readCasUnsignedByte(dataIn);
                        if (matchValue == 255) {
                            builder.addPhaseChange(dataIn.readByte());
                            ++count;
                            continue;
                        }
                        if (matchValue < 128) {
                            builder.addRegion(CasAlignmentRegionType.MATCH_MISMATCH, matchValue + 1);
                            continue;
                        }
                        if (matchValue < 192) {
                            builder.addRegion(CasAlignmentRegionType.INSERT, matchValue - 127);
                            continue;
                        }
                        builder.addRegion(CasAlignmentRegionType.DELETION, matchValue - 191);
                    }
                    chosenAlignment = builder.build();
                }
                visitor.visitMatch(new DefaultCasMatch(hasMatch, totalNumberOfMatches, numberOfReportedAlignments, isPartOfPair, chosenAlignment, score));
                ++i;
            }
            if (callback.keepParsing()) {
                visitor.visitEnd();
            } else {
                visitor.halted();
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)dataIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMetaData(CasFileVisitor visitor) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.casFile, "r");
        RandomAccessFileInputStream in = null;
        try {
            in = new RandomAccessFileInputStream(randomAccessFile);
            byte[] magicNumber = IOUtil.toByteArray(in, 8);
            CasNumberParserStrategy strategy = CasNumberParserStrategy.valueOf(magicNumber);
            BigInteger headerOffset = CasUtil.readCasUnsignedLong(in);
            randomAccessFile.seek(headerOffset.longValue());
            long numberOfContigSequences = this.parseMetadata(visitor, in, strategy);
            this.parseProgramInfo(visitor, in);
            this.parseReferenceFiles(visitor, in, strategy);
            this.parseReadFiles(visitor, in, strategy);
            this.parseScore(visitor, in, numberOfContigSequences);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in, randomAccessFile);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors(in, randomAccessFile);
    }

    private void parseScore(CasFileVisitor visitor, RandomAccessFileInputStream in, long numberOfContigSequences) throws IOException {
        CasScoreType scoreType = CasScoreType.valueOf((byte)in.read());
        if (scoreType != CasScoreType.NO_SCORE) {
            CasAlignmentScoreBuilder alignmentScoreBuilder = new CasAlignmentScoreBuilder().firstInsertion(CasUtil.readCasUnsignedShort(in)).insertionExtension(CasUtil.readCasUnsignedShort(in)).firstDeletion(CasUtil.readCasUnsignedShort(in)).deletionExtension(CasUtil.readCasUnsignedShort(in)).match(CasUtil.readCasUnsignedShort(in)).transition(CasUtil.readCasUnsignedShort(in)).transversion(CasUtil.readCasUnsignedShort(in)).unknown(CasUtil.readCasUnsignedShort(in));
            if (scoreType == CasScoreType.COLOR_SPACE_SCORE) {
                alignmentScoreBuilder.colorSpaceError(IOUtil.readUnsignedShort(in));
            }
            CasAlignmentScore score = alignmentScoreBuilder.build();
            CasAlignmentType alignmentType = CasAlignmentType.valueOf((byte)in.read());
            this.scoringScheme = new DefaultCasScoringScheme(scoreType, score, alignmentType);
            visitor.visitScoringScheme(this.scoringScheme);
            long maxContigLength = 0L;
            for (long i = 0L; i < numberOfContigSequences; ++i) {
                long contigLength = CasUtil.readCasUnsignedInt(in);
                boolean isCircular = (IOUtil.readUnsignedShort(in) & 1) == 1;
                visitor.visitReferenceDescription(new DefaultCasReferenceDescription(contigLength, isCircular));
                maxContigLength = Math.max(maxContigLength, contigLength);
            }
            this.numberOfBytesForContigNumber = CasUtil.numberOfBytesRequiredFor(numberOfContigSequences);
            this.numberOfBytesForContigPosition = CasUtil.numberOfBytesRequiredFor(maxContigLength);
        }
    }

    private void parseReadFiles(CasFileVisitor visitor, RandomAccessFileInputStream in, CasNumberParserStrategy strategy) throws IOException {
        long numberOfReadFiles = CasUtil.parseByteCountFrom(in);
        visitor.visitNumberOfReadFiles(numberOfReadFiles);
        for (long i = 0L; i < numberOfReadFiles; ++i) {
            boolean twoFiles = (in.read() & 1) == 1;
            long numberOfSequencesInFile = strategy.parseNumber(in);
            BigInteger residuesInFile = CasUtil.readCasUnsignedLong(in);
            ArrayList<String> names = new ArrayList<String>();
            names.add(CasUtil.parseCasStringFrom(in));
            if (twoFiles) {
                names.add(CasUtil.parseCasStringFrom(in));
            }
            visitor.visitReadFileInfo(new DefaultCasFileInfo(names, numberOfSequencesInFile, residuesInFile));
        }
    }

    private void parseReferenceFiles(CasFileVisitor visitor, RandomAccessFileInputStream in, CasNumberParserStrategy strategy) throws IOException {
        long numberOfContigFiles = CasUtil.parseByteCountFrom(in);
        visitor.visitNumberOfReferenceFiles(numberOfContigFiles);
        for (long i = 0L; i < numberOfContigFiles; ++i) {
            boolean twoFiles = (in.read() & 1) == 1;
            long numberOfSequencesInFile = strategy.parseNumber(in);
            BigInteger residuesInFile = CasUtil.readCasUnsignedLong(in);
            ArrayList<String> names = new ArrayList<String>();
            names.add(CasUtil.parseCasStringFrom(in));
            if (twoFiles) {
                names.add(CasUtil.parseCasStringFrom(in));
            }
            visitor.visitReferenceFileInfo(new DefaultCasFileInfo(names, numberOfSequencesInFile, residuesInFile));
        }
    }

    private long parseMetadata(CasFileVisitor visitor, RandomAccessFileInputStream in, CasNumberParserStrategy strategy) throws IOException {
        long numberOfContigSequences = CasUtil.readCasUnsignedInt(in);
        this.numberOfReads = strategy.parseNumber(in);
        visitor.visitMetaData(numberOfContigSequences, this.numberOfReads);
        return numberOfContigSequences;
    }

    private void parseProgramInfo(CasFileVisitor visitor, RandomAccessFileInputStream in) throws IOException {
        String nameOfAssemblyProgram = CasUtil.parseCasStringFrom(in);
        String version = CasUtil.parseCasStringFrom(in);
        String parameters = CasUtil.parseCasStringFrom(in);
        visitor.visitAssemblyProgramInfo(nameOfAssemblyProgram, version, parameters);
    }

    private static enum CasNumberParserStrategy {
        REF_ASSEMBLE{

            @Override
            public long parseNumber(RandomAccessFileInputStream in) throws IOException {
                return CasUtil.readCasUnsignedInt(in);
            }
        }
        ,
        MAPPER{

            @Override
            public long parseNumber(RandomAccessFileInputStream in) throws IOException {
                return CasUtil.readCasUnsignedLong(in).longValue();
            }
        };


        public abstract long parseNumber(RandomAccessFileInputStream var1) throws IOException;

        public static CasNumberParserStrategy valueOf(byte[] magicNumber) {
            for (int i = 0; i < CAS_MAGIC_NUMBER_PREFIX.length; ++i) {
                if (CAS_MAGIC_NUMBER_PREFIX[i] == magicNumber[i]) continue;
                throw new IllegalArgumentException("input stream not a valid cas file wrong magic number expected : " + Arrays.toString(CAS_MAGIC_NUMBER_PREFIX) + " but was " + Arrays.toString(magicNumber));
            }
            switch (magicNumber[7]) {
                case 1: {
                    return REF_ASSEMBLE;
                }
                case 3: {
                    return MAPPER;
                }
            }
            throw new IllegalArgumentException("unknown cas file format version magic number = " + Arrays.toString(magicNumber));
        }
    }

    private static final class CasVisitorCallbackImpl
    implements CasFileVisitor.CasVisitorCallback {
        private final AtomicBoolean keepParsing = new AtomicBoolean(true);

        private CasVisitorCallbackImpl() {
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public CasFileVisitor.CasVisitorCallback.CasVisitorMemento createMemento() {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        public void haltParsing() {
            this.keepParsing.set(false);
        }

        public boolean keepParsing() {
            return this.keepParsing.get();
        }
    }
}

