/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jcvi.jillion.assembly.clc.cas.CasFileInfo;
import org.jcvi.jillion.assembly.clc.cas.CasUtil;
import org.jcvi.jillion.assembly.clc.cas.ReadFileType;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

final class CasFileInfoValidator {
    private CasFileInfoValidator() {
    }

    private static ActualFileInfo getActualFileInfoFor(File file) throws DataStoreException, IOException {
        ReadFileType readType = ReadFileType.getTypeFromFile(file);
        switch (readType) {
            case FASTQ: {
                return CasFileInfoValidator.getFastqInfo(file);
            }
            case SFF: {
                return CasFileInfoValidator.getSffInfo(file);
            }
            case FASTA: {
                return CasFileInfoValidator.getFastaInfo(file);
            }
        }
        throw new IllegalArgumentException("unsupported type " + file.getName());
    }

    public static void validateFileInfo(File dirOfCas, CasFileInfo expected) throws DataStoreException, IOException {
        ActualFileInfo actualInfo = new ActualFileInfo();
        for (String fileName : expected.getFileNames()) {
            File file = CasUtil.getFileFor(dirOfCas, fileName);
            actualInfo.add(CasFileInfoValidator.getActualFileInfoFor(file));
        }
        actualInfo.assertMatches(dirOfCas, expected);
    }

    /*
     * Exception decompiling
     */
    private static ActualFileInfo getFastaInfo(File fastaFile) throws IOException, DataStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ActualFileInfo getFastqInfo(File fastqFile) throws IOException, DataStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ActualFileInfo getSffInfo(File sffFile) throws IOException, DataStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> getActualFilePaths(File dirOfCas, CasFileInfo info) throws IOException {
        List<String> fileNames = info.getFileNames();
        ArrayList<String> list = new ArrayList<String>(fileNames.size());
        for (String filename : fileNames) {
            list.add(CasUtil.getFileFor(dirOfCas, filename).getCanonicalPath());
        }
        return list;
    }

    private static final class ActualFileInfo {
        long numberOfRecords = 0L;
        BigInteger numberOfResidues = BigInteger.valueOf(0L);

        private ActualFileInfo() {
        }

        public void add(NucleotideSequence seq) {
            ++this.numberOfRecords;
            this.numberOfResidues = this.numberOfResidues.add(BigInteger.valueOf(seq.getLength()));
        }

        public void add(ActualFileInfo other) {
            this.numberOfRecords += other.numberOfRecords;
            this.numberOfResidues = this.numberOfResidues.add(other.numberOfResidues);
        }

        public void assertMatches(File dirOfCas, CasFileInfo expected) throws IOException {
            if (this.numberOfRecords != expected.getNumberOfSequences()) {
                throw new IllegalStateException("file(s) " + CasFileInfoValidator.getActualFilePaths(dirOfCas, expected) + " have wrong number of sequences: " + this.numberOfRecords + " instead of " + expected.getNumberOfSequences() + ". Usually this is caused by the input files getting updated after the cas was created");
            }
            if (!this.numberOfResidues.equals(expected.getNumberOfResidues())) {
                throw new IllegalStateException("file(s) " + CasFileInfoValidator.getActualFilePaths(dirOfCas, expected) + " have wrong number of residues: " + this.numberOfResidues + " instead of " + expected.getNumberOfResidues() + ". Usually this is caused by the input files getting updated after the cas was created");
            }
        }
    }
}

