/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.clc.cas.AbstractCasFileVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasAlignment;
import org.jcvi.jillion.assembly.clc.cas.CasFileInfo;
import org.jcvi.jillion.assembly.clc.cas.CasFileVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasMatch;
import org.jcvi.jillion.assembly.clc.cas.CasMatchVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasUtil;
import org.jcvi.jillion.assembly.clc.cas.ReadFileType;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStoreBuilder;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.trace.Trace;
import org.jcvi.jillion.trace.TraceDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStoreBuilder;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.sff.SffFileDataStoreBuilder;

public abstract class AbstractReadCasVisitor
extends AbstractCasFileVisitor {
    private final File workingDir;
    private final List<StreamingIterator<? extends Trace>> iterators = new ArrayList<StreamingIterator<? extends Trace>>();
    private FastqQualityCodec qualityCodec = null;
    private List<String> referenceIds = new ArrayList<String>();
    private StreamingIterator<Trace> chainedTraceIterator;

    public AbstractReadCasVisitor(File workingDir) {
        this.workingDir = workingDir;
    }

    public FastqQualityCodec getQualityCodec() {
        return this.qualityCodec;
    }

    public void setQualityCodec(FastqQualityCodec qualityCodec) {
        this.qualityCodec = qualityCodec;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void visitReferenceFileInfo(CasFileInfo referenceFileInfo) {
        for (String path : referenceFileInfo.getFileNames()) {
            try {
                File fastaFile = CasUtil.getFileFor(this.workingDir, path);
                NucleotideFastaFileDataStore datastore = new NucleotideFastaFileDataStoreBuilder(fastaFile).hint(DataStoreProviderHint.ITERATION_ONLY).build();
                Throwable throwable = null;
                try {
                    StreamingIterator<String> iter = datastore.idIterator();
                    Throwable throwable2 = null;
                    try {
                        while (iter.hasNext()) {
                            this.referenceIds.add(iter.next());
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (iter == null) continue;
                        if (throwable2 != null) {
                            try {
                                iter.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        iter.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (datastore == null) continue;
                    if (throwable != null) {
                        try {
                            datastore.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    datastore.close();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing reference data", e);
            }
        }
    }

    @Override
    public void visitReadFileInfo(CasFileInfo readFileInfo) {
        List<String> fileNames = readFileInfo.getFileNames();
        if (fileNames.isEmpty()) {
            return;
        }
        if (fileNames.size() == 1) {
            try {
                File file = CasUtil.getFileFor(this.workingDir, fileNames.get(0));
                this.iterators.add(this.createIteratorFor(file));
            }
            catch (Exception e) {
                for (StreamingIterator<? extends Trace> iter : this.iterators) {
                    IOUtil.closeAndIgnoreErrors(iter);
                }
                throw new IllegalStateException("error getting input read data", e);
            }
        }
        ArrayList<StreamingIterator<? extends Trace>> iteratorLists = new ArrayList<StreamingIterator<? extends Trace>>(fileNames.size());
        try {
            for (String filePath : fileNames) {
                File file = CasUtil.getFileFor(this.workingDir, filePath);
                iteratorLists.add(this.createIteratorFor(file));
            }
            this.iterators.add(new InterleavedStreamingIterators(iteratorLists));
        }
        catch (Exception e) {
            for (StreamingIterator streamingIterator : iteratorLists) {
                IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
            }
            for (StreamingIterator streamingIterator : this.iterators) {
                IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
            }
            throw new IllegalStateException("error getting input read data", e);
        }
    }

    private StreamingIterator<? extends Trace> createIteratorFor(File file) throws DataStoreException, IOException {
        ReadFileType readType = ReadFileType.getTypeFromFile(file);
        switch (readType) {
            case FASTQ: {
                return this.createFastqIterator(file);
            }
            case SFF: {
                return this.createSffIterator(file);
            }
            case FASTA: {
                return this.createFastaIterator(file);
            }
        }
        throw new IllegalArgumentException("unsupported type " + file.getName());
    }

    private StreamingIterator<? extends Trace> createFastqIterator(File illuminaFile) throws DataStoreException {
        try {
            FastqFileDataStore datastore = this.createFastqDataStore(illuminaFile);
            return this.createIteratorFor(datastore);
        }
        catch (IOException e) {
            throw new IllegalStateException("error processing fastq file: " + illuminaFile.getAbsolutePath(), e);
        }
    }

    protected StreamingIterator<? extends Trace> createIteratorFor(FastqFileDataStore datastore) throws DataStoreException {
        return new RemoveWhitespaceFromIdAdapter(datastore.iterator());
    }

    protected FastqFileDataStore createFastqDataStore(File fastqFile) throws IOException {
        FastqFileDataStoreBuilder builder = new FastqFileDataStoreBuilder(fastqFile).hint(DataStoreProviderHint.ITERATION_ONLY);
        FastqQualityCodec codecToUse = this.getQualityCodec();
        if (codecToUse != null) {
            builder.qualityCodec(codecToUse);
        }
        return builder.build();
    }

    protected StreamingIterator<? extends Trace> createSffIterator(File sffFile) throws DataStoreException, IOException {
        return new SffFileDataStoreBuilder(sffFile).hint(DataStoreProviderHint.ITERATION_ONLY).build().iterator();
    }

    protected StreamingIterator<? extends Trace> createFastaIterator(File fastaFile) throws DataStoreException {
        try {
            NucleotideFastaFileDataStore datastore = new NucleotideFastaFileDataStoreBuilder(fastaFile).hint(DataStoreProviderHint.ITERATION_ONLY).build();
            TraceDataStore fakeQualities = DataStore.adapt(TraceDataStore.class, datastore, from -> {
                int numberOfQualities = (int)((NucleotideSequence)from.getSequence()).getLength();
                byte[] qualities = new byte[numberOfQualities];
                Arrays.fill(qualities, PhredQuality.valueOf(30).getQualityScore());
                final QualitySequence qualSequence = new QualitySequenceBuilder(qualities).build();
                return new Trace((NucleotideFastaRecord)from){
                    final /* synthetic */ NucleotideFastaRecord val$from;
                    {
                        this.val$from = nucleotideFastaRecord;
                    }

                    @Override
                    public QualitySequence getQualitySequence() {
                        return qualSequence;
                    }

                    @Override
                    public NucleotideSequence getNucleotideSequence() {
                        return (NucleotideSequence)this.val$from.getSequence();
                    }

                    @Override
                    public String getId() {
                        return this.val$from.getId();
                    }
                };
            });
            return fakeQualities.iterator();
        }
        catch (IOException e) {
            throw new DataStoreException("error reading fasta file " + fastaFile.getAbsolutePath(), e);
        }
    }

    protected abstract void notAligned(Trace var1);

    protected abstract void aligned(Trace var1, String var2, CasMatch var3);

    @Override
    public CasMatchVisitor visitMatches(CasFileVisitor.CasVisitorCallback callback) {
        this.chainedTraceIterator = IteratorUtil.createChainedStreamingIterator(this.iterators);
        return new TraceCasMatchVisitor(this.chainedTraceIterator);
    }

    protected void closeIterator() {
        IOUtil.closeAndIgnoreErrors(this.chainedTraceIterator);
    }

    private static class InterleavedStreamingIterators
    implements StreamingIterator<Trace> {
        private final List<StreamingIterator<? extends Trace>> iterators;
        private int offset = 0;

        public InterleavedStreamingIterators(List<StreamingIterator<? extends Trace>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            return this.iterators.get(this.offset).hasNext();
        }

        @Override
        public void close() {
            for (StreamingIterator<? extends Trace> iter : this.iterators) {
                IOUtil.closeAndIgnoreErrors(iter);
            }
        }

        @Override
        public Trace next() {
            Trace next = this.iterators.get(this.offset++).next();
            if (this.offset == this.iterators.size()) {
                this.offset = 0;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class RemoveWhitespaceFromIdAdapter
    implements StreamingIterator<FastqRecord> {
        private final StreamingIterator<FastqRecord> delegate;
        private static Pattern WHITESPACE_PATTERN = Pattern.compile("^(\\S+)\\s+(\\S+)$");

        public RemoveWhitespaceFromIdAdapter(StreamingIterator<FastqRecord> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public FastqRecord next() {
            FastqRecord record = this.delegate.next();
            Matcher matcher = WHITESPACE_PATTERN.matcher(record.getId());
            if (matcher.matches()) {
                return record.toBuilder().id(matcher.group(1) + "_" + matcher.group(2)).build();
            }
            return record;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    private class TraceCasMatchVisitor
    implements CasMatchVisitor {
        private final StreamingIterator<Trace> chainedTraceIterator;

        public TraceCasMatchVisitor(StreamingIterator<Trace> chainedTraceIterator) {
            this.chainedTraceIterator = chainedTraceIterator;
        }

        @Override
        public void visitMatch(CasMatch match) {
            if (!this.chainedTraceIterator.hasNext()) {
                AbstractReadCasVisitor.this.closeIterator();
                throw new IllegalStateException("possible cas file corruption : no more reads in input files but cas file says there are more reads");
            }
            Trace currentTrace = this.chainedTraceIterator.next();
            if (match.matchReported()) {
                CasAlignment alignment = match.getChosenAlignment();
                int refIndex = (int)alignment.getReferenceIndex();
                String refId = (String)AbstractReadCasVisitor.this.referenceIds.get(refIndex);
                AbstractReadCasVisitor.this.aligned(currentTrace, refId, match);
            } else {
                AbstractReadCasVisitor.this.notAligned(currentTrace);
            }
        }

        @Override
        public void visitEnd() {
            AbstractReadCasVisitor.this.closeIterator();
        }

        @Override
        public void halted() {
            AbstractReadCasVisitor.this.closeIterator();
        }
    }
}

