/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.clc.cas;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.clc.cas.AbstractReadCasVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasAlignment;
import org.jcvi.jillion.assembly.clc.cas.CasGappedReferenceDataStore;
import org.jcvi.jillion.assembly.clc.cas.CasMatch;
import org.jcvi.jillion.assembly.clc.cas.ReAlignReads;
import org.jcvi.jillion.assembly.clc.cas.read.CasPlacedRead;
import org.jcvi.jillion.assembly.clc.cas.read.DefaultCasPlacedRead;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.trace.Trace;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffUtil;

public abstract class AbstractAlignedReadCasVisitor
extends AbstractReadCasVisitor {
    private final CasGappedReferenceDataStore gappedReferenceDataStore;
    private FastqQualityCodec qualityCodec = null;
    private Map<String, ReAlignReads> reAligners = new HashMap<String, ReAlignReads>();

    public AbstractAlignedReadCasVisitor(File workingDir, CasGappedReferenceDataStore gappedReferenceDataStore) {
        super(workingDir);
        if (gappedReferenceDataStore == null) {
            throw new NullPointerException("gapped Reference DataStore can not be null");
        }
        this.gappedReferenceDataStore = gappedReferenceDataStore;
    }

    @Override
    public FastqQualityCodec getQualityCodec() {
        return this.qualityCodec;
    }

    @Override
    public void setQualityCodec(FastqQualityCodec qualityCodec) {
        this.qualityCodec = qualityCodec;
    }

    public final CasGappedReferenceDataStore getGappedReferenceDataStore() {
        return this.gappedReferenceDataStore;
    }

    protected abstract void aligned(Trace var1, String var2, CasPlacedRead var3);

    @Override
    protected void aligned(Trace currentTrace, String referenceId, CasMatch match) {
        CasAlignment alignment = match.getChosenAlignment();
        long refIndex = alignment.getReferenceIndex();
        String refId = this.gappedReferenceDataStore.getIdByIndex(refIndex);
        String readId = currentTrace.getId();
        try {
            Range trimRange;
            if (refId == null) {
                this.closeIterator();
                throw new IllegalStateException("could not get get gapped reference for index " + refIndex);
            }
            if (!this.gappedReferenceDataStore.contains(refId)) {
                return;
            }
            ReAlignReads reAligner = this.reAligners.get(refId);
            if (reAligner == null) {
                NucleotideSequence gappedReference = (NucleotideSequence)this.gappedReferenceDataStore.get(refId);
                reAligner = new ReAlignReads(gappedReference, true);
                this.reAligners.put(refId, reAligner);
            }
            if ((trimRange = match.getTrimRange()) == null && currentTrace instanceof SffFlowgram) {
                trimRange = SffUtil.computeTrimRangeFor((SffFlowgram)currentTrace);
            }
            Direction dir = alignment.readIsReversed() ? Direction.REVERSE : Direction.FORWARD;
            ReAlignReads.ReAlignResult reAlignResult = reAligner.realignValidBases(currentTrace.getNucleotideSequence(), alignment.getStartOfMatch(), dir, alignment.getAlignmentRegions(), trimRange);
            DefaultCasPlacedRead read = new DefaultCasPlacedRead(readId, (ReferenceMappedNucleotideSequence)reAlignResult.getGappedValidBases(), reAlignResult.getGappedStartOffset(), reAlignResult.getValidRange(), dir, (int)currentTrace.getNucleotideSequence().getLength());
            this.aligned(currentTrace, refId, read);
        }
        catch (Throwable e) {
            this.closeIterator();
            throw new IllegalStateException("processing read " + readId + " for reference " + refId, e);
        }
    }
}

