/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.frg;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.ca.frg.AbstractFragmentDataStore;
import org.jcvi.jillion.assembly.ca.frg.DefaultFragment;
import org.jcvi.jillion.assembly.ca.frg.Distance;
import org.jcvi.jillion.assembly.ca.frg.Fragment;
import org.jcvi.jillion.assembly.ca.frg.FragmentDataStore;
import org.jcvi.jillion.assembly.ca.frg.Frg2Parser;
import org.jcvi.jillion.assembly.ca.frg.Frg2Visitor;
import org.jcvi.jillion.assembly.ca.frg.Library;
import org.jcvi.jillion.assembly.ca.frg.MateOrientation;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

public final class IndexedFragmentDataStore
extends AbstractFragmentDataStore {
    private final Map<String, Range> fragmentInfoIndexFileRange;
    private final Map<String, Range> mateInfoIndexFileRange;
    private final File fragFile;
    private final Frg2Parser parser;
    private int currentStart = 0;
    private int currentPosition = -1;
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FragmentDataStore create(File frgFile) throws FileNotFoundException {
        IndexedFragmentDataStore indexedFragmentDataStore;
        Frg2Parser parserInstance = new Frg2Parser();
        IndexedFragmentDataStore datastore = new IndexedFragmentDataStore(frgFile, parserInstance);
        FileInputStream in = null;
        try {
            in = new FileInputStream(frgFile);
            parserInstance.parse(in, datastore);
            indexedFragmentDataStore = datastore;
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
        return indexedFragmentDataStore;
    }

    private IndexedFragmentDataStore(File file, Map<String, Range> fragmentInfoIndexFileRange, Map<String, Range> mateInfoIndexFileRange, Frg2Parser parser) {
        this.fragmentInfoIndexFileRange = fragmentInfoIndexFileRange;
        this.mateInfoIndexFileRange = mateInfoIndexFileRange;
        this.parser = parser;
        this.fragFile = file;
    }

    private IndexedFragmentDataStore(File file, Frg2Parser parser) {
        this(file, new LinkedHashMap<String, Range>(), new LinkedHashMap<String, Range>(), parser);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    protected void throwErrorIfClosed() {
        if (this.isClosed()) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    @Override
    public void visitFragment(Frg2Visitor.FrgAction action, String fragmentId, String libraryId, NucleotideSequence bases, QualitySequence qualities, Range validRange, Range vectorClearRange, String source) {
        this.throwErrorIfAlreadyInitialized();
        if (this.isAddOrModify(action)) {
            Range fragmentRange = Range.of(this.currentStart, (long)this.currentPosition);
            this.fragmentInfoIndexFileRange.put(fragmentId, fragmentRange);
            this.updateRangeStartPosition();
        } else if (this.isDelete(action)) {
            this.handleDelete(fragmentId);
        }
    }

    private void handleDelete(String frgId) {
    }

    @Override
    public void visitLibrary(Frg2Visitor.FrgAction action, String id, MateOrientation orientation, Distance distance) {
        super.visitLibrary(action, id, orientation, distance);
        this.updateRangeStartPosition();
    }

    private void updateRangeStartPosition() {
        this.currentStart = this.currentPosition + 1;
    }

    @Override
    public void visitLine(String line) {
        this.throwErrorIfAlreadyInitialized();
        this.currentPosition += line.length();
    }

    @Override
    public boolean contains(String fragmentId) throws DataStoreException {
        this.throwErrorIfClosed();
        return this.fragmentInfoIndexFileRange.containsKey(fragmentId);
    }

    @Override
    public Fragment get(String id) throws DataStoreException {
        this.throwErrorIfClosed();
        Range range = this.fragmentInfoIndexFileRange.get(id);
        try {
            InputStream in = IOUtil.createInputStreamFromFile(this.fragFile, (int)range.getBegin(), (int)range.getLength());
            SingleFragVisitor singleFragVisitor = new SingleFragVisitor();
            this.parser.parse(in, singleFragVisitor);
            return singleFragVisitor.getFragmentToReturn();
        }
        catch (IOException e) {
            throw new DataStoreException("error reading frg file", e);
        }
    }

    @Override
    public StreamingIterator<String> idIterator() {
        this.throwErrorIfClosed();
        return DataStoreStreamingIterator.create(this, this.fragmentInfoIndexFileRange.keySet().iterator());
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.throwErrorIfClosed();
        return this.fragmentInfoIndexFileRange.size();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    @Override
    public StreamingIterator<Fragment> iterator() {
        FrgIterator iter = new FrgIterator();
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public Fragment getMateOf(Fragment fragment) throws DataStoreException {
        this.throwErrorIfClosed();
        String fragId = fragment.getId();
        try {
            String mateId = this.getMateIdOf(fragId);
            return this.get(mateId);
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing mate info from frg file", e);
        }
    }

    @Override
    public boolean hasMate(Fragment fragment) throws DataStoreException {
        this.throwErrorIfClosed();
        String fragId = fragment.getId();
        try {
            return this.getMateIdOf(fragId) != null;
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing mate info from frg file", e);
        }
    }

    private String getMateIdOf(String fragId) throws IOException {
        Range range = this.mateInfoIndexFileRange.get(fragId);
        InputStream in = IOUtil.createInputStreamFromFile(this.fragFile, (int)range.getBegin(), (int)range.getLength());
        SingleLinkVisitor singleLinkVisitor = new SingleLinkVisitor(fragId);
        this.parser.parse(in, singleLinkVisitor);
        return singleLinkVisitor.getMateId();
    }

    @Override
    public void visitLink(Frg2Visitor.FrgAction action, List<String> fragIds) {
        this.throwErrorIfAlreadyInitialized();
        if (this.isAddOrModify(action)) {
            Range fragmentRange = Range.of(this.currentStart, (long)this.currentPosition);
            for (String fragmentId : fragIds) {
                this.mateInfoIndexFileRange.put(fragmentId, fragmentRange);
            }
            this.updateRangeStartPosition();
        } else if (this.isDelete(action)) {
            for (String fragmentId : fragIds) {
                this.handleDelete(fragmentId);
            }
        }
    }

    private class FrgIterator
    extends AbstractBlockingStreamingIterator<Fragment> {
        private FrgIterator() {
        }

        @Override
        protected void backgroundThreadRunMethod() {
            Frg2Visitor visitor = new Frg2Visitor(){

                @Override
                public void visitLine(String line) {
                }

                @Override
                public void visitFile() {
                }

                @Override
                public void visitEndOfFile() {
                }

                @Override
                public void visitLibrary(Frg2Visitor.FrgAction action, String id, MateOrientation orientation, Distance distance) {
                }

                @Override
                public void visitFragment(Frg2Visitor.FrgAction action, String fragmentId, String libraryId, NucleotideSequence bases, QualitySequence qualities, Range validRange, Range vectorClearRange, String source) {
                    if (IndexedFragmentDataStore.this.fragmentInfoIndexFileRange.containsKey(fragmentId)) {
                        try {
                            Library library = IndexedFragmentDataStore.this.getLibrary(libraryId);
                            DefaultFragment frg = new DefaultFragment(fragmentId, bases, qualities, validRange, vectorClearRange, library, source);
                            FrgIterator.this.blockingPut(frg);
                        }
                        catch (DataStoreException e) {
                            throw new IllegalStateException("could not get library " + libraryId, e);
                        }
                    }
                }

                @Override
                public void visitLink(Frg2Visitor.FrgAction action, List<String> fragIds) {
                }
            };
            FileInputStream in = null;
            try {
                in = new FileInputStream(IndexedFragmentDataStore.this.fragFile);
                new Frg2Parser().parse(in, visitor);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new IllegalStateException("error reading frg file", e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeAndIgnoreErrors(in);
                    throw throwable;
                }
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
    }

    private static class SingleLinkVisitor
    implements Frg2Visitor {
        private String mateId = null;
        private final String fragmentIdToGetMateOf;

        public SingleLinkVisitor(String fragmentIdToGetMateOf) {
            this.fragmentIdToGetMateOf = fragmentIdToGetMateOf;
        }

        public String getMateId() {
            return this.mateId;
        }

        @Override
        public void visitFragment(Frg2Visitor.FrgAction action, String fragmentId, String libraryId, NucleotideSequence bases, QualitySequence qualities, Range validRange, Range vectorClearRange, String source) {
        }

        @Override
        public void visitLibrary(Frg2Visitor.FrgAction action, String id, MateOrientation orientation, Distance distance) {
        }

        @Override
        public void visitLink(Frg2Visitor.FrgAction action, List<String> fragIds) {
            for (String fragId : fragIds) {
                if (fragId.equals(this.fragmentIdToGetMateOf)) continue;
                this.mateId = fragId;
            }
        }

        @Override
        public void visitEndOfFile() {
        }

        @Override
        public void visitLine(String line) {
        }

        @Override
        public void visitFile() {
        }
    }

    private class SingleFragVisitor
    implements Frg2Visitor {
        Fragment fragmentToReturn = null;

        private SingleFragVisitor() {
        }

        public Fragment getFragmentToReturn() {
            return this.fragmentToReturn;
        }

        @Override
        public void visitFragment(Frg2Visitor.FrgAction action, String fragmentId, String libraryId, NucleotideSequence bases, QualitySequence qualities, Range validRange, Range vectorClearRange, String source) {
            Library library;
            try {
                library = IndexedFragmentDataStore.this.getLibrary(libraryId);
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("Fragment uses library " + libraryId + "before it is declared", e);
            }
            this.fragmentToReturn = new DefaultFragment(fragmentId, bases, qualities, validRange, vectorClearRange, library, source);
        }

        @Override
        public void visitLibrary(Frg2Visitor.FrgAction action, String id, MateOrientation orientation, Distance distance) {
        }

        @Override
        public void visitLink(Frg2Visitor.FrgAction action, List<String> fragIds) {
        }

        @Override
        public void visitEndOfFile() {
        }

        @Override
        public void visitLine(String line) {
        }

        @Override
        public void visitFile() {
        }
    }
}

