/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.frg;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.ca.frg.Distance;
import org.jcvi.jillion.assembly.ca.frg.FragmentUtil;
import org.jcvi.jillion.assembly.ca.frg.Frg2Visitor;
import org.jcvi.jillion.assembly.ca.frg.MateOrientation;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.core.io.LineParser;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public class Frg2Parser {
    private static final Pattern ACC_ID_PATTERN = Pattern.compile("acc:(\\S+)");
    private static final Pattern LKG_FRG_ID_PATTERN = Pattern.compile("frg:(\\d+)");
    private static final Pattern ACTION_PATTERN = Pattern.compile("act:([A|M|I|D])\\s+");
    private static final Pattern LIB_ORIENTATION_PATTERN = Pattern.compile("ori:\\s*?(\\w)");
    private static final Pattern LIB_DST_PATTERN = Pattern.compile("mea:\\s*?(\\S+)\\s*?.*?std:\\s*?(\\S+)");
    private static final Pattern SOURCE_PATTERN = Pattern.compile("src:\\s+");
    private static final Pattern FRG_VECTOR_CLEAR_RANGE_PATTERN = Pattern.compile("clv:(\\d+,\\d+)");
    private static final Pattern FRG_LIB_PATTERN = Pattern.compile("lib:(\\S+)");
    private static final String BEGIN_LIB = "{LIB";
    private static final String BEGIN_FRG = "{FRG";
    private static final String BEGIN_LKG = "{LKG";

    public static void parse2(File frgFile, Frg2Visitor visitor) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(frgFile);
            Frg2Parser.parse2(in, visitor);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
    }

    public static void parse2(InputStream frgStream, Frg2Visitor visitor) throws IOException {
        TextLineParser parser = new TextLineParser(new BufferedInputStream(frgStream));
        while (parser.hasNextLine()) {
            String line = parser.nextLine();
            visitor.visitLine(line);
            if (line.startsWith("#")) continue;
            if (line.startsWith(BEGIN_LIB)) {
                Frg2Parser.handleLibrary(parser, visitor);
                continue;
            }
            if (line.startsWith(BEGIN_FRG)) {
                Frg2Parser.handleFragment(parser, visitor);
                continue;
            }
            if (!line.startsWith(BEGIN_LKG)) continue;
            Frg2Parser.handleLink(parser, visitor);
        }
    }

    private static void handleLink(LineParser parser, Frg2Visitor visitor) throws IOException {
        String actionLine = parser.nextLine();
        visitor.visitLine(actionLine);
        Frg2Visitor.FrgAction action = Frg2Parser.parseAction(actionLine);
        ArrayList<String> ids = new ArrayList<String>(2);
        ids.add(Frg2Parser.parseFrgUid(parser, visitor));
        ids.add(Frg2Parser.parseFrgUid(parser, visitor));
        Frg2Parser.parseEndOfBlock(parser, visitor);
        visitor.visitLink(action, ids);
    }

    private static void parseEndOfBlock(LineParser parser, Frg2Visitor visitor) throws IOException {
        String line = parser.nextLine();
        visitor.visitLine(line);
        if (!line.startsWith("}")) {
            throw new IOException("error reading end of block");
        }
    }

    private static String parseFrgUid(LineParser parser, Frg2Visitor visitor) throws IOException {
        String line = parser.nextLine();
        visitor.visitLine(line);
        Matcher matcher = LKG_FRG_ID_PATTERN.matcher(line);
        if (!matcher.find()) {
            throw new IOException("error parsing frg UID : " + line);
        }
        return matcher.group(1);
    }

    private static void handleFragment(LineParser parser, Frg2Visitor visitor) {
    }

    private static void handleLibrary(LineParser parser, Frg2Visitor visitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream in, Frg2Visitor visitor) {
        Scanner scanner = new Scanner(in, "UTF-8").useDelimiter("\n");
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                visitor.visitLine(line + "\n");
                if (line.startsWith("#")) continue;
                String block = FragmentUtil.readRestOfBlock(scanner, visitor);
                if (line.startsWith(BEGIN_LIB)) {
                    this.parseLibraryFrom(block, visitor);
                    continue;
                }
                if (line.startsWith(BEGIN_FRG)) {
                    this.parseFragmentFrom(block, visitor);
                    continue;
                }
                if (!line.startsWith(BEGIN_LKG)) continue;
                this.parseLinkFrom(block, visitor);
            }
            visitor.visitEndOfFile();
        }
        finally {
            IOUtil.closeAndIgnoreErrors(scanner);
        }
    }

    private void parseLinkFrom(String lkg, Frg2Visitor visitor) {
        Frg2Visitor.FrgAction action = Frg2Parser.parseAction(lkg);
        Scanner scanner = new Scanner(lkg);
        ArrayList<String> fragIds = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            Matcher matcher = LKG_FRG_ID_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            fragIds.add(matcher.group(1));
        }
        visitor.visitLink(action, fragIds);
    }

    private static Frg2Visitor.FrgAction parseAction(String message) {
        Matcher matcher = ACTION_PATTERN.matcher(message);
        if (matcher.find()) {
            return Frg2Visitor.FrgAction.parseAction(matcher.group(1).charAt(0));
        }
        throw new IllegalStateException("Could not find a Fragment Action in " + message);
    }

    private void parseLibraryFrom(String libraryRecord, Frg2Visitor visitor) {
        String id = this.parseIdFrom(libraryRecord);
        MateOrientation orientation = this.parseMateOrientationFrom(libraryRecord);
        Distance distance = this.createDistanceFrom(libraryRecord);
        Frg2Visitor.FrgAction action = Frg2Parser.parseAction(libraryRecord);
        visitor.visitLibrary(action, id, orientation, distance);
    }

    private MateOrientation parseMateOrientationFrom(String libraryRecord) {
        Matcher orientationMatcher = LIB_ORIENTATION_PATTERN.matcher(libraryRecord);
        MateOrientation orientation = orientationMatcher.find() ? MateOrientation.parseMateOrientation(orientationMatcher.group(1)) : MateOrientation.UNORIENTED;
        return orientation;
    }

    private Distance createDistanceFrom(String libraryRecord) {
        Matcher distanceMatcher = LIB_DST_PATTERN.matcher(libraryRecord);
        if (distanceMatcher.find()) {
            return Distance.buildDistance(Float.parseFloat(distanceMatcher.group(1)), Float.parseFloat(distanceMatcher.group(2)));
        }
        return null;
    }

    private void parseFragmentFrom(String frg, Frg2Visitor visitor) {
        String id = this.parseIdFrom(frg);
        Frg2Visitor.FrgAction action = Frg2Parser.parseAction(frg);
        if (action == Frg2Visitor.FrgAction.DELETE) {
            visitor.visitFragment(action, id, null, null, null, null, null, null);
        } else {
            NucleotideSequence bases = FragmentUtil.parseBasesFrom(frg);
            QualitySequence qualities = FragmentUtil.parseEncodedQualitySequence(frg);
            Range validRange = FragmentUtil.parseValidRangeFrom(frg);
            Range vectorClearRange = this.parseVectorClearRangeFrom(frg);
            if (vectorClearRange == null && validRange != null) {
                vectorClearRange = validRange;
            }
            String libraryId = this.parseLibraryIdFrom(frg);
            String source = this.parseSourceFrom(frg);
            visitor.visitFragment(action, id, libraryId, bases, qualities, validRange, vectorClearRange, source);
        }
    }

    private String parseSourceFrom(String frg) {
        String line;
        Scanner scanner = new Scanner(frg);
        scanner.findWithinHorizon(SOURCE_PATTERN, 0);
        StringBuilder bases = new StringBuilder();
        while (scanner.hasNextLine() && !FragmentUtil.endOfMultilineField(line = scanner.nextLine())) {
            bases.append(line).append("\n");
        }
        return bases.toString();
    }

    private String parseLibraryIdFrom(String frg) {
        Matcher libraryMatcher = FRG_LIB_PATTERN.matcher(frg);
        if (libraryMatcher.find()) {
            return libraryMatcher.group(1);
        }
        return null;
    }

    private Range parseVectorClearRangeFrom(String frg) {
        Matcher matcher = FRG_VECTOR_CLEAR_RANGE_PATTERN.matcher(frg);
        return FragmentUtil.parseRangeFrom(matcher);
    }

    protected String parseIdFrom(String frg) {
        Matcher matcher = ACC_ID_PATTERN.matcher(frg);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

