/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.frg;

public final class Distance {
    private static final float SIX = 6.0f;
    private static final int CA_GATEKEEPER_STDDEV_LIMIT = 3;
    private static final float MAX_ROUNDING_ERROR = 1.015f;
    private final int min;
    private final int max;
    private final float mean;
    private final float stdDev;

    public static Distance buildDistance(int min, int max, float mean, float stdDev) {
        return new Distance(min, max, mean, stdDev);
    }

    public static Distance buildDistance(float mean, float stdDev) {
        float delta = Distance.calculateDelta(stdDev);
        int plusDelta = (int)(mean + delta);
        int minusDelta = (int)(mean - delta);
        return new Distance(Math.min(plusDelta, minusDelta), Math.max(plusDelta, minusDelta), mean, stdDev);
    }

    private static float calculateDelta(float stdDev) {
        return 3.0f * stdDev;
    }

    public static Distance buildDistance(int min, int max) {
        float mean = Distance.computeMean(min, max);
        float stdDev = Distance.computeStandardDeviation(min, max);
        return new Distance(min, max, mean, stdDev);
    }

    private static float computeStandardDeviation(int min, int max) {
        return (float)(max - min) / 6.0f;
    }

    private static float computeMean(int min, int max) {
        return (float)min / 2.0f + (float)max / 2.0f;
    }

    public static Distance transformIntoCeleraAssemblerDistance(Distance distance) {
        float stdDev;
        float mean = distance.getMean();
        if (mean < Distance.calculateDelta(stdDev = distance.getStdDev())) {
            float correctedStdDev = (mean - 1.015f) / 3.0f;
            return new Distance(distance.getMin(), distance.getMax(), mean, correctedStdDev);
        }
        return distance;
    }

    private Distance(int min, int max, float mean, float stdDev) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.stdDev = stdDev;
    }

    public float getMean() {
        return this.mean;
    }

    public float getStdDev() {
        return this.stdDev;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.max;
        result = 31 * result + Float.floatToIntBits(this.mean);
        result = 31 * result + this.min;
        result = 31 * result + Float.floatToIntBits(this.stdDev);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distance)) {
            return false;
        }
        Distance other = (Distance)obj;
        if (this.max != other.max) {
            return false;
        }
        if (Float.floatToIntBits(this.mean) != Float.floatToIntBits(other.mean)) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        return Float.floatToIntBits(this.stdDev) == Float.floatToIntBits(other.stdDev);
    }

    public String toString() {
        return String.format("%.3f, std: %.3f", Float.valueOf(this.mean), Float.valueOf(this.stdDev));
    }
}

