/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.frg;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.ca.frg.AbstractFragmentDataStore;
import org.jcvi.jillion.assembly.ca.frg.DefaultFragment;
import org.jcvi.jillion.assembly.ca.frg.Fragment;
import org.jcvi.jillion.assembly.ca.frg.FragmentDataStore;
import org.jcvi.jillion.assembly.ca.frg.Frg2Parser;
import org.jcvi.jillion.assembly.ca.frg.Frg2Visitor;
import org.jcvi.jillion.assembly.ca.frg.Library;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public final class DefaultFragmentDataStore
extends AbstractFragmentDataStore {
    private final Map<String, Fragment> fragments = new LinkedHashMap<String, Fragment>();
    private final Map<String, String> fragmentMates = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FragmentDataStore create(File frgFile) throws FileNotFoundException {
        DefaultFragmentDataStore defaultFragmentDataStore;
        Frg2Parser parserInstance = new Frg2Parser();
        DefaultFragmentDataStore datastore = new DefaultFragmentDataStore();
        FileInputStream in = null;
        try {
            in = new FileInputStream(frgFile);
            parserInstance.parse(in, datastore);
            defaultFragmentDataStore = datastore;
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
        return defaultFragmentDataStore;
    }

    private DefaultFragmentDataStore() {
    }

    @Override
    public void visitLink(Frg2Visitor.FrgAction action, List<String> fragIds) {
        this.throwErrorIfAlreadyInitialized();
        if (fragIds.size() != 2) {
            throw new IllegalArgumentException("only supports 1 : 1 mate pairs");
        }
        String forward = fragIds.get(0);
        String reverse = fragIds.get(1);
        if (this.isAddOrModify(action)) {
            this.fragmentMates.put(forward, reverse);
            this.fragmentMates.put(reverse, forward);
        } else if (this.isDelete(action)) {
            this.fragmentMates.remove(forward);
            this.fragmentMates.remove(reverse);
        }
    }

    @Override
    public Fragment getMateOf(Fragment fragment) throws DataStoreException {
        this.throwErrorIfClosed();
        if (!this.hasMate(fragment)) {
            return null;
        }
        String mateId = this.fragmentMates.get(fragment.getId());
        return this.get(mateId);
    }

    @Override
    public boolean hasMate(Fragment fragment) {
        this.throwErrorIfClosed();
        return this.fragmentMates.containsKey(fragment.getId());
    }

    @Override
    public void visitFragment(Frg2Visitor.FrgAction action, String fragmentId, String libraryId, NucleotideSequence bases, QualitySequence qualities, Range validRange, Range vectorClearRange, String source) {
        this.throwErrorIfAlreadyInitialized();
        if (this.isAddOrModify(action)) {
            Library library;
            try {
                library = this.getLibrary(libraryId);
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("Fragment uses library " + libraryId + "before it is declared", e);
            }
            DefaultFragment frag = new DefaultFragment(fragmentId, bases, qualities, validRange, vectorClearRange, library, source);
            this.fragments.put(fragmentId, frag);
        } else if (this.isDelete(action)) {
            this.fragments.remove(fragmentId);
        }
    }

    @Override
    public void visitLine(String line) {
    }

    @Override
    public boolean contains(String fragmentId) throws DataStoreException {
        this.throwErrorIfClosed();
        return this.fragments.containsKey(fragmentId);
    }

    @Override
    public Fragment get(String id) throws DataStoreException {
        this.throwErrorIfClosed();
        return this.fragments.get(id);
    }

    @Override
    public StreamingIterator<String> idIterator() {
        this.throwErrorIfClosed();
        return IteratorUtil.createStreamingIterator(this.fragments.keySet().iterator());
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.throwErrorIfClosed();
        return this.fragments.size();
    }
}

