/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.frg;

import org.jcvi.jillion.assembly.ca.frg.Fragment;
import org.jcvi.jillion.assembly.ca.frg.Library;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.trace.Trace;

public class DefaultFragment
implements Fragment {
    private final String id;
    private final NucleotideSequence bases;
    private final QualitySequence qualities;
    private final Range validRange;
    private final Range vectorClearRange;
    private final String comment;
    private final Library library;

    public DefaultFragment(String id, Trace trace, Range validRange, Range vectorClearRange, Library library, String comment) {
        this(id, trace.getNucleotideSequence(), trace.getQualitySequence(), validRange, vectorClearRange, library, comment);
    }

    public DefaultFragment(String id, Trace trace, Range validRange, Range vectorClearRange, Library library) {
        this(id, trace, validRange, vectorClearRange, library, null);
    }

    public DefaultFragment(String id, Trace trace, Range validRange, Library library) {
        this(id, trace, validRange, validRange, library, null);
    }

    public DefaultFragment(String id, Trace trace, Library library) {
        this(id, trace, new Range.Builder(trace.getNucleotideSequence().getLength()).build(), library);
    }

    public DefaultFragment(String id, NucleotideSequence bases, QualitySequence qualities, Range validRange, Range vectorClearRange, Library library, String comment) {
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.id = id;
        this.validRange = validRange;
        this.bases = bases;
        this.qualities = qualities;
        this.comment = comment;
        this.library = library;
        this.vectorClearRange = vectorClearRange;
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.qualities;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Range getValidRange() {
        return this.validRange;
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        return this.bases;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Library getLibrary() {
        return this.library;
    }

    @Override
    public Range getVectorClearRange() {
        return this.vectorClearRange;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultFragment)) {
            return false;
        }
        DefaultFragment other = (DefaultFragment)obj;
        return ObjectsUtil.nullSafeEquals(this.getId(), other.getId());
    }
}

