/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.frg;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.ca.frg.DefaultLibrary;
import org.jcvi.jillion.assembly.ca.frg.Distance;
import org.jcvi.jillion.assembly.ca.frg.Fragment;
import org.jcvi.jillion.assembly.ca.frg.FragmentDataStore;
import org.jcvi.jillion.assembly.ca.frg.Frg2Visitor;
import org.jcvi.jillion.assembly.ca.frg.Library;
import org.jcvi.jillion.assembly.ca.frg.MateOrientation;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

abstract class AbstractFragmentDataStore
implements Frg2Visitor,
FragmentDataStore {
    private boolean initialized;
    private boolean closed;
    private final Map<String, Library> libraries = new HashMap<String, Library>();

    AbstractFragmentDataStore() {
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void throwErrorIfClosed() {
        if (this.isClosed()) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    protected boolean isDelete(Frg2Visitor.FrgAction action) {
        return action == Frg2Visitor.FrgAction.DELETE;
    }

    protected boolean isAddOrModify(Frg2Visitor.FrgAction action) {
        return action == Frg2Visitor.FrgAction.ADD || action == Frg2Visitor.FrgAction.MODIFY;
    }

    protected void throwErrorIfAlreadyInitialized() {
        if (this.isInitialized()) {
            throw new IllegalStateException("can not add Fragments after initialization");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void visitEndOfFile() {
        this.initialized = true;
    }

    @Override
    public void visitFile() {
        this.throwErrorIfClosed();
    }

    @Override
    public StreamingIterator<Fragment> iterator() {
        this.throwErrorIfClosed();
        return new DataStoreIterator<Fragment>(this);
    }

    @Override
    public StreamingIterator<DataStoreEntry<Fragment>> entryIterator() throws DataStoreException {
        this.throwErrorIfClosed();
        StreamingIterator<DataStoreEntry<Fragment>> iter = new StreamingIterator<DataStoreEntry<Fragment>>(){
            StreamingIterator<Fragment> delegate;
            {
                this.delegate = AbstractFragmentDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            @Override
            public DataStoreEntry<Fragment> next() {
                Fragment frag = this.delegate.next();
                return new DataStoreEntry<Fragment>(frag.getId(), frag);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public void visitLibrary(Frg2Visitor.FrgAction action, String id, MateOrientation orientation, Distance distance) {
        this.throwErrorIfAlreadyInitialized();
        if (this.isAddOrModify(action)) {
            DefaultLibrary library = new DefaultLibrary(id, distance, orientation);
            this.libraries.put(id, library);
        } else if (this.isDelete(action)) {
            this.libraries.remove(id);
        }
    }

    @Override
    public boolean containsLibrary(String libraryId) throws DataStoreException {
        this.throwErrorIfClosed();
        return this.libraries.containsKey(libraryId);
    }

    @Override
    public Library getLibrary(String libraryId) throws DataStoreException {
        this.throwErrorIfClosed();
        return this.libraries.get(libraryId);
    }
}

