/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.jcvi.jillion.assembly.ca.asm.AbstractAsmContigBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmContig;
import org.jcvi.jillion.assembly.ca.asm.AsmContigBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmContigDataStore;
import org.jcvi.jillion.assembly.ca.asm.AsmContigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmFileParser;
import org.jcvi.jillion.assembly.ca.asm.AsmParser;
import org.jcvi.jillion.assembly.ca.asm.AsmScaffoldVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmUnitigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmVisitor;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class IndexedAsmFileContigDataStore
implements AsmContigDataStore {
    private final DataStore<NucleotideSequence> fullLengthSequences;
    private final Map<String, AsmVisitor.AsmVisitorCallback.AsmVisitorMemento> contigMementos;
    private final AsmParser parser;
    private volatile boolean closed = false;

    public static AsmContigDataStore create(File asmFile, DataStore<NucleotideSequence> fullLengthSequences, DataStoreFilter filter) throws IOException {
        VisitorBuilder visitorBuilder = new VisitorBuilder(filter);
        AsmParser parser = AsmFileParser.create(asmFile);
        parser.parse(visitorBuilder);
        return visitorBuilder.build(parser, fullLengthSequences);
    }

    public IndexedAsmFileContigDataStore(AsmParser parser, DataStore<NucleotideSequence> fullLengthSequences, Map<String, AsmVisitor.AsmVisitorCallback.AsmVisitorMemento> contigMementos) {
        this.parser = parser;
        this.fullLengthSequences = fullLengthSequences;
        this.contigMementos = contigMementos;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.checkNotClosed();
        return DataStoreStreamingIterator.create(this, this.contigMementos.keySet().iterator());
    }

    @Override
    public AsmContig get(String id) throws DataStoreException {
        this.checkNotClosed();
        AsmVisitor.AsmVisitorCallback.AsmVisitorMemento memento = this.contigMementos.get(id);
        if (memento == null) {
            return null;
        }
        try {
            ContigReadIdCollector visitor = new ContigReadIdCollector(id);
            this.parser.parse(visitor, memento);
            Set<String> reads = visitor.getReadsInContig();
            ValidRangeVisitor validRangeVisitor = new ValidRangeVisitor(reads);
            this.parser.parse(validRangeVisitor);
            SingleContigVisitorBuilder contigBuilder = new SingleContigVisitorBuilder(validRangeVisitor.getValidRanges());
            this.parser.parse(contigBuilder, memento);
            return contigBuilder.build();
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing asm file", e);
        }
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.checkNotClosed();
        return this.contigMementos.containsKey(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.checkNotClosed();
        return this.contigMementos.size();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<AsmContig> iterator() throws DataStoreException {
        return new DataStoreIterator<AsmContig>(this);
    }

    @Override
    public StreamingIterator<DataStoreEntry<AsmContig>> entryIterator() throws DataStoreException {
        StreamingIterator<DataStoreEntry<AsmContig>> iter = new StreamingIterator<DataStoreEntry<AsmContig>>(){
            StreamingIterator<AsmContig> delegate;
            {
                this.delegate = IndexedAsmFileContigDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            @Override
            public DataStoreEntry<AsmContig> next() {
                AsmContig trace = this.delegate.next();
                return new DataStoreEntry<AsmContig>(trace.getId(), trace);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private class SingleContigVisitorBuilder
    implements AsmVisitor {
        private final Map<String, Range> validRanges;
        private AsmContigBuilder builder;

        public SingleContigVisitorBuilder(Map<String, Range> validRanges) {
            this.validRanges = validRanges;
        }

        @Override
        public void visitLibraryStatistics(String externalId, long internalId, float meanOfDistances, float stdDev, long min, long max, List<Long> histogram) {
        }

        @Override
        public void visitRead(String externalId, long internalId, AsmVisitor.MateStatus mateStatus, boolean isSingleton, Range clearRange) {
        }

        @Override
        public void visitMatePair(String externalIdOfRead1, String externalIdOfRead2, AsmVisitor.MateStatus mateStatus) {
        }

        @Override
        public AsmUnitigVisitor visitUnitig(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, float aStat, float measureOfPolymorphism, AsmVisitor.UnitigStatus status, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads) {
            return null;
        }

        @Override
        public void visitUnitigLink(String externalUnitigId1, String externalUnitigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, boolean isPossibleChimera, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitContigLink(String externalContigId1, String externalContigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public AsmContigVisitor visitContig(final AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, boolean isDegenerate, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads, long numberOfUnitigs, long numberOfVariants) {
            return new AbstractAsmContigBuilder(externalId, consensusSequence, isDegenerate, IndexedAsmFileContigDataStore.this.fullLengthSequences, this.validRanges){

                @Override
                protected void visitContig(AsmContigBuilder builder) {
                    SingleContigVisitorBuilder.this.builder = builder;
                    callback.haltParsing();
                }
            };
        }

        @Override
        public AsmScaffoldVisitor visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, int numberOfContigPairs) {
            return null;
        }

        @Override
        public void visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, String externalContigId) {
        }

        @Override
        public void visitScaffoldLink(String externalScaffoldId1, String externalScaffoldId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        public AsmContig build() {
            if (this.builder == null) {
                throw new IllegalStateException("could not find contig in asm file");
            }
            return (AsmContig)this.builder.build();
        }
    }

    private static class ValidRangeVisitor
    implements AsmVisitor {
        private final Set<String> readsInContig;
        private final Map<String, Range> validRanges;

        public ValidRangeVisitor(Set<String> readsInContig) {
            this.readsInContig = readsInContig;
            this.validRanges = new HashMap<String, Range>(MapUtil.computeMinHashMapSizeWithoutRehashing(readsInContig.size()));
        }

        public Map<String, Range> getValidRanges() {
            return this.validRanges;
        }

        @Override
        public void visitLibraryStatistics(String externalId, long internalId, float meanOfDistances, float stdDev, long min, long max, List<Long> histogram) {
        }

        @Override
        public void visitRead(String externalId, long internalId, AsmVisitor.MateStatus mateStatus, boolean isSingleton, Range clearRange) {
            if (this.readsInContig.contains(externalId)) {
                this.validRanges.put(externalId, clearRange);
            }
        }

        @Override
        public void visitMatePair(String externalIdOfRead1, String externalIdOfRead2, AsmVisitor.MateStatus mateStatus) {
        }

        @Override
        public AsmUnitigVisitor visitUnitig(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, float aStat, float measureOfPolymorphism, AsmVisitor.UnitigStatus status, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads) {
            callback.haltParsing();
            return null;
        }

        @Override
        public void visitUnitigLink(String externalUnitigId1, String externalUnitigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, boolean isPossibleChimera, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitContigLink(String externalContigId1, String externalContigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public AsmContigVisitor visitContig(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, boolean isDegenerate, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads, long numberOfUnitigs, long numberOfVariants) {
            callback.haltParsing();
            return null;
        }

        @Override
        public AsmScaffoldVisitor visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, int numberOfContigPairs) {
            callback.haltParsing();
            return null;
        }

        @Override
        public void visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, String externalContigId) {
            callback.haltParsing();
        }

        @Override
        public void visitScaffoldLink(String externalScaffoldId1, String externalScaffoldId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }

    private static class ContigReadIdCollector
    implements AsmVisitor {
        private Set<String> readsInContig;
        private final String contigId;

        public ContigReadIdCollector(String contigId) {
            this.contigId = contigId;
        }

        @Override
        public void visitLibraryStatistics(String externalId, long internalId, float meanOfDistances, float stdDev, long min, long max, List<Long> histogram) {
        }

        @Override
        public void visitRead(String externalId, long internalId, AsmVisitor.MateStatus mateStatus, boolean isSingleton, Range clearRange) {
        }

        @Override
        public void visitMatePair(String externalIdOfRead1, String externalIdOfRead2, AsmVisitor.MateStatus mateStatus) {
        }

        @Override
        public AsmUnitigVisitor visitUnitig(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, float aStat, float measureOfPolymorphism, AsmVisitor.UnitigStatus status, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads) {
            return null;
        }

        @Override
        public void visitUnitigLink(String externalUnitigId1, String externalUnitigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, boolean isPossibleChimera, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitContigLink(String externalContigId1, String externalContigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public AsmContigVisitor visitContig(final AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, boolean isDegenerate, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads, long numberOfUnitigs, long numberOfVariants) {
            if (this.contigId.equals(externalId)) {
                this.readsInContig = new HashSet<String>((int)numberOfReads);
                return new AsmContigVisitor(){

                    @Override
                    public void visitReadLayout(char readType, String externalReadId, DirectedRange readRange, List<Integer> gapOffsets) {
                        readsInContig.add(externalReadId);
                    }

                    @Override
                    public void halted() {
                    }

                    @Override
                    public void visitEnd() {
                        callback.haltParsing();
                    }

                    @Override
                    public void visitVariance(Range range, long numberOfSpanningReads, long anchorSize, long internalAccessionId, long accessionForPhasedVariant, SortedSet<AsmContigVisitor.VariantRecord> variantRecords) {
                    }

                    @Override
                    public void visitUnitigLayout(AsmVisitor.UnitigLayoutType type, String unitigExternalId, DirectedRange unitigRange, List<Long> gapOffsets) {
                    }
                };
            }
            return null;
        }

        @Override
        public AsmScaffoldVisitor visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, int numberOfContigPairs) {
            return null;
        }

        @Override
        public void visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, String externalContigId) {
        }

        @Override
        public void visitScaffoldLink(String externalScaffoldId1, String externalScaffoldId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        public final Set<String> getReadsInContig() {
            if (this.readsInContig == null) {
                throw new IllegalStateException("contig not found");
            }
            return this.readsInContig;
        }
    }

    private static class VisitorBuilder
    implements AsmVisitor {
        private final Map<String, AsmVisitor.AsmVisitorCallback.AsmVisitorMemento> mementos = new LinkedHashMap<String, AsmVisitor.AsmVisitorCallback.AsmVisitorMemento>();
        private final DataStoreFilter filter;

        public VisitorBuilder(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public void visitLibraryStatistics(String externalId, long internalId, float meanOfDistances, float stdDev, long min, long max, List<Long> histogram) {
        }

        @Override
        public void visitRead(String externalId, long internalId, AsmVisitor.MateStatus mateStatus, boolean isSingleton, Range clearRange) {
        }

        @Override
        public void visitMatePair(String externalIdOfRead1, String externalIdOfRead2, AsmVisitor.MateStatus mateStatus) {
        }

        @Override
        public AsmUnitigVisitor visitUnitig(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, float aStat, float measureOfPolymorphism, AsmVisitor.UnitigStatus status, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads) {
            return null;
        }

        @Override
        public void visitUnitigLink(String externalUnitigId1, String externalUnitigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, boolean isPossibleChimera, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitContigLink(String externalContigId1, String externalContigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public AsmContigVisitor visitContig(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, boolean isDegenerate, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads, long numberOfUnitigs, long numberOfVariants) {
            if (this.filter.accept(externalId)) {
                if (!callback.canCreateMemento()) {
                    throw new IllegalStateException("must be able to create mementos");
                }
                this.mementos.put(externalId, callback.createMemento());
            }
            return null;
        }

        @Override
        public AsmScaffoldVisitor visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, int numberOfContigPairs) {
            return null;
        }

        @Override
        public void visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, String externalContigId) {
        }

        @Override
        public void visitScaffoldLink(String externalScaffoldId1, String externalScaffoldId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        public AsmContigDataStore build(AsmParser parser, DataStore<NucleotideSequence> fullLengthSequences) {
            return new IndexedAsmFileContigDataStore(parser, fullLengthSequences, this.mementos);
        }
    }
}

