/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.assembly.ca.asm.AbstractAsmContigBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmContig;
import org.jcvi.jillion.assembly.ca.asm.AsmContigBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmContigDataStore;
import org.jcvi.jillion.assembly.ca.asm.AsmContigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmFileParser;
import org.jcvi.jillion.assembly.ca.asm.AsmScaffoldVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmUnitigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmVisitor;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

final class DefaultAsmContigDataStore {
    public static AsmContigDataStore create(File asmFile, DataStore<NucleotideSequence> fullLengthSequences, DataStoreFilter filter) throws IOException {
        VisitorBuilder visitorBuilder = new VisitorBuilder(filter, fullLengthSequences);
        AsmFileParser.create(asmFile).parse(visitorBuilder);
        return visitorBuilder.build();
    }

    private DefaultAsmContigDataStore() {
    }

    private static class VisitorBuilder
    implements AsmVisitor {
        private final Map<String, Range> validRanges = new HashMap<String, Range>();
        private final DataStore<NucleotideSequence> fullLengthSequences;
        private final DataStoreFilter filter;
        private final Map<String, AsmContig> contigs = new LinkedHashMap<String, AsmContig>();

        public VisitorBuilder(DataStoreFilter filter, DataStore<NucleotideSequence> fullLengthSequences) {
            this.filter = filter;
            this.fullLengthSequences = fullLengthSequences;
        }

        @Override
        public void visitLibraryStatistics(String externalId, long internalId, float meanOfDistances, float stdDev, long min, long max, List<Long> histogram) {
        }

        @Override
        public void visitRead(String externalId, long internalId, AsmVisitor.MateStatus mateStatus, boolean isSingleton, Range clearRange) {
            this.validRanges.put(externalId, clearRange);
        }

        @Override
        public void visitMatePair(String externalIdOfRead1, String externalIdOfRead2, AsmVisitor.MateStatus mateStatus) {
        }

        @Override
        public AsmUnitigVisitor visitUnitig(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, float aStat, float measureOfPolymorphism, AsmVisitor.UnitigStatus status, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads) {
            return null;
        }

        @Override
        public void visitUnitigLink(String externalUnitigId1, String externalUnitigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, boolean isPossibleChimera, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitContigLink(String externalContigId1, String externalContigId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public AsmContigVisitor visitContig(AsmVisitor.AsmVisitorCallback callback, final String externalId, long internalId, boolean isDegenerate, NucleotideSequence consensusSequence, QualitySequence consensusQualities, long numberOfReads, long numberOfUnitigs, long numberOfVariants) {
            if (this.filter.accept(externalId)) {
                return new AbstractAsmContigBuilder(externalId, consensusSequence, isDegenerate, this.fullLengthSequences, this.validRanges){

                    @Override
                    protected void visitContig(AsmContigBuilder builder) {
                        contigs.put(externalId, builder.build());
                    }
                };
            }
            return null;
        }

        @Override
        public AsmScaffoldVisitor visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, int numberOfContigPairs) {
            return null;
        }

        @Override
        public void visitScaffold(AsmVisitor.AsmVisitorCallback callback, String externalId, long internalId, String externalContigId) {
        }

        @Override
        public void visitScaffoldLink(String externalScaffoldId1, String externalScaffoldId2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, AsmVisitor.OverlapStatus status, int numberOfEdges, float meanDistance, float stddev, Set<AsmVisitor.MatePairEvidence> matePairEvidence) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        public AsmContigDataStore build() {
            return DataStore.of(this.contigs, AsmContigDataStore.class);
        }
    }
}

