/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.ContigBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmAssembledRead;
import org.jcvi.jillion.assembly.ca.asm.AsmAssembledReadBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmContig;
import org.jcvi.jillion.assembly.ca.asm.AsmContigBuilder;
import org.jcvi.jillion.assembly.ca.asm.DefaultAsmAssembledRead;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.assembly.DefaultContig;
import org.jcvi.jillion.internal.assembly.util.CompactedSliceMap;

final class DefaultAsmContig
implements AsmContig {
    private final boolean isDegenerate;
    private final Contig<AsmAssembledRead> contig;

    public static AsmContigBuilder createBuilder(String id, NucleotideSequence consensus) {
        return DefaultAsmContig.createBuilder(id, consensus, false);
    }

    public static AsmContigBuilder createBuilder(String id, NucleotideSequence consensus, boolean isDegenerate) {
        return new DefaultAsmContigBuilder(id, consensus, isDegenerate);
    }

    private DefaultAsmContig(String id, NucleotideSequence consensus, Map<String, AsmAssembledRead> reads, boolean isDegenerate) {
        this.contig = new DefaultContig<AsmAssembledRead>(id, consensus, reads);
        this.isDegenerate = isDegenerate;
    }

    @Override
    public String getId() {
        return this.contig.getId();
    }

    @Override
    public long getNumberOfReads() {
        return this.contig.getNumberOfReads();
    }

    @Override
    public NucleotideSequence getConsensusSequence() {
        return this.contig.getConsensusSequence();
    }

    @Override
    public AsmAssembledRead getRead(String id) {
        return this.contig.getRead(id);
    }

    @Override
    public boolean containsRead(String readId) {
        return this.contig.containsRead(readId);
    }

    @Override
    public StreamingIterator<AsmAssembledRead> getReadIterator() {
        return this.contig.getReadIterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isDegenerate ? 1231 : 1237);
        result = 31 * result + this.contig.hashCode();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsmContig)) {
            return false;
        }
        AsmContig other = (AsmContig)obj;
        if (this.isDegenerate != other.isDegenerate()) {
            return false;
        }
        if (!this.contig.getId().equals(other.getId())) {
            return false;
        }
        if (!this.contig.getConsensusSequence().equals(other.getConsensusSequence())) {
            return false;
        }
        if (this.contig.getNumberOfReads() != other.getNumberOfReads()) {
            return false;
        }
        StreamingIterator<AsmAssembledRead> readIter = null;
        try {
            readIter = this.contig.getReadIterator();
            while (readIter.hasNext()) {
                AsmAssembledRead read = readIter.next();
                String readId = read.getId();
                if (!other.containsRead(readId)) {
                    boolean bl = false;
                    return bl;
                }
                if (read.equals(other.getRead(readId))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(readIter);
        }
        return true;
    }

    @Override
    public boolean isDegenerate() {
        return this.isDegenerate;
    }

    private static class DefaultAsmContigBuilder
    implements AsmContigBuilder {
        private static final PhredQuality DEFAULT_QUALITY = PhredQuality.valueOf(30);
        private ConsensusCaller consensusCaller = null;
        private QualitySequenceDataStore qualityDataStore = null;
        private GapQualityValueStrategy qualityValueStrategy = null;
        private final NucleotideSequence fullConsensus;
        private final NucleotideSequenceBuilder mutableConsensus;
        private String contigId;
        private final Map<String, AsmAssembledReadBuilder> asmReadBuilderMap = new LinkedHashMap<String, AsmAssembledReadBuilder>();
        boolean isDegenerate;

        DefaultAsmContigBuilder(String id, NucleotideSequence consensus, boolean isDegenerate) {
            this.contigId = id;
            this.fullConsensus = consensus;
            this.mutableConsensus = new NucleotideSequenceBuilder(this.fullConsensus);
            this.isDegenerate = isDegenerate;
        }

        @Override
        public ContigBuilder<AsmAssembledRead, AsmContig> setContigId(String contigId) {
            this.contigId = contigId;
            return this;
        }

        @Override
        public String getContigId() {
            return this.contigId;
        }

        @Override
        public int numberOfReads() {
            return this.asmReadBuilderMap.size();
        }

        @Override
        public ContigBuilder<AsmAssembledRead, AsmContig> addRead(AsmAssembledRead placedRead) {
            return this.addRead(placedRead.getId(), placedRead.getNucleotideSequence().toString(), (int)placedRead.getGappedStartOffset(), placedRead.getDirection(), placedRead.getReadInfo().getValidRange(), placedRead.getReadInfo().getUngappedFullLength(), placedRead.isRepeatSurrogate());
        }

        @Override
        public AsmContigBuilder addRead(String readId, String validBases, int offset, Direction dir, Range clearRange, int ungappedFullLength, boolean isSurrogate) {
            this.asmReadBuilderMap.put(readId, DefaultAsmAssembledRead.createBuilder(readId, validBases, offset, dir, clearRange, ungappedFullLength, isSurrogate));
            return this;
        }

        @Override
        public ContigBuilder<AsmAssembledRead, AsmContig> addAllReads(Iterable<AsmAssembledRead> reads) {
            for (AsmAssembledRead read : reads) {
                this.addRead(read);
            }
            return this;
        }

        @Override
        public Collection<? extends AssembledReadBuilder<AsmAssembledRead>> getAllAssembledReadBuilders() {
            return this.asmReadBuilderMap.values();
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> getAssembledReadBuilder(String readId) {
            return this.asmReadBuilderMap.get(readId);
        }

        @Override
        public ContigBuilder<AsmAssembledRead, AsmContig> removeRead(String readId) {
            this.asmReadBuilderMap.remove(readId);
            return this;
        }

        @Override
        public NucleotideSequenceBuilder getConsensusBuilder() {
            return this.mutableConsensus;
        }

        public AsmContigBuilder recallConsensus(ConsensusCaller consensusCaller, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy) {
            if (consensusCaller == null) {
                throw new NullPointerException("consensus caller can not be null");
            }
            if (qualityDataStore == null) {
                throw new NullPointerException("quality datastore can not be null");
            }
            this.consensusCaller = consensusCaller;
            this.qualityDataStore = qualityDataStore;
            this.qualityValueStrategy = qualityValueStrategy;
            return this;
        }

        public AsmContigBuilder recallConsensus(ConsensusCaller consensusCaller) {
            if (consensusCaller == null) {
                throw new NullPointerException("consensus caller can not be null");
            }
            this.consensusCaller = consensusCaller;
            this.qualityDataStore = null;
            this.qualityValueStrategy = null;
            return this;
        }

        public AsmContigBuilder recallConsensusNow() {
            CompactedSliceMap sliceMap;
            if (this.consensusCaller == null) {
                throw new IllegalStateException("must set consensus caller");
            }
            try {
                NucleotideSequence consensus = this.mutableConsensus.build();
                sliceMap = this.qualityDataStore == null ? CompactedSliceMap.create(this.createStreamingReadIterator(consensus), consensus, DEFAULT_QUALITY, this.qualityValueStrategy) : CompactedSliceMap.create(this.createStreamingReadIterator(consensus), consensus, this.qualityDataStore, this.qualityValueStrategy);
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("error getting quality values from datastore", e);
            }
            int i = 0;
            while ((long)i < sliceMap.getSize()) {
                Slice slice = sliceMap.getSlice(i);
                if (slice.getCoverageDepth() != 0) {
                    this.mutableConsensus.replace(i, this.consensusCaller.callConsensus(slice).getConsensus());
                }
                ++i;
            }
            return this;
        }

        private StreamingIterator<AsmAssembledRead> createStreamingReadIterator(final NucleotideSequence consensus) {
            return IteratorUtil.createStreamingIterator(new Iterator<AsmAssembledRead>(){
                Iterator<AsmAssembledReadBuilder> builderIterator;
                {
                    this.builderIterator = asmReadBuilderMap.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.builderIterator.hasNext();
                }

                @Override
                public AsmAssembledRead next() {
                    return (AsmAssembledRead)this.builderIterator.next().build(consensus);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }

        @Override
        public AsmContig build() {
            if (this.consensusCaller != null) {
                this.recallConsensusNow();
            }
            int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(this.numberOfReads());
            LinkedHashMap reads = new LinkedHashMap(capacity);
            NucleotideSequence consensus = this.mutableConsensus.build();
            for (AsmAssembledReadBuilder builder : this.asmReadBuilderMap.values()) {
                reads.put(builder.getId(), builder.build(consensus));
            }
            return new DefaultAsmContig(this.contigId, consensus, reads, this.isDegenerate);
        }

        @Override
        public void setDegenerate(boolean isDegenerate) {
            this.isDegenerate = isDegenerate;
        }

        @Override
        public boolean isDegenerate() {
            return this.isDegenerate;
        }
    }
}

