/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.util.List;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.assembly.ca.asm.AsmAssembledRead;
import org.jcvi.jillion.assembly.ca.asm.AsmAssembledReadBuilder;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.internal.assembly.DefaultAssembledRead;

final class DefaultAsmAssembledRead
implements AsmAssembledRead {
    private final boolean isSurrogate;
    private final AssembledRead placedRead;

    public static AsmAssembledReadBuilder createBuilder(String readId, String validBases, int offset, Direction dir, Range clearRange, int ungappedFullLength, boolean isSurrogate) {
        return new Builder(readId, validBases, offset, dir, clearRange, ungappedFullLength, isSurrogate);
    }

    private DefaultAsmAssembledRead(AssembledRead placedRead, boolean isSurrogate) {
        this.placedRead = placedRead;
        this.isSurrogate = isSurrogate;
    }

    @Override
    public ReadInfo getReadInfo() {
        return this.placedRead.getReadInfo();
    }

    @Override
    public Direction getDirection() {
        return this.placedRead.getDirection();
    }

    @Override
    public long toGappedValidRangeOffset(long referenceOffset) {
        return this.placedRead.toGappedValidRangeOffset(referenceOffset);
    }

    @Override
    public long toReferenceOffset(long gappedValidRangeOffset) {
        return this.placedRead.toReferenceOffset(gappedValidRangeOffset);
    }

    @Override
    public String getId() {
        return this.placedRead.getId();
    }

    @Override
    public ReferenceMappedNucleotideSequence getNucleotideSequence() {
        return this.placedRead.getNucleotideSequence();
    }

    @Override
    public long getGappedLength() {
        return this.placedRead.getGappedLength();
    }

    @Override
    public long getGappedStartOffset() {
        return this.placedRead.getGappedStartOffset();
    }

    @Override
    public long getGappedEndOffset() {
        return this.placedRead.getGappedEndOffset();
    }

    @Override
    public Range asRange() {
        return this.placedRead.asRange();
    }

    @Override
    public Range getGappedContigRange() {
        return this.placedRead.getGappedContigRange();
    }

    @Override
    public boolean isRepeatSurrogate() {
        return this.isSurrogate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isSurrogate ? 1231 : 1237);
        result = 31 * result + (this.placedRead == null ? 0 : this.placedRead.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultAsmAssembledRead)) {
            return false;
        }
        DefaultAsmAssembledRead other = (DefaultAsmAssembledRead)obj;
        if (this.isSurrogate != other.isSurrogate) {
            return false;
        }
        return !(this.placedRead == null ? other.placedRead != null : !this.placedRead.equals(other.placedRead));
    }

    protected static final class IllegalReAbacus
    extends IllegalArgumentException {
        private static final long serialVersionUID = -8272559886165301526L;

        public IllegalReAbacus(List<Nucleotide> oldUngappedBasecalls, List<Nucleotide> newUngappedBasecalls) {
            super(String.format("reAbacusing must retain same ungapped basecalls! '%s' vs '%s'", new NucleotideSequenceBuilder(oldUngappedBasecalls).toString(), new NucleotideSequenceBuilder(newUngappedBasecalls).toString()));
        }
    }

    private static class Builder
    implements AsmAssembledReadBuilder {
        private boolean isSurrogate = false;
        private final AssembledReadBuilder<AssembledRead> delegateBuilder;

        public Builder(String readId, String validBases, int offset, Direction dir, Range clearRange, int ungappedFullLength, boolean isSurrogate) {
            this.delegateBuilder = DefaultAssembledRead.createBuilder(readId, validBases, offset, dir, clearRange, ungappedFullLength);
            this.isSurrogate = isSurrogate;
        }

        private Builder(Builder copy) {
            this.delegateBuilder = copy.delegateBuilder.copy();
            this.isSurrogate = copy.isSurrogate;
        }

        public AsmAssembledReadBuilder trim(Range trimRange) {
            this.delegateBuilder.trim(trimRange);
            return this;
        }

        public AsmAssembledReadBuilder copy() {
            return new Builder(this);
        }

        @Override
        public long getBegin() {
            return this.delegateBuilder.getBegin();
        }

        @Override
        public String getId() {
            return this.delegateBuilder.getId();
        }

        public Builder setStartOffset(int newOffset) {
            this.delegateBuilder.setStartOffset(newOffset);
            return this;
        }

        public Builder shift(int numberOfBases) {
            this.delegateBuilder.shift(numberOfBases);
            return this;
        }

        @Override
        public Range getClearRange() {
            return this.delegateBuilder.getClearRange();
        }

        @Override
        public Direction getDirection() {
            return this.delegateBuilder.getDirection();
        }

        @Override
        public int getUngappedFullLength() {
            return this.delegateBuilder.getUngappedFullLength();
        }

        @Override
        public DefaultAsmAssembledRead build(NucleotideSequence consensus) {
            return new DefaultAsmAssembledRead(this.delegateBuilder.build(consensus), this.isSurrogate);
        }

        public Builder reAbacus(Range gappedValidRangeToChange, NucleotideSequence newBasecalls) {
            this.delegateBuilder.reAbacus(gappedValidRangeToChange, newBasecalls);
            return this;
        }

        @Override
        public synchronized long getLength() {
            return this.delegateBuilder.getLength();
        }

        @Override
        public long getEnd() {
            return this.delegateBuilder.getEnd();
        }

        @Override
        public Range asRange() {
            return this.delegateBuilder.asRange();
        }

        @Override
        public synchronized NucleotideSequence getCurrentNucleotideSequence() {
            return this.delegateBuilder.getCurrentNucleotideSequence();
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> append(Nucleotide base) {
            this.delegateBuilder.append(base);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> append(Iterable<Nucleotide> sequence) {
            this.delegateBuilder.append(sequence);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> append(String sequence) {
            this.delegateBuilder.append(sequence);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> insert(int offset, String sequence) {
            this.delegateBuilder.insert(offset, sequence);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> replace(int offset, Nucleotide replacement) {
            this.delegateBuilder.replace(offset, replacement);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> delete(Range range) {
            this.delegateBuilder.delete(range);
            return this;
        }

        @Override
        public int getNumGaps() {
            return this.delegateBuilder.getNumGaps();
        }

        @Override
        public int getNumNs() {
            return this.delegateBuilder.getNumNs();
        }

        @Override
        public int getNumAmbiguities() {
            return this.delegateBuilder.getNumAmbiguities();
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> prepend(String sequence) {
            this.delegateBuilder.prepend(sequence);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> insert(int offset, Iterable<Nucleotide> sequence) {
            this.delegateBuilder.insert(offset, sequence);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> insert(int offset, Nucleotide base) {
            this.delegateBuilder.insert(offset, base);
            return this;
        }

        @Override
        public AssembledReadBuilder<AsmAssembledRead> prepend(Iterable<Nucleotide> sequence) {
            this.delegateBuilder.prepend(sequence);
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.delegateBuilder == null ? 0 : this.delegateBuilder.hashCode());
            result = 31 * result + (this.isSurrogate ? 1 : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.delegateBuilder == null ? other.delegateBuilder != null : !this.delegateBuilder.equals(other.delegateBuilder)) {
                return false;
            }
            return this.isSurrogate == other.isSurrogate;
        }

        @Override
        public boolean isRepeatSurrogate() {
            return this.isSurrogate;
        }

        @Override
        public void setRepeatSurrogate(boolean isRepeatSurrogate) {
            this.isSurrogate = isRepeatSurrogate;
        }
    }
}

