/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.assembly.ca.asm.AsmContigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmScaffoldVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmUnitigVisitor;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public interface AsmVisitor {
    public void visitLibraryStatistics(String var1, long var2, float var4, float var5, long var6, long var8, List<Long> var10);

    public void visitRead(String var1, long var2, MateStatus var4, boolean var5, Range var6);

    public void visitMatePair(String var1, String var2, MateStatus var3);

    public AsmUnitigVisitor visitUnitig(AsmVisitorCallback var1, String var2, long var3, float var5, float var6, UnitigStatus var7, NucleotideSequence var8, QualitySequence var9, long var10);

    public void visitUnitigLink(String var1, String var2, LinkOrientation var3, OverlapType var4, OverlapStatus var5, boolean var6, int var7, float var8, float var9, Set<MatePairEvidence> var10);

    public void visitContigLink(String var1, String var2, LinkOrientation var3, OverlapType var4, OverlapStatus var5, int var6, float var7, float var8, Set<MatePairEvidence> var9);

    public AsmContigVisitor visitContig(AsmVisitorCallback var1, String var2, long var3, boolean var5, NucleotideSequence var6, QualitySequence var7, long var8, long var10, long var12);

    public AsmScaffoldVisitor visitScaffold(AsmVisitorCallback var1, String var2, long var3, int var5);

    public void visitScaffold(AsmVisitorCallback var1, String var2, long var3, String var5);

    public void visitScaffoldLink(String var1, String var2, LinkOrientation var3, OverlapType var4, OverlapStatus var5, int var6, float var7, float var8, Set<MatePairEvidence> var9);

    public void visitEnd();

    public void halted();

    public static enum UnitigLayoutType {
        UNIQUE('U'),
        REPEAT_ROCK('R'),
        REPEAT_STONE('S'),
        REPEAT_PEBBLE('P'),
        SINGLE_READ('s');

        private final char code;
        private static final Map<Character, UnitigLayoutType> MAP;

        private UnitigLayoutType(char code) {
            this.code = code;
        }

        public static UnitigLayoutType parseUnitigLayoutType(String typeCode) {
            return UnitigLayoutType.parseUnitigLayoutType(typeCode.charAt(0));
        }

        public static UnitigLayoutType parseUnitigLayoutType(char typeCode) {
            Character valueOf = Character.valueOf(typeCode);
            if (!MAP.containsKey(valueOf)) {
                throw new IllegalArgumentException("invalid unitg layout type : " + typeCode);
            }
            return MAP.get(valueOf);
        }

        public char getCode() {
            return this.code;
        }

        static {
            MAP = new HashMap<Character, UnitigLayoutType>();
            for (UnitigLayoutType status : UnitigLayoutType.values()) {
                MAP.put(Character.valueOf(status.code), status);
            }
        }
    }

    public static interface MatePairEvidence {
        public String getRead1();

        public String getRead2();
    }

    public static enum OverlapStatus {
        IN_ASSEMBLY('A'),
        POLYMORPHISM('P'),
        BAD('B'),
        CHIMERA('C'),
        UNKNOWN('U');

        private final char code;
        private static final Map<Character, OverlapStatus> MAP;

        private OverlapStatus(char code) {
            this.code = code;
        }

        public static OverlapStatus parseOverlapStatus(String statusCode) {
            return OverlapStatus.parseOverlapStatus(statusCode.charAt(0));
        }

        public static OverlapStatus parseOverlapStatus(char statusCode) {
            Character valueOf = Character.valueOf(statusCode);
            if (!MAP.containsKey(valueOf)) {
                throw new IllegalArgumentException("invalid overlap status code :" + statusCode);
            }
            return MAP.get(valueOf);
        }

        public char getCode() {
            return this.code;
        }

        static {
            MAP = new HashMap<Character, OverlapStatus>();
            for (OverlapStatus status : OverlapStatus.values()) {
                MAP.put(Character.valueOf(status.code), status);
            }
        }
    }

    public static enum OverlapType {
        NO_OVERLAP('N'){

            @Override
            int getExpectedNumberOfMatePairEvidenceRecords(int numberOfContributingEdges) {
                return numberOfContributingEdges;
            }
        }
        ,
        REGULAR('O'),
        TANDEM('T'),
        CONTAINMENT_1_BY_2('C'),
        CONTAINMENT_2_BY_1('I');

        private final char code;
        private static final Map<Character, OverlapType> MAP;

        private OverlapType(char code) {
            this.code = code;
        }

        public static OverlapType parseOverlapType(String statusCode) {
            return OverlapType.parseOverlapType(statusCode.charAt(0));
        }

        public static OverlapType parseOverlapType(char statusCode) {
            Character valueOf = Character.valueOf(statusCode);
            if (!MAP.containsKey(valueOf)) {
                throw new IllegalArgumentException("invalid overlap code :" + statusCode);
            }
            return MAP.get(valueOf);
        }

        int getExpectedNumberOfMatePairEvidenceRecords(int numberOfContributingEdges) {
            return numberOfContributingEdges - 1;
        }

        public char getCode() {
            return this.code;
        }

        static {
            MAP = new HashMap<Character, OverlapType>();
            for (OverlapType status : OverlapType.values()) {
                MAP.put(Character.valueOf(status.code), status);
            }
        }
    }

    public static enum LinkOrientation {
        NORMAL('N'),
        ANTI_NORMAL('A'),
        OUTIE('O'),
        INNIE('I');

        private final char code;
        private static final Map<Character, LinkOrientation> MAP;

        private LinkOrientation(char code) {
            this.code = code;
        }

        public static LinkOrientation parseLinkOrientation(String statusCode) {
            return LinkOrientation.parseLinkOrientation(statusCode.charAt(0));
        }

        public static LinkOrientation parseLinkOrientation(char statusCode) {
            Character valueOf = Character.valueOf(statusCode);
            if (!MAP.containsKey(valueOf)) {
                throw new IllegalArgumentException("invalid link orientation code :" + statusCode);
            }
            return MAP.get(Character.valueOf(statusCode));
        }

        public char getCode() {
            return this.code;
        }

        static {
            MAP = new HashMap<Character, LinkOrientation>();
            for (LinkOrientation status : LinkOrientation.values()) {
                MAP.put(Character.valueOf(status.code), status);
            }
        }
    }

    public static enum UnitigStatus {
        UNIQUE('U'),
        REPEAT_SURROGATE('S'),
        REPEAT_DEGENERATE('N'),
        CHIMER('C'),
        UNRESOVLED('X');

        private final char code;
        private static final Map<Character, UnitigStatus> MAP;

        private UnitigStatus(char code) {
            this.code = code;
        }

        public static UnitigStatus parseUnitigStatus(String statusCode) {
            return UnitigStatus.parseUnitigStatus(statusCode.charAt(0));
        }

        public static UnitigStatus parseUnitigStatus(char statusCode) {
            Character valueOf = Character.valueOf(statusCode);
            if (!MAP.containsKey(valueOf)) {
                throw new IllegalArgumentException("invalid unitig status code :" + statusCode);
            }
            return MAP.get(valueOf);
        }

        public char getCode() {
            return this.code;
        }

        static {
            MAP = new HashMap<Character, UnitigStatus>();
            for (UnitigStatus status : UnitigStatus.values()) {
                MAP.put(Character.valueOf(status.code), status);
            }
        }
    }

    public static enum MateStatus {
        UNASSIGNED('Z'),
        GOOD('G'),
        BAD_SHORT('C'),
        BAD_LONG('L'),
        SAME_ORIENTATION('S'),
        OUTTIE_ORIENTATION('O'),
        NO_MATE('N'),
        BOTH_SINGLETON('H'),
        SINGLETON_MATE('A'),
        BOTH_DEGENERATE('D'),
        DEGENERATE('E'),
        BOTH_SURROGATE('U'),
        SURROGATE('R'),
        DIFFERENT_SCAFFOLD('F'),
        DEPRECATED_BAD('B');

        private final char code;
        private static final Map<Character, MateStatus> MAP;

        private MateStatus(char code) {
            this.code = code;
        }

        public static MateStatus parseMateStatus(String statusCode) {
            return MateStatus.parseMateStatus(statusCode.charAt(0));
        }

        public static MateStatus parseMateStatus(char statusCode) {
            Character valueOf = Character.valueOf(statusCode);
            if (!MAP.containsKey(valueOf)) {
                throw new IllegalArgumentException("invalid mate status code :" + statusCode);
            }
            return MAP.get(valueOf);
        }

        public char getCode() {
            return this.code;
        }

        static {
            MAP = new HashMap<Character, MateStatus>();
            for (MateStatus status : MateStatus.values()) {
                MAP.put(Character.valueOf(status.code), status);
            }
        }
    }

    public static interface AsmVisitorCallback {
        public boolean canCreateMemento();

        public AsmVisitorMemento createMemento();

        public void haltParsing();

        public static interface AsmVisitorMemento {
        }
    }
}

