/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.ca.asm.AsmContigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmParser;
import org.jcvi.jillion.assembly.ca.asm.AsmScaffoldVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmUnitigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmVisitor;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;
import org.jcvi.jillion.internal.core.util.JillionUtil;

public abstract class AsmFileParser
implements AsmParser {
    private static final String SRC = "src";
    private static final Pattern SPLIT_ON_SLASH = Pattern.compile("/");
    private static final String END_MESSAGE = "}";
    private static final Pattern LENGTH_PATTERN = Pattern.compile("len:(\\d+)");
    private static final Pattern NUM_READS_PATTERN = Pattern.compile("n\\S\\S:(\\d+)");

    private AsmFileParser() {
    }

    public static AsmParser create(File asmFile) {
        return new FileBasedAsmFileParser(asmFile);
    }

    protected void parseAsm(ParserState parserState, AsmVisitor visitor) throws IOException {
        AsmMessageHandler.parse(parserState, visitor);
    }

    static int parseLength(ParserState parserState) throws IOException {
        String line = parserState.getNextLine();
        return AsmFileParser.parseLength(line);
    }

    private static int parseLength(String line) throws IOException {
        Matcher matcher = LENGTH_PATTERN.matcher(line);
        if (!matcher.find()) {
            throw new IOException("error reading length:" + line);
        }
        return Integer.parseInt(matcher.group(1));
    }

    private static long parseNumberOfReads(ParserState parserState) throws IOException {
        String line = parserState.getNextLine();
        Matcher matcher = NUM_READS_PATTERN.matcher(line);
        if (!matcher.find()) {
            throw new IOException("error parsing unitig number of reads : " + line);
        }
        return Long.parseLong(matcher.group(1));
    }

    private static void skipReservedSource(ParserState parserState) throws IOException {
        String line = "";
        while (!".\n".equals(line)) {
            line = parserState.getNextLine();
        }
    }

    private static void parseEndOfMessage(ParserState parserState, String messageCode) throws IOException {
        String endLine = parserState.getNextLine();
        if (!endLine.startsWith(END_MESSAGE)) {
            throw new IOException("invalid asm file: invalid " + messageCode + " end tag : " + endLine);
        }
    }

    private static void skipCurrentBlock(ParserState parserState) throws IOException {
        String line = null;
        while ((line = parserState.getNextLine()) != null && !line.startsWith(END_MESSAGE)) {
        }
    }

    private static String skipSrcBlock(ParserState parserState, String line) throws IOException {
        if (line.startsWith(SRC)) {
            AsmFileParser.skipReservedSource(parserState);
            return parserState.getNextLine();
        }
        return line;
    }

    private static class FileBasedAsmFileParser
    extends AsmFileParser {
        private final File asmFile;

        public FileBasedAsmFileParser(File asmFile) {
            this.asmFile = asmFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(AsmVisitor visitor) throws IOException {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(this.asmFile));
                ParserState parserState = new ParserState((InputStream)in, 0L){

                    @Override
                    public CallBack createCallback() {
                        return new MementoedCallback(this.keepParsing, this.markedOffset);
                    }
                };
                this.parseAsm(parserState, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(AsmVisitor visitor, AsmVisitor.AsmVisitorCallback.AsmVisitorMemento memento) throws IOException {
            if (!(memento instanceof OffsetMemento)) {
                throw new IllegalArgumentException("unknown memento type " + memento + " must use instance created by this parser");
            }
            long offset = ((OffsetMemento)memento).getOffset();
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new RandomAccessFileInputStream(this.asmFile, offset));
                ParserState parserState = new ParserState((InputStream)in, offset){

                    @Override
                    public CallBack createCallback() {
                        return new MementoedCallback(this.keepParsing, this.markedOffset);
                    }
                };
                this.parseAsm(parserState, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        @Override
        public boolean canParse() {
            return true;
        }
    }

    private static class OffsetMemento
    implements AsmVisitor.AsmVisitorCallback.AsmVisitorMemento {
        private final long offset;

        public OffsetMemento(long offset) {
            this.offset = offset;
        }

        protected final long getOffset() {
            return this.offset;
        }
    }

    private static class MementoedCallback
    extends CallBack {
        private final long offset;

        public MementoedCallback(AtomicBoolean keepParsing, long offset) {
            super(keepParsing);
            this.offset = offset;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public AsmVisitor.AsmVisitorCallback.AsmVisitorMemento createMemento() {
            return new OffsetMemento(this.offset);
        }
    }

    private static abstract class CallBack
    implements AsmVisitor.AsmVisitorCallback {
        private final AtomicBoolean keepParsing;

        public CallBack(AtomicBoolean keepParsing) {
            this.keepParsing = keepParsing;
        }

        @Override
        public void haltParsing() {
            this.keepParsing.set(false);
        }
    }

    private static class VariantRecordImpl
    implements AsmContigVisitor.VariantRecord {
        private final List<Long> readIds;
        private final NucleotideSequence sequence;
        private final int weight;

        public VariantRecordImpl(List<Long> readIds, NucleotideSequence sequence, int weight) {
            this.readIds = Collections.unmodifiableList(readIds);
            this.sequence = sequence;
            this.weight = weight;
        }

        @Override
        public List<Long> getContributingReadIIDs() {
            return this.readIds;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public NucleotideSequence getVariantSequence() {
            return this.sequence;
        }

        @Override
        public int compareTo(AsmContigVisitor.VariantRecord o) {
            return JillionUtil.compare(this.weight, o.getWeight());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.readIds == null ? 0 : this.readIds.hashCode());
            result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
            result = 31 * result + this.weight;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof VariantRecordImpl)) {
                return false;
            }
            VariantRecordImpl other = (VariantRecordImpl)obj;
            if (this.readIds == null ? other.readIds != null : !this.readIds.equals(other.readIds)) {
                return false;
            }
            if (this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence)) {
                return false;
            }
            return this.weight == other.weight;
        }

        public String toString() {
            return "VariantRecordImpl [readIds=" + this.readIds + ", sequence=" + this.sequence + ", weight=" + this.weight + "]";
        }
    }

    private static final class MatePairEvidenceImpl
    implements AsmVisitor.MatePairEvidence {
        private final String read1;
        private final String read2;

        private MatePairEvidenceImpl(String read1, String read2) {
            this.read1 = read1;
            this.read2 = read2;
        }

        @Override
        public String getRead1() {
            return this.read1;
        }

        @Override
        public String getRead2() {
            return this.read2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.read1 == null ? 0 : this.read1.hashCode());
            result = 31 * result + (this.read2 == null ? 0 : this.read2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MatePairEvidenceImpl)) {
                return false;
            }
            MatePairEvidenceImpl other = (MatePairEvidenceImpl)obj;
            if (this.read1 == null ? other.read1 != null : !this.read1.equals(other.read1)) {
                return false;
            }
            return !(this.read2 == null ? other.read2 != null : !this.read2.equals(other.read2));
        }

        public String toString() {
            return "MatePairEvidenceImpl [read1=" + this.read1 + ", read2=" + this.read2 + "]";
        }
    }

    private static final class IdTuple {
        private final String externalId;
        private final long internalId;

        private IdTuple(String externalId, long internalId) {
            this.externalId = externalId;
            this.internalId = internalId;
        }
    }

    private static enum ReadMapping {
        INSTANCE("MPS");

        private final String messageCode;
        private final Pattern typePattern = Pattern.compile("typ:(\\S)");
        private final Pattern readIdPattern = Pattern.compile("mid:(\\S+)");
        private final Pattern rangePattern = Pattern.compile("pos:(\\d+,\\d+)");
        private final Pattern numOffsetsPattern = Pattern.compile("dln:(\\d+)");

        private ReadMapping(String code) {
            this.messageCode = code;
        }

        final boolean canHandle(String messageCode) {
            return this.messageCode.equals(messageCode);
        }

        public void handleReadLayout(ParserState parserState, AsmUnitigVisitor visitor) throws IOException {
            if (visitor == null) {
                AsmFileParser.skipCurrentBlock(parserState);
            } else {
                char type = this.parseReadType(parserState);
                String readId = this.parseReadId(parserState);
                String nextLine = parserState.getNextLine();
                if (nextLine.startsWith(AsmFileParser.SRC)) {
                    AsmFileParser.skipReservedSource(parserState);
                    nextLine = parserState.getNextLine();
                }
                DirectedRange directedRange = this.parseDirectedRange(nextLine);
                List<Integer> gapOffsets = this.parseGapOffsets(parserState);
                AsmFileParser.parseEndOfMessage(parserState, this.messageCode);
                visitor.visitReadLayout(type, readId, directedRange, gapOffsets);
            }
        }

        public void handleReadLayout(ParserState parserState, AsmContigVisitor visitor) throws IOException {
            if (visitor == null) {
                AsmFileParser.skipCurrentBlock(parserState);
            } else {
                char type = this.parseReadType(parserState);
                String readId = this.parseReadId(parserState);
                String nextLine = parserState.getNextLine();
                if (nextLine.startsWith(AsmFileParser.SRC)) {
                    AsmFileParser.skipReservedSource(parserState);
                    nextLine = parserState.getNextLine();
                }
                DirectedRange directedRange = this.parseDirectedRange(nextLine);
                List<Integer> gapOffsets = this.parseGapOffsets(parserState);
                AsmFileParser.parseEndOfMessage(parserState, this.messageCode);
                visitor.visitReadLayout(type, readId, directedRange, gapOffsets);
            }
        }

        private DirectedRange parseDirectedRange(String line) throws IOException {
            Matcher matcher = this.rangePattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading read-to-unitig placed range:" + line);
            }
            return DirectedRange.parse(matcher.group(1));
        }

        private List<Integer> parseGapOffsets(ParserState parserState) throws IOException {
            String lengthLine = parserState.getNextLine();
            Matcher matcher = this.numOffsetsPattern.matcher(lengthLine);
            if (!matcher.find()) {
                throw new IOException("error reading read-to-unitig delta encoding length:" + lengthLine);
            }
            int expectedNumberOfOffsets = Integer.parseInt(matcher.group(1));
            String beginDeltaEncodingLine = parserState.getNextLine();
            if (!beginDeltaEncodingLine.startsWith("del:")) {
                throw new IOException("error reading read-to-unitig delta encoding:" + beginDeltaEncodingLine);
            }
            ArrayList<Integer> offsets = new ArrayList<Integer>(expectedNumberOfOffsets);
            while (offsets.size() < expectedNumberOfOffsets) {
                String offsetLine = parserState.getNextLine();
                Scanner scanner = new Scanner(offsetLine);
                if (!scanner.hasNextInt()) {
                    throw new IOException("error reading read-to-unitig delta encoding not enough values :" + offsetLine);
                }
                while (scanner.hasNextInt()) {
                    offsets.add(scanner.nextInt());
                }
            }
            return offsets;
        }

        private String parseReadId(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.readIdPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading read-to-unitig read id:" + line);
            }
            return matcher.group(1);
        }

        private char parseReadType(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.typePattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading read-to-unitig mapping type:" + line);
            }
            return matcher.group(1).charAt(0);
        }
    }

    private static enum ContigVariant {
        INSTANCE("VAR");

        private final String messageCode;
        final Pattern positionPattern = Pattern.compile("pos:(\\d+,\\d+)");
        final Pattern anchorPattern = Pattern.compile("anc:(\\d+)");
        final Pattern variantIdPattern = Pattern.compile("vid:(\\d+)");
        final Pattern phasePattern = Pattern.compile("pid:(\\S+)");

        private ContigVariant(String code) {
            this.messageCode = code;
        }

        final boolean canHandle(String messageCode) {
            return this.messageCode.equals(messageCode);
        }

        protected void handle(ParserState parserState, AsmContigVisitor contigVisitor) throws IOException {
            Range position = this.parseVariantPosition(parserState);
            long numberOfReads = AsmFileParser.parseNumberOfReads(parserState);
            if (numberOfReads > Integer.MAX_VALUE) {
                throw new NumberFormatException("too many reads in variant must be < Integer.MAX_VALUE");
            }
            long numberOfVariants = this.parseNumberOfVariants(parserState);
            if (numberOfVariants > Integer.MAX_VALUE) {
                throw new NumberFormatException("too many variants must be < Integer.MAX_VALUE");
            }
            long anchorSize = this.parseAnchorSize(parserState);
            AsmFileParser.parseLength(parserState);
            long variantId = this.parseVariantId(parserState);
            long phasedVariantId = this.parsePhasedVariantId(parserState);
            String[] contributingReadCountString = SPLIT_ON_SLASH.split(this.parseContributingReadcountString(parserState));
            String[] weightString = SPLIT_ON_SLASH.split(this.parseWeightString(parserState));
            String[] sequencesString = SPLIT_ON_SLASH.split(this.parseSequencesString(parserState));
            String supportingReadIds = this.parseSupportingReadsString(parserState);
            ArrayList<Long> readIds = new ArrayList<Long>((int)numberOfReads);
            for (String id : SPLIT_ON_SLASH.split(supportingReadIds)) {
                readIds.add(Long.parseLong(id.trim()));
            }
            AsmFileParser.parseEndOfMessage(parserState, this.messageCode);
            TreeSet<AsmContigVisitor.VariantRecord> variantRecords = new TreeSet<AsmContigVisitor.VariantRecord>();
            int readCounter = 0;
            int numberOfVariantsAsInt = (int)numberOfVariants;
            for (int i = 0; i < numberOfVariantsAsInt; ++i) {
                int numContributingReads = Integer.parseInt(contributingReadCountString[i].trim());
                int weight = Integer.parseInt(weightString[i].trim());
                NucleotideSequence seq = new NucleotideSequenceBuilder(sequencesString[i]).build();
                List<Long> reads = readIds.subList(readCounter, readCounter + numContributingReads);
                variantRecords.add(new VariantRecordImpl(reads, seq, weight));
                readCounter += numContributingReads;
            }
            contigVisitor.visitVariance(position, numberOfReads, anchorSize, variantId, phasedVariantId, variantRecords);
        }

        private String parseContributingReadcountString(ParserState parserState) throws IOException {
            return this.parseVariantBlock(parserState, "nra:");
        }

        private String parseWeightString(ParserState parserState) throws IOException {
            return this.parseVariantBlock(parserState, "wgt:");
        }

        private String parseSequencesString(ParserState parserState) throws IOException {
            return this.parseVariantBlock(parserState, "seq:");
        }

        private String parseSupportingReadsString(ParserState parserState) throws IOException {
            return this.parseVariantBlock(parserState, "rid:");
        }

        private String parseVariantBlock(ParserState parserState, String expectedBlockStart) throws IOException {
            String line = parserState.getNextLine();
            if (!line.startsWith(expectedBlockStart)) {
                throw new IOException("invalid start of variants block section : " + line);
            }
            String value = parserState.getNextLine();
            String endBlock = parserState.getNextLine();
            if (!endBlock.startsWith(".")) {
                throw new IOException("invalid end of variant block section : " + endBlock);
            }
            return value;
        }

        private long parseNumberOfVariants(ParserState parserState) throws IOException {
            return AsmFileParser.parseNumberOfReads(parserState);
        }

        private Range parseVariantPosition(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.positionPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading variant record position:" + line);
            }
            return Range.parseRange(matcher.group(1), Range.CoordinateSystem.SPACE_BASED);
        }

        private long parseAnchorSize(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.anchorPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading variant anchor size:" + line);
            }
            return Long.parseLong(matcher.group(1));
        }

        private long parseVariantId(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.variantIdPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading variant id" + line);
            }
            return Long.parseLong(matcher.group(1));
        }

        private long parsePhasedVariantId(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.phasePattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading variant id" + line);
            }
            return Long.parseLong(matcher.group(1));
        }
    }

    private static enum ContigUnitigMapping {
        INSTANCE("UPS");

        private final String messageCode;
        private final Pattern typePattern = Pattern.compile("typ:(\\S)");
        private final Pattern idPattern = Pattern.compile("lid:(\\S+)");
        private final Pattern rangePattern = Pattern.compile("pos:(\\d+,\\d+)");
        private final Pattern numOffsetsPattern = Pattern.compile("dln:(\\d+)");

        private ContigUnitigMapping(String code) {
            this.messageCode = code;
        }

        final boolean canHandle(String messageCode) {
            return this.messageCode.equals(messageCode);
        }

        protected void handle(ParserState parserState, AsmContigVisitor visitor) throws IOException {
            AsmVisitor.UnitigLayoutType type = this.parseUnitigLayoutType(parserState);
            String readId = this.parseReadId(parserState);
            String nextLine = parserState.getNextLine();
            if (nextLine.startsWith(AsmFileParser.SRC)) {
                AsmFileParser.skipReservedSource(parserState);
                nextLine = parserState.getNextLine();
            }
            DirectedRange directedRange = this.parseDirectedRange(nextLine);
            List<Long> gapOffsets = this.parseGapOffsets(parserState);
            AsmFileParser.parseEndOfMessage(parserState, this.messageCode);
            visitor.visitUnitigLayout(type, readId, directedRange, gapOffsets);
        }

        private DirectedRange parseDirectedRange(String line) throws IOException {
            Matcher matcher = this.rangePattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading read-to-unitig placed range:" + line);
            }
            return DirectedRange.parse(matcher.group(1));
        }

        private List<Long> parseGapOffsets(ParserState parserState) throws IOException {
            String lengthLine = parserState.getNextLine();
            Matcher matcher = this.numOffsetsPattern.matcher(lengthLine);
            if (!matcher.find()) {
                throw new IOException("error reading read-to-unitig delta encoding length:" + lengthLine);
            }
            int expectedNumberOfOffsets = Integer.parseInt(matcher.group(1));
            String beginDeltaEncodingLine = parserState.getNextLine();
            if (!beginDeltaEncodingLine.startsWith("del:")) {
                throw new IOException("error reading read-to-unitig delta encoding:" + beginDeltaEncodingLine);
            }
            ArrayList<Long> offsets = new ArrayList<Long>(expectedNumberOfOffsets);
            while (offsets.size() < expectedNumberOfOffsets) {
                String offsetLine = parserState.getNextLine();
                Scanner scanner = new Scanner(offsetLine);
                if (!scanner.hasNextLong()) {
                    throw new IOException("error reading read-to-unitig delta encoding not enough values :" + offsetLine);
                }
                while (scanner.hasNextLong()) {
                    offsets.add(scanner.nextLong());
                }
            }
            return offsets;
        }

        private String parseReadId(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.idPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading read-to-unitig read id:" + line);
            }
            return matcher.group(1);
        }

        private AsmVisitor.UnitigLayoutType parseUnitigLayoutType(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.typePattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading unitig-to-contig mapping type:" + line);
            }
            return AsmVisitor.UnitigLayoutType.parseUnitigLayoutType(matcher.group(1));
        }
    }

    static enum AsmMessageHandler {
        MODIFIED_DISTANCE_MESSAGE("MDI"){
            private final Pattern refIdPattern = Pattern.compile("ref:\\((\\S+),(\\d+)\\)");
            private final Pattern minPattern = Pattern.compile("min:(-?\\d+)");
            private final Pattern maxPattern = Pattern.compile("max:(\\d+)");
            private final Pattern histogramBucketPattern = Pattern.compile("buc:(\\d+)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                IdTuple idTuple = this.parseIds(parserState, visitor, this.refIdPattern);
                float mean = this.parseMean(parserState, visitor);
                float stdDev = this.parseStdDev(parserState, visitor);
                long min = this.parseMin(parserState, visitor);
                long max = this.parseMax(parserState, visitor);
                List<Long> histogram = this.parseHistogram(parserState, visitor);
                AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                visitor.visitLibraryStatistics(idTuple.externalId, idTuple.internalId, mean, stdDev, min, max, histogram);
            }

            private float parseStdDev(ParserState parserState, AsmVisitor visitor) throws IOException {
                String stdDevLine = parserState.getNextLine();
                Matcher stdDevMatcher = STD_DEV_PATTERN.matcher(stdDevLine);
                if (!stdDevMatcher.find()) {
                    throw new IOException("invalid asm file: could not parse MDI std dev of distances: " + stdDevLine);
                }
                return Float.parseFloat(stdDevMatcher.group(1));
            }

            private float parseMean(ParserState parserState, AsmVisitor visitor) throws IOException {
                String meanLine = parserState.getNextLine();
                Matcher meanMatcher = MEAN_PATTERN.matcher(meanLine);
                if (!meanMatcher.find()) {
                    throw new IOException("invalid asm file: could not parse MDI mean distance: " + meanLine);
                }
                return Float.parseFloat(meanMatcher.group(1));
            }

            private long parseMin(ParserState parserState, AsmVisitor visitor) throws IOException {
                String minLine = parserState.getNextLine();
                Matcher meanMatcher = this.minPattern.matcher(minLine);
                if (!meanMatcher.find()) {
                    throw new IOException("invalid asm file: could not parse MDI min distance: " + minLine);
                }
                return Long.parseLong(meanMatcher.group(1));
            }

            private long parseMax(ParserState parserState, AsmVisitor visitor) throws IOException {
                String maxLine = parserState.getNextLine();
                Matcher meanMatcher = this.maxPattern.matcher(maxLine);
                if (!meanMatcher.find()) {
                    throw new IOException("invalid asm file: could not parse MDI max distance: " + maxLine);
                }
                return Long.parseLong(meanMatcher.group(1));
            }

            private List<Long> parseHistogram(ParserState parserState, AsmVisitor visitor) throws IOException {
                String histLine = parserState.getNextLine();
                Matcher bucketMatcher = this.histogramBucketPattern.matcher(histLine);
                if (!bucketMatcher.find()) {
                    throw new IOException("invalid asm file: could not parse MDI number of histogram buckets: " + histLine);
                }
                int numBuckets = Integer.parseInt(bucketMatcher.group(1));
                String histogramStart = parserState.getNextLine();
                if (!histogramStart.startsWith("his:")) {
                    throw new IOException("invalid asm file: could not parse MDI start of histogram values: " + histogramStart);
                }
                ArrayList<Long> histogram = new ArrayList<Long>(numBuckets);
                for (int i = 0; i < numBuckets; ++i) {
                    String line = parserState.getNextLine();
                    histogram.add(Long.parseLong(line.trim()));
                }
                return histogram;
            }
        }
        ,
        FRAGMENT("AFG"){
            private final Pattern isSingletonPattern = Pattern.compile("cha:(\\d+)");
            private final Pattern clearRangePattern = Pattern.compile("clr:(\\d+,\\d+)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                IdTuple idTuple = this.parseIds(parserState, visitor, ACCESSION_PATTERN);
                String scnLine = parserState.getNextLine();
                if (scnLine.startsWith("scn")) {
                    while (!scnLine.startsWith(".")) {
                        scnLine = parserState.getNextLine();
                    }
                    scnLine = parserState.getNextLine();
                }
                AsmVisitor.MateStatus mateStatus = this.parseMateStatus(scnLine);
                parserState.getNextLine();
                boolean isSingleton = this.parseIsSingleton(parserState, visitor);
                Range clearRange = this.parseClearRange(parserState, visitor);
                AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                visitor.visitRead(idTuple.externalId, idTuple.internalId, mateStatus, isSingleton, clearRange);
            }

            private Range parseClearRange(ParserState parserState, AsmVisitor visitor) throws IOException {
                String line = parserState.getNextLine();
                Matcher matcher = this.clearRangePattern.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("invalid asm file: could not parse AFG clear range: " + line);
                }
                return Range.parseRange(matcher.group(1), Range.CoordinateSystem.SPACE_BASED);
            }

            private boolean parseIsSingleton(ParserState parserState, AsmVisitor visitor) throws IOException {
                String line = parserState.getNextLine();
                Matcher matcher = this.isSingletonPattern.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("invalid asm file: could not parse AFG singlton status: " + line);
                }
                return Integer.parseInt(matcher.group(1).trim()) == 1;
            }
        }
        ,
        MATE_PAIR("AMP"){
            private final Pattern frgIdPattern = Pattern.compile("frg:(\\S+)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                String id1 = this.parseReadId(parserState);
                String id2 = this.parseReadId(parserState);
                AsmVisitor.MateStatus mateStatus = this.parseMateStatus(parserState);
                AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                visitor.visitMatePair(id1, id2, mateStatus);
            }

            private String parseReadId(ParserState parserState) throws IOException {
                String line = parserState.getNextLine();
                Matcher matcher = this.frgIdPattern.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("error reading frg id :" + line);
                }
                return matcher.group(1);
            }
        }
        ,
        UNITIG("UTG"){

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                float polymorphism;
                IdTuple idTuple = this.parseIds(parserState, visitor, ACCESSION_PATTERN);
                String nextLine = parserState.getNextLine();
                nextLine = AsmFileParser.skipSrcBlock(parserState, nextLine);
                float aStat = this.parseAStat(nextLine);
                nextLine = parserState.getNextLine();
                if (nextLine.startsWith("mhp")) {
                    polymorphism = this.parsePolymorphismMeasure(nextLine);
                    nextLine = parserState.getNextLine();
                } else {
                    polymorphism = Float.NaN;
                }
                AsmVisitor.UnitigStatus status = this.parseUnitigStatus(nextLine);
                nextLine = parserState.getNextLine();
                if (nextLine.startsWith("abp")) {
                    parserState.getNextLine();
                    parserState.getNextLine();
                }
                int length = AsmFileParser.parseLength(nextLine);
                NucleotideSequence consensus = this.parseConsensus(parserState, length);
                QualitySequence consensusQualities = this.parseConsensusQualities(parserState, length);
                parserState.getNextLine();
                long numberOfReads = AsmFileParser.parseNumberOfReads(parserState);
                CallBack callback = parserState.createCallback();
                AsmUnitigVisitor asmUnitigVisitor = visitor.visitUnitig(callback, idTuple.externalId, idTuple.internalId, aStat, polymorphism, status, consensus, consensusQualities, numberOfReads);
                int i = 0;
                while (parserState.keepParsing() && (long)i < numberOfReads) {
                    String readHeader = parserState.getNextLine();
                    Matcher matcher = MESSAGE_HEADER_PATTERN.matcher(readHeader);
                    if (!matcher.find()) {
                        throw new IOException(String.format("error reading read # %d for unitig %s; invalid header :%s", i, idTuple.externalId, readHeader));
                    }
                    String code = matcher.group(1);
                    if (!ReadMapping.INSTANCE.canHandle(code)) {
                        throw new IOException(String.format("error reading read # %d for unitig %s; invalid header code :%s", i, idTuple.externalId, code));
                    }
                    ReadMapping.INSTANCE.handleReadLayout(parserState, asmUnitigVisitor);
                    ++i;
                }
                if (asmUnitigVisitor != null) {
                    if (parserState.keepParsing()) {
                        AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                        asmUnitigVisitor.visitEnd();
                    } else {
                        asmUnitigVisitor.halted();
                    }
                }
            }

            private AsmVisitor.UnitigStatus parseUnitigStatus(String line) throws IOException {
                Matcher matcher = STATUS_PATTERN.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("error parsing unitig status : " + line);
                }
                return AsmVisitor.UnitigStatus.parseUnitigStatus(matcher.group(1));
            }

            private float parseAStat(String line) throws IOException {
                Matcher matcher = A_STAT_PATTERN.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("error reading unitig coverage a stat:" + line);
                }
                return Float.parseFloat(matcher.group(1));
            }

            private float parsePolymorphismMeasure(String line) throws IOException {
                Matcher matcher = POLYMORPHISM_PATTERN.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("error reading unitig polymorphism measure:" + line);
                }
                return Float.parseFloat(matcher.group(1));
            }
        }
        ,
        UNITIG_LINK("ULK"){
            private final Pattern unitigIdPattern = Pattern.compile("ut\\d:(\\S+)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                this.handle(parserState, visitor, true);
            }

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor, boolean shouldParse) throws IOException {
                this.parseLinkMessage(parserState, visitor, shouldParse, this.unitigIdPattern);
            }

            @Override
            protected void visitLink(AsmVisitor visitor, String unitig1, String unitig2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, boolean isPossibleChimera, float mean, float stdDev, int numberOfContributingEdges, AsmVisitor.OverlapStatus status, Set<AsmVisitor.MatePairEvidence> evidenceList) {
                visitor.visitUnitigLink(unitig1, unitig2, orientation, overlapType, status, isPossibleChimera, numberOfContributingEdges, mean, stdDev, evidenceList);
            }
        }
        ,
        CONTIG("CCO"){
            private final Pattern degeneratePattern = Pattern.compile("pla:(\\S)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                IdTuple idTuple = this.parseIds(parserState, visitor, ACCESSION_PATTERN);
                boolean isDegenerate = this.parseIsDegenerateFlag(parserState, visitor);
                String lengthLine = parserState.getNextLine();
                int length = AsmFileParser.parseLength(lengthLine);
                NucleotideSequence consensus = this.parseConsensus(parserState, length);
                QualitySequence consensusQualities = this.parseConsensusQualities(parserState, length);
                parserState.getNextLine();
                long numberOfReads = AsmFileParser.parseNumberOfReads(parserState);
                long numberOfUnitigs = AsmFileParser.parseNumberOfReads(parserState);
                long numberOfVariants = AsmFileParser.parseNumberOfReads(parserState);
                CallBack callback = parserState.createCallback();
                AsmContigVisitor contigVisitor = visitor.visitContig(callback, idTuple.externalId, idTuple.internalId, isDegenerate, consensus, consensusQualities, numberOfReads, numberOfUnitigs, numberOfVariants);
                if (!parserState.keepParsing()) {
                    return;
                }
                if (contigVisitor == null) {
                    long allSubBlocks = numberOfVariants + numberOfReads + numberOfUnitigs;
                    for (long i = 0L; i < allSubBlocks; ++i) {
                        AsmFileParser.skipCurrentBlock(parserState);
                    }
                } else {
                    String messageCode;
                    long i;
                    for (i = 0L; parserState.keepParsing() && i < numberOfVariants; ++i) {
                        String variantHeader = parserState.getNextLine();
                        messageCode = this.parseMessageCode(variantHeader);
                        if (!ContigVariant.INSTANCE.canHandle(messageCode)) {
                            throw new IOException("invalid variant block start : " + variantHeader);
                        }
                        ContigVariant.INSTANCE.handle(parserState, contigVisitor);
                    }
                    for (i = 0L; parserState.keepParsing() && i < numberOfReads; ++i) {
                        String readHeader = parserState.getNextLine();
                        messageCode = this.parseMessageCode(readHeader);
                        if (!ReadMapping.INSTANCE.canHandle(messageCode)) {
                            throw new IOException("invalid read mapping block start : " + readHeader);
                        }
                        ReadMapping.INSTANCE.handleReadLayout(parserState, contigVisitor);
                    }
                    for (i = 0L; parserState.keepParsing() && i < numberOfUnitigs; ++i) {
                        String unitigHeader = parserState.getNextLine();
                        messageCode = this.parseMessageCode(unitigHeader);
                        if (!ContigUnitigMapping.INSTANCE.canHandle(messageCode)) {
                            throw new IOException("invalid unitig mapping block start : " + unitigHeader);
                        }
                        ContigUnitigMapping.INSTANCE.handle(parserState, contigVisitor);
                    }
                    if (parserState.keepParsing()) {
                        AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                        contigVisitor.visitEnd();
                    } else {
                        contigVisitor.halted();
                    }
                }
            }

            private boolean parseIsDegenerateFlag(ParserState parserState, AsmVisitor visitor) throws IOException {
                String line = parserState.getNextLine();
                Matcher matcher = this.degeneratePattern.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("error reading contig placement status (degenerate flag):" + line);
                }
                return matcher.group(1).charAt(0) == 'U';
            }
        }
        ,
        CONTIG_LINK("CLK"){
            private final Pattern contigIdPattern = Pattern.compile("co\\d:(\\S+)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                this.handle(parserState, visitor, true);
            }

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor, boolean shouldParse) throws IOException {
                this.parseLinkMessage(parserState, visitor, shouldParse, this.contigIdPattern);
            }

            @Override
            protected void visitLink(AsmVisitor visitor, String id1, String id2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, boolean isPossibleChimera, float mean, float stdDev, int numberOfContributingEdges, AsmVisitor.OverlapStatus status, Set<AsmVisitor.MatePairEvidence> evidenceList) {
                visitor.visitContigLink(id1, id2, orientation, overlapType, status, numberOfContributingEdges, mean, stdDev, evidenceList);
            }
        }
        ,
        SCAFFOLD_LINK("SLK"){
            private final Pattern scaffoldIdPattern = Pattern.compile("sc\\d:(\\S+)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                this.handle(parserState, visitor, true);
            }

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor, boolean shouldParse) throws IOException {
                this.parseLinkMessage(parserState, visitor, shouldParse, this.scaffoldIdPattern);
            }

            @Override
            protected void visitLink(AsmVisitor visitor, String id1, String id2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, boolean isPossibleChimera, float mean, float stdDev, int numberOfContributingEdges, AsmVisitor.OverlapStatus status, Set<AsmVisitor.MatePairEvidence> evidenceList) {
                visitor.visitScaffoldLink(id1, id2, orientation, overlapType, status, numberOfContributingEdges, mean, stdDev, evidenceList);
            }
        }
        ,
        SCAFFOLD("SCF"){
            final Pattern numPairsPattern = Pattern.compile("noc:(\\d+)");
            final Pattern contigIdPattern = Pattern.compile("ct\\d:(\\S+)");

            @Override
            protected void handle(ParserState parserState, AsmVisitor visitor) throws IOException {
                CallBack callback = parserState.createCallback();
                IdTuple idTuple = this.parseIds(parserState, visitor, ACCESSION_PATTERN);
                int numberOfContigPairs = this.parseNumberOfContigPairs(parserState);
                if (numberOfContigPairs == 0) {
                    this.handleSingleContig(callback, parserState, idTuple, visitor);
                } else {
                    AsmScaffoldVisitor scaffoldVisitor = visitor.visitScaffold((AsmVisitor.AsmVisitorCallback)callback, idTuple.externalId, idTuple.internalId, numberOfContigPairs);
                    if (scaffoldVisitor != null) {
                        for (int i = 0; parserState.keepParsing() && i < numberOfContigPairs; ++i) {
                            this.handleContigPairs(parserState, scaffoldVisitor);
                        }
                        if (parserState.keepParsing()) {
                            AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                            scaffoldVisitor.visitEnd();
                        } else {
                            scaffoldVisitor.halted();
                        }
                    }
                }
            }

            private void handleSingleContig(CallBack callback, ParserState parserState, IdTuple idTuple, AsmVisitor visitor) throws IOException {
                this.parsePairStart(parserState);
                String contigId = this.parseContigId(parserState);
                String duplicateId = this.parseContigId(parserState);
                if (!contigId.equals(duplicateId)) {
                    throw new IOException(String.format("invalid single contig scaffold, contig ids ct1 and ct2 should be identical %s vs %s", contigId, duplicateId));
                }
                parserState.getNextLine();
                parserState.getNextLine();
                parserState.getNextLine();
                AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                visitor.visitScaffold((AsmVisitor.AsmVisitorCallback)callback, idTuple.externalId, idTuple.internalId, contigId);
            }

            private void handleContigPairs(ParserState parserState, AsmScaffoldVisitor scaffoldVisitor) throws IOException {
                this.parsePairStart(parserState);
                String contigId1 = this.parseContigId(parserState);
                String contigId2 = this.parseContigId(parserState);
                float mean = this.parseMeanEdgeDistance(parserState);
                float stdDev = this.parseStdDevDistance(parserState);
                AsmVisitor.LinkOrientation orientation = this.getLinkOrientation(parserState);
                AsmFileParser.parseEndOfMessage(parserState, this.getMessageCode());
                scaffoldVisitor.visitContigPair(contigId1, contigId2, mean, stdDev, orientation);
            }

            private int parseNumberOfContigPairs(ParserState parserState) throws IOException {
                String line = parserState.getNextLine();
                Matcher matcher = this.numPairsPattern.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("error parsing number of contig pairs : " + line);
                }
                return Integer.parseInt(matcher.group(1));
            }

            private String parseContigId(ParserState parserState) throws IOException {
                String line = parserState.getNextLine();
                Matcher matcher = this.contigIdPattern.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("error contig id :" + line);
                }
                return matcher.group(1);
            }

            private void parsePairStart(ParserState parserState) throws IOException {
                String line = parserState.getNextLine();
                if (!line.startsWith("{CTP")) {
                    throw new IOException("error parsing contig pair header : " + line);
                }
            }
        };

        private final String messageCode;
        static Pattern MESSAGE_HEADER_PATTERN;
        static final Pattern MATE_STATUS_PATTERN;
        static final Pattern ACCESSION_PATTERN;
        static final Pattern MEAN_PATTERN;
        static final Pattern STD_DEV_PATTERN;
        static final Pattern A_STAT_PATTERN;
        static final Pattern POLYMORPHISM_PATTERN;
        static final Pattern STATUS_PATTERN;
        final Pattern linkOrientationPattern = Pattern.compile("ori:(\\S)");
        final Pattern overlapTypePattern = Pattern.compile("ovt:(\\S)");
        final Pattern chimeraFlagPattern = Pattern.compile("ipc:(\\d)");
        final Pattern numEdgesPattern = Pattern.compile("num:(\\d+)");
        final Pattern linkStatusPattern = Pattern.compile("sta:(\\S)");
        final Pattern jumpListPattern = Pattern.compile("(\\S+),(\\S+),(\\S)");

        private AsmMessageHandler(String messageCode) {
            this.messageCode = messageCode;
        }

        final boolean canHandle(String messageCode) {
            return this.messageCode.equals(messageCode);
        }

        public String getMessageCode() {
            return this.messageCode;
        }

        public String parseMessageCode(String line) {
            Matcher matcher = MESSAGE_HEADER_PATTERN.matcher(line);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }

        protected abstract void handle(ParserState var1, AsmVisitor var2) throws IOException;

        protected void handle(ParserState parserState, AsmVisitor visitor, boolean shouldVisitRecord) throws IOException {
            this.handle(parserState, visitor);
        }

        public static void parse(ParserState parserState, AsmVisitor visitor) throws IOException {
            block0: while (parserState.hasNextLine()) {
                Matcher matcher;
                parserState.markCurrentOffset();
                String line = parserState.getNextLine();
                if (line == null || !(matcher = MESSAGE_HEADER_PATTERN.matcher(line)).find()) continue;
                String header = matcher.group(1);
                for (AsmMessageHandler handler : AsmMessageHandler.values()) {
                    if (!handler.canHandle(header)) continue;
                    handler.handle(parserState, visitor);
                    continue block0;
                }
            }
            if (parserState.keepParsing()) {
                visitor.visitEnd();
            } else {
                visitor.halted();
            }
        }

        IdTuple parseIds(ParserState parserState, AsmVisitor visitor, Pattern pattern) throws IOException {
            String idLine = parserState.getNextLine();
            Matcher idMatcher = pattern.matcher(idLine);
            if (!idMatcher.find()) {
                throw new IOException("invalid asm file: could not parse IDs: " + idLine);
            }
            return new IdTuple(idMatcher.group(1), Long.parseLong(idMatcher.group(2)));
        }

        AsmVisitor.MateStatus parseMateStatus(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = MATE_STATUS_PATTERN.matcher(line);
            if (!matcher.find()) {
                throw new IOException("invalid asm file: could not parse " + this.messageCode + " mate status: " + line);
            }
            return AsmVisitor.MateStatus.parseMateStatus(matcher.group(1));
        }

        AsmVisitor.MateStatus parseMateStatus(String line) throws IOException {
            Matcher matcher = MATE_STATUS_PATTERN.matcher(line);
            if (!matcher.find()) {
                throw new IOException("invalid asm file: could not parse " + this.messageCode + " mate status: " + line);
            }
            return AsmVisitor.MateStatus.parseMateStatus(matcher.group(1));
        }

        QualitySequence parseConsensusQualities(ParserState parserState, int length) throws IOException {
            byte[] qualities = new byte[length];
            String line = parserState.getNextLine();
            if (!line.startsWith("qlt:")) {
                throw new IOException("expected start quality consensus block :" + line);
            }
            line = parserState.getNextLine();
            int offset = 0;
            while (!line.startsWith(".")) {
                String trimmedLine = line.trim();
                for (int i = 0; i < trimmedLine.length(); ++i) {
                    qualities[offset + i] = (byte)(trimmedLine.charAt(i) - 48);
                }
                offset += trimmedLine.length();
                line = parserState.getNextLine();
            }
            if (offset != length) {
                throw new IOException(String.format("incorrect consensus quality length for %s: expected %d but was %d", this.getMessageCode(), length, offset));
            }
            return new QualitySequenceBuilder(qualities).build();
        }

        NucleotideSequence parseConsensus(ParserState parserState, int expectedLength) throws IOException {
            NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(expectedLength);
            String line = parserState.getNextLine();
            if (!line.startsWith("cns:")) {
                throw new IOException("expected begin cns field but was " + line);
            }
            line = parserState.getNextLine();
            while (!line.startsWith(".")) {
                builder.append(line.trim());
                line = parserState.getNextLine();
            }
            if (builder.getLength() != (long)expectedLength) {
                throw new IOException(String.format("incorrect consensus length for %s: expected %d but was %d", this.getMessageCode(), expectedLength, builder.getLength()));
            }
            return builder.build();
        }

        Set<AsmVisitor.MatePairEvidence> parseMatePairEvidence(int expectedNumberOfMatePairEvidenceRecords, ParserState parserState) throws IOException {
            LinkedHashSet<AsmVisitor.MatePairEvidence> set = new LinkedHashSet<AsmVisitor.MatePairEvidence>();
            for (int i = 0; i < expectedNumberOfMatePairEvidenceRecords; ++i) {
                String line = parserState.getNextLine();
                Matcher matcher = this.jumpListPattern.matcher(line);
                if (!matcher.find()) {
                    throw new IOException("invalid jump list record: " + line);
                }
                set.add(new MatePairEvidenceImpl(matcher.group(1), matcher.group(2)));
            }
            return set;
        }

        AsmVisitor.OverlapStatus parseOverlapStatus(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.linkStatusPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error overlap status" + line);
            }
            return AsmVisitor.OverlapStatus.parseOverlapStatus(matcher.group(1));
        }

        int parseNumberOfEdges(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.numEdgesPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading # of edges" + line);
            }
            return Integer.parseInt(matcher.group(1));
        }

        float parseMeanEdgeDistance(String nextLine) throws IOException {
            Matcher matcher = MEAN_PATTERN.matcher(nextLine);
            if (!matcher.find()) {
                throw new IOException("error reading is mean edge distance message" + nextLine);
            }
            return Float.parseFloat(matcher.group(1));
        }

        float parseMeanEdgeDistance(ParserState parserState) throws IOException {
            String nextLine = parserState.getNextLine();
            Matcher matcher = MEAN_PATTERN.matcher(nextLine);
            if (!matcher.find()) {
                throw new IOException("error reading is mean edge distance message" + nextLine);
            }
            return Float.parseFloat(matcher.group(1));
        }

        float parseStdDevDistance(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = STD_DEV_PATTERN.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading is std dev edge distance message" + line);
            }
            return Float.parseFloat(matcher.group(1));
        }

        boolean getChimeraFlag(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.chimeraFlagPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading is possible chimera message" + line);
            }
            int value = Integer.parseInt(matcher.group(1));
            return value == 1;
        }

        AsmVisitor.LinkOrientation getLinkOrientation(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.linkOrientationPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading link orientation message" + line);
            }
            return AsmVisitor.LinkOrientation.parseLinkOrientation(matcher.group(1));
        }

        AsmVisitor.OverlapType getOverlapType(ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = this.overlapTypePattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading overlap type message" + line);
            }
            return AsmVisitor.OverlapType.parseOverlapType(matcher.group(1));
        }

        String getUnitigId(Pattern idPattern, ParserState parserState) throws IOException {
            String line = parserState.getNextLine();
            Matcher matcher = idPattern.matcher(line);
            if (!matcher.find()) {
                throw new IOException("error reading unitig link message unitig id:" + line);
            }
            return matcher.group(1);
        }

        void parseLinkMessage(ParserState parserState, AsmVisitor visitor, boolean shouldParse, Pattern idPattern) throws IOException {
            String unitig1 = this.getUnitigId(idPattern, parserState);
            String unitig2 = this.getUnitigId(idPattern, parserState);
            AsmVisitor.LinkOrientation orientation = this.getLinkOrientation(parserState);
            AsmVisitor.OverlapType overlapType = this.getOverlapType(parserState);
            boolean isPossibleChimera = this.getChimeraFlag(parserState);
            String nextLine = parserState.getNextLine();
            if (nextLine.startsWith("gui:")) {
                nextLine = parserState.getNextLine();
            }
            float mean = this.parseMeanEdgeDistance(nextLine);
            float stdDev = this.parseStdDevDistance(parserState);
            int numberOfContributingEdges = this.parseNumberOfEdges(parserState);
            AsmVisitor.OverlapStatus status = this.parseOverlapStatus(parserState);
            String jumpList = parserState.getNextLine();
            if (!jumpList.startsWith("jls:")) {
                throw new IOException("invalid jump list block : " + jumpList);
            }
            Set<AsmVisitor.MatePairEvidence> evidenceList = this.parseMatePairEvidence(overlapType.getExpectedNumberOfMatePairEvidenceRecords(numberOfContributingEdges), parserState);
            AsmFileParser.parseEndOfMessage(parserState, this.messageCode);
            if (shouldParse) {
                this.visitLink(visitor, unitig1, unitig2, orientation, overlapType, isPossibleChimera, mean, stdDev, numberOfContributingEdges, status, evidenceList);
            }
        }

        protected void visitLink(AsmVisitor visitor, String unitig1, String unitig2, AsmVisitor.LinkOrientation orientation, AsmVisitor.OverlapType overlapType, boolean isPossibleChimera, float mean, float stdDev, int numberOfContributingEdges, AsmVisitor.OverlapStatus status, Set<AsmVisitor.MatePairEvidence> evidenceList) {
            throw new IllegalStateException("invalid state should not contain any links");
        }

        static {
            MESSAGE_HEADER_PATTERN = Pattern.compile("\\{(\\S+)");
            MATE_STATUS_PATTERN = Pattern.compile("mst:(\\S)");
            ACCESSION_PATTERN = Pattern.compile("acc:\\((\\S+),(\\d+)\\)");
            MEAN_PATTERN = Pattern.compile("mea:(\\S+)");
            STD_DEV_PATTERN = Pattern.compile("std:(\\S+)");
            A_STAT_PATTERN = Pattern.compile("cov:(\\S+)");
            POLYMORPHISM_PATTERN = Pattern.compile("mhp:(\\S+)");
            STATUS_PATTERN = Pattern.compile("sta:(\\S)");
        }
    }

    protected abstract class ParserState
    implements Closeable {
        private final TextLineParser parser;
        protected long markedOffset;
        protected final AtomicBoolean keepParsing = new AtomicBoolean(true);

        ParserState(InputStream inputStream, long initialOffset) throws IOException {
            this.parser = new TextLineParser(inputStream, initialOffset);
            this.markedOffset = initialOffset;
        }

        boolean hasNextLine() {
            return this.parser.hasNextLine();
        }

        String getNextLine() throws IOException {
            return this.parser.nextLine();
        }

        @Override
        public void close() throws IOException {
            this.parser.close();
        }

        public abstract CallBack createCallback();

        public void markCurrentOffset() {
            this.markedOffset = this.parser.getPosition();
        }

        public boolean keepParsing() {
            return this.keepParsing.get();
        }
    }
}

