/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.ca.asm.AsmUnitigBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmUnitigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmUtil;
import org.jcvi.jillion.assembly.ca.asm.DefaultAsmUnitig;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public abstract class AbstractAsmUnitigBuilder
implements AsmUnitigVisitor {
    private final Map<String, Range> validRanges;
    private final DataStore<NucleotideSequence> fullLengthSequenceDatastore;
    private final AsmUnitigBuilder builder;

    public AbstractAsmUnitigBuilder(String id, NucleotideSequence consensus, DataStore<NucleotideSequence> fullLengthSequenceDatastore, Map<String, Range> validRanges) {
        this.fullLengthSequenceDatastore = fullLengthSequenceDatastore;
        this.validRanges = validRanges;
        this.builder = DefaultAsmUnitig.createBuilder(id, consensus);
    }

    @Override
    public void visitReadLayout(char readType, String externalReadId, DirectedRange readRange, List<Integer> gapOffsets) {
        try {
            NucleotideSequence fullLengthSequence = this.fullLengthSequenceDatastore.get(externalReadId);
            Range clearRange = this.validRanges.get(externalReadId);
            if (clearRange == null) {
                throw new IllegalStateException("do not have clear range information for read " + externalReadId);
            }
            NucleotideSequenceBuilder validBases = new NucleotideSequenceBuilder(fullLengthSequence).trim(clearRange);
            if (readRange.getDirection() == Direction.REVERSE) {
                validBases.reverseComplement();
            }
            validBases = AsmUtil.computeGappedSequence(validBases, gapOffsets);
            this.builder.addRead(externalReadId, validBases.toString(), (int)readRange.asRange().getBegin(), readRange.getDirection(), clearRange, (int)fullLengthSequence.getLength(), false);
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error getting read id " + externalReadId + " from frg file", e);
        }
    }

    @Override
    public void halted() {
    }

    @Override
    public void visitEnd() {
        this.visitUnitig(this.builder);
    }

    protected abstract void visitUnitig(AsmUnitigBuilder var1);
}

