/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.ca.asm;

import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.jcvi.jillion.assembly.ca.asm.AsmContigBuilder;
import org.jcvi.jillion.assembly.ca.asm.AsmContigVisitor;
import org.jcvi.jillion.assembly.ca.asm.AsmUtil;
import org.jcvi.jillion.assembly.ca.asm.AsmVisitor;
import org.jcvi.jillion.assembly.ca.asm.DefaultAsmContig;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public abstract class AbstractAsmContigBuilder
implements AsmContigVisitor {
    private final Map<String, Range> validRanges;
    private final DataStore<NucleotideSequence> fullLengthSequenceDatastore;
    private final AsmContigBuilder builder;

    public AbstractAsmContigBuilder(String id, NucleotideSequence consensus, boolean isDegenerate, DataStore<NucleotideSequence> fullLengthSequenceDatastore, Map<String, Range> validRanges) {
        this.fullLengthSequenceDatastore = fullLengthSequenceDatastore;
        this.validRanges = validRanges;
        this.builder = DefaultAsmContig.createBuilder(id, consensus, isDegenerate);
    }

    @Override
    public void visitVariance(Range range, long numberOfSpanningReads, long anchorSize, long internalAccessionId, long accessionForPhasedVariant, SortedSet<AsmContigVisitor.VariantRecord> variantRecords) {
    }

    @Override
    public void visitReadLayout(char readType, String externalReadId, DirectedRange readRange, List<Integer> gapOffsets) {
        try {
            NucleotideSequence fullLengthSequence = this.fullLengthSequenceDatastore.get(externalReadId);
            Range clearRange = this.validRanges.get(externalReadId);
            if (clearRange == null) {
                throw new IllegalStateException("do not have clear range information for read " + externalReadId);
            }
            NucleotideSequenceBuilder validBases = new NucleotideSequenceBuilder(fullLengthSequence).trim(clearRange);
            if (readRange.getDirection() == Direction.REVERSE) {
                validBases.reverseComplement();
            }
            validBases = AsmUtil.computeGappedSequence(validBases, gapOffsets);
            this.builder.addRead(externalReadId, validBases.toString(), (int)readRange.asRange().getBegin(), readRange.getDirection(), clearRange, (int)fullLengthSequence.getLength(), false);
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error getting read id " + externalReadId + " from frg file", e);
        }
    }

    @Override
    public void visitUnitigLayout(AsmVisitor.UnitigLayoutType type, String unitigExternalId, DirectedRange unitigRange, List<Long> gapOffsets) {
    }

    @Override
    public void halted() {
    }

    @Override
    public final void visitEnd() {
        this.visitContig(this.builder);
    }

    protected abstract void visitContig(AsmContigBuilder var1);
}

