/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import org.jcvi.jillion.core.Range;

public class ReadInfo {
    private final Range validRange;
    private final int fullLength;

    public ReadInfo(Range validRange, int fullLength) {
        if (validRange == null) {
            throw new NullPointerException("valid range can not be null");
        }
        if (fullLength < 0) {
            throw new IllegalArgumentException("full length must be >=0");
        }
        if ((long)fullLength < validRange.getEnd()) {
            throw new IllegalArgumentException("full length must be >=validRange.getEnd()");
        }
        this.validRange = validRange;
        this.fullLength = fullLength;
    }

    public Range getValidRange() {
        return this.validRange;
    }

    public int getUngappedFullLength() {
        return this.fullLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fullLength;
        result = 31 * result + this.validRange.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadInfo other = (ReadInfo)obj;
        if (this.fullLength != other.fullLength) {
            return false;
        }
        return this.validRange.equals(other.validRange);
    }

    public String toString() {
        return "ReadInfo [validRange=" + this.validRange + ", fullLength=" + this.fullLength + "]";
    }
}

