/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import java.util.Arrays;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public final class GappedReferenceBuilder {
    private final NucleotideSequence ungappedReference;
    private final Insertion[] insertions;

    public GappedReferenceBuilder(NucleotideSequence ungappedReference) {
        if (ungappedReference == null) {
            throw new NullPointerException("ungapped reference can not be null");
        }
        if (ungappedReference.getNumberOfGaps() > 0) {
            throw new IllegalArgumentException("reference can not have gaps");
        }
        long length = ungappedReference.getLength();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("reference too big > int MAX");
        }
        this.ungappedReference = ungappedReference;
        this.insertions = new Insertion[(int)length];
    }

    public GappedReferenceBuilder addReadInsertion(int offset, int insertionSize) {
        if (this.insertions[offset] == null) {
            this.insertions[offset] = new Insertion(insertionSize);
        } else {
            this.insertions[offset].updateSize(insertionSize);
        }
        return this;
    }

    public NucleotideSequence build() {
        int numberOfGaps = this.computeTotalNumberOfGaps();
        NucleotideSequenceBuilder gappedSequenceBuilder = new NucleotideSequenceBuilder(numberOfGaps + this.insertions.length);
        gappedSequenceBuilder.append(this.ungappedReference);
        for (int i = this.insertions.length - 1; i >= 0; --i) {
            Insertion insertion = this.insertions[i];
            if (insertion == null) continue;
            gappedSequenceBuilder.insert(i, this.createGapStringOf(insertion.getSize()));
        }
        return gappedSequenceBuilder.build();
    }

    private int computeTotalNumberOfGaps() {
        int numberOfGaps = 0;
        for (int i = 0; i < this.insertions.length; ++i) {
            Insertion insertion = this.insertions[i];
            if (insertion == null) continue;
            numberOfGaps += insertion.getSize();
        }
        return numberOfGaps;
    }

    private char[] createGapStringOf(int maxGapSize) {
        char[] gaps = new char[maxGapSize];
        Arrays.fill(gaps, '-');
        return gaps;
    }

    private static class Insertion {
        private int size = 0;

        public Insertion(int initialSize) {
            if (initialSize < 0) {
                throw new IllegalArgumentException("insertion size can not be negative : " + initialSize);
            }
            this.size = initialSize;
        }

        public void updateSize(int newSize) {
            if (newSize > this.size) {
                this.size = newSize;
            }
        }

        public int getSize() {
            return this.size;
        }
    }
}

