/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.DefaultScaffold;
import org.jcvi.jillion.assembly.PlacedContig;
import org.jcvi.jillion.assembly.Scaffold;
import org.jcvi.jillion.assembly.ScaffoldBuilder;
import org.jcvi.jillion.assembly.ScaffoldDataStore;
import org.jcvi.jillion.assembly.ScaffoldDataStoreBuilder;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.util.MapUtil;

public final class DefaultScaffoldDataStore {
    private DefaultScaffoldDataStore() {
    }

    public static ScaffoldDataStoreBuilder createBuilder() {
        return new DefaultScaffoldDataStoreBuilder();
    }

    private static final class DefaultScaffoldDataStoreBuilder
    implements ScaffoldDataStoreBuilder {
        private final Map<String, ScaffoldBuilder> builders = new HashMap<String, ScaffoldBuilder>();

        private DefaultScaffoldDataStoreBuilder() {
        }

        @Override
        public synchronized ScaffoldDataStore build() {
            int mapSize = MapUtil.computeMinHashMapSizeWithoutRehashing(this.builders.size());
            HashMap<String, Scaffold> scaffolds = new HashMap<String, Scaffold>(mapSize);
            for (Map.Entry<String, ScaffoldBuilder> entry : this.builders.entrySet()) {
                scaffolds.put(entry.getKey(), entry.getValue().build());
            }
            return DataStore.of(scaffolds, ScaffoldDataStore.class);
        }

        @Override
        public synchronized ScaffoldDataStoreBuilder addScaffold(Scaffold scaffold) {
            String scaffoldId = scaffold.getId();
            if (!this.builders.containsKey(scaffoldId)) {
                this.builders.put(scaffoldId, DefaultScaffold.createBuilder(scaffoldId));
            }
            for (PlacedContig placedContig : scaffold.getPlacedContigs()) {
                this.builders.get(scaffoldId).add(placedContig);
            }
            return this;
        }

        @Override
        public synchronized ScaffoldDataStoreBuilder addPlacedContig(String scaffoldId, String contigId, DirectedRange directedRange) {
            if (!this.builders.containsKey(scaffoldId)) {
                this.builders.put(scaffoldId, DefaultScaffold.createBuilder(scaffoldId));
            }
            this.builders.get(scaffoldId).add(contigId, directedRange.asRange(), directedRange.getDirection());
            return this;
        }
    }
}

