/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.DefaultPlacedContig;
import org.jcvi.jillion.assembly.PlacedContig;
import org.jcvi.jillion.assembly.Scaffold;
import org.jcvi.jillion.assembly.ScaffoldBuilder;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageMapBuilder;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Ranges;

public final class DefaultScaffold
implements Scaffold {
    private final String id;
    private final SortedSet<PlacedContig> placedContigs;
    private final Map<String, PlacedContig> contigbyId;
    private final CoverageMap<PlacedContig> contigMap;
    private final long length;

    public static ScaffoldBuilder createBuilder(String id) {
        return new Builder(id);
    }

    private DefaultScaffold(String id, SortedSet<PlacedContig> placedContigs) {
        this.id = id;
        this.placedContigs = placedContigs;
        this.contigbyId = new HashMap<String, PlacedContig>();
        for (PlacedContig contig : placedContigs) {
            this.contigbyId.put(contig.getContigId(), contig);
        }
        ArrayList<Range> ranges = new ArrayList<Range>(placedContigs.size());
        for (PlacedContig contig : placedContigs) {
            ranges.add(Range.of(contig.getBegin(), contig.getEnd()));
        }
        this.length = Ranges.createInclusiveRange(ranges).getLength();
        this.contigMap = new CoverageMapBuilder<PlacedContig>(placedContigs).includeOrigin(true).build();
    }

    @Override
    public PlacedContig getPlacedContig(String id) {
        return this.contigbyId.get(id);
    }

    @Override
    public Set<PlacedContig> getPlacedContigs() {
        return this.placedContigs;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public int getNumberOfContigs() {
        return this.placedContigs.size();
    }

    @Override
    public CoverageMap<PlacedContig> getContigCoverageMap() {
        return this.contigMap;
    }

    @Override
    public boolean hasContig(String contigId) {
        return this.contigbyId.containsKey(contigId);
    }

    @Override
    public Range convertContigRangeToScaffoldRange(String placedContigId, Range placedContigRange) {
        Range.Builder rangeBuilder;
        PlacedContig placedContig = this.getPlacedContig(placedContigId);
        if (placedContig == null) {
            throw new NoSuchElementException("Scaffold " + this.getId() + " does not contain the placed contig " + placedContigId);
        }
        Range normalizedPlacedContigRange = Range.of(0L, placedContig.getLength() - 1L);
        if (!placedContigRange.isSubRangeOf(normalizedPlacedContigRange)) {
            throw new IllegalArgumentException("Specified contig range " + placedContigRange + " is not a subrange of its parent placed contig " + placedContig + "(normalized range " + normalizedPlacedContigRange + ")");
        }
        if (placedContig.getDirection() == Direction.FORWARD) {
            rangeBuilder = new Range.Builder(placedContigRange);
        } else {
            Range reverseComplementRange = AssemblyUtil.reverseComplementValidRange(placedContigRange, placedContig.getLength());
            rangeBuilder = new Range.Builder(reverseComplementRange);
        }
        rangeBuilder.shift(placedContig.getBegin());
        return rangeBuilder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.contigbyId.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + this.placedContigs.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultScaffold)) {
            return false;
        }
        DefaultScaffold other = (DefaultScaffold)obj;
        if (!this.contigbyId.equals(other.contigbyId)) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (!this.placedContigs.equals(other.placedContigs)) {
            return false;
        }
        return this.contigMap.equals(other.contigMap);
    }

    @Override
    public Iterator<String> getContigIds() {
        return this.contigbyId.keySet().iterator();
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder(75);
        builder2.append("DefaultScaffold [id=").append(this.id).append(", length=").append(this.length).append(", placedContigs=").append(this.placedContigs).append(']');
        return builder2.toString();
    }

    private static final class Builder
    implements ScaffoldBuilder {
        private final String id;
        private SortedSet<PlacedContig> contigs;
        private boolean shiftContigs = false;
        private boolean built = false;

        private Builder(String id) {
            this.id = id;
            this.contigs = new TreeSet<PlacedContig>(new PlacedContigComparator());
        }

        private synchronized void throwErrorIfBuilt() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
        }

        @Override
        public synchronized Builder add(PlacedContig placedContig) {
            this.throwErrorIfBuilt();
            if (placedContig == null) {
                throw new NullPointerException("placed contig can not be null");
            }
            this.contigs.add(placedContig);
            return this;
        }

        @Override
        public synchronized Builder add(String contigId, Range contigRange, Direction contigDirection) {
            return this.add(new DefaultPlacedContig(contigId, contigRange, contigDirection));
        }

        @Override
        public synchronized Builder add(String contigId, DirectedRange contigRange) {
            return this.add(new DefaultPlacedContig(contigId, contigRange.getRange(), contigRange.getDirection()));
        }

        @Override
        public synchronized Builder add(String contigId, Range contigRange) {
            return this.add(contigId, contigRange, Direction.FORWARD);
        }

        @Override
        public synchronized ScaffoldBuilder shiftContigsToOrigin(boolean shiftContigs) {
            this.throwErrorIfBuilt();
            this.shiftContigs = shiftContigs;
            return this;
        }

        @Override
        public synchronized DefaultScaffold build() {
            this.throwErrorIfBuilt();
            if (this.shiftContigs && !this.contigs.isEmpty()) {
                TreeSet<PlacedContig> shiftedContigs = new TreeSet<PlacedContig>(new PlacedContigComparator());
                PlacedContig firstContig = this.contigs.first();
                long shiftOffset = -firstContig.getBegin();
                for (PlacedContig contig : this.contigs) {
                    shiftedContigs.add(new DefaultPlacedContig(contig.getContigId(), new Range.Builder(contig.asRange()).shift(shiftOffset).build(), contig.getDirection()));
                }
                this.contigs = shiftedContigs;
            }
            this.built = true;
            return new DefaultScaffold(this.id, this.contigs);
        }
    }

    private static final class PlacedContigComparator
    implements Comparator<PlacedContig>,
    Serializable {
        private static final long serialVersionUID = 101208868003843457L;

        private PlacedContigComparator() {
        }

        @Override
        public int compare(PlacedContig o1, PlacedContig o2) {
            int rangeCmp = Range.Comparators.ARRIVAL.compare(o1.asRange(), o2.asRange());
            if (rangeCmp != 0) {
                return rangeCmp;
            }
            return o1.getContigId().compareTo(o2.getContigId());
        }
    }
}

