/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import org.jcvi.jillion.assembly.PlacedContig;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;

final class DefaultPlacedContig
implements PlacedContig {
    private final String contigId;
    private final Range range;
    private final Direction direction;

    public DefaultPlacedContig(String id, Range range) {
        this(id, range, Direction.FORWARD);
    }

    public DefaultPlacedContig(String id, Range range, Direction direction) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (range == null) {
            throw new NullPointerException("range can not be null");
        }
        if (direction == null) {
            throw new NullPointerException("direction can not be null");
        }
        this.contigId = id;
        this.range = range;
        this.direction = direction;
    }

    @Override
    public String getContigId() {
        return this.contigId;
    }

    @Override
    public long getEnd() {
        return this.range.getEnd();
    }

    @Override
    public long getLength() {
        return this.range.getLength();
    }

    @Override
    public long getBegin() {
        return this.range.getBegin();
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.contigId.hashCode();
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.range.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPlacedContig)) {
            return false;
        }
        DefaultPlacedContig other = (DefaultPlacedContig)obj;
        if (!this.contigId.equals(other.contigId)) {
            return false;
        }
        if (!this.direction.equals((Object)other.direction)) {
            return false;
        }
        return this.range.equals(other.range);
    }

    public String toString() {
        return "DefaultPlacedContig [contigId=" + this.contigId + ", direction=" + (Object)((Object)this.direction) + ", range=" + this.range + "]";
    }

    @Override
    public Range asRange() {
        return this.range;
    }
}

