/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssemblyTransformationService;
import org.jcvi.jillion.assembly.AssemblyTransformer;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.ContigDataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public final class ContigDataStoreTransfomationService
implements AssemblyTransformationService {
    private final ContigDataStore<?, ?> datastore;
    private final NucleotideSequenceDataStore rawSequences;
    private final QualitySequenceDataStore rawQualities;

    private ContigDataStoreTransfomationService(Builder builder) {
        this.datastore = builder.datastore;
        this.rawQualities = builder.rawQualities;
        this.rawSequences = builder.rawSequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(AssemblyTransformer transformer) {
        if (transformer == null) {
            throw new NullPointerException("transformer can not be null");
        }
        StreamingIterator contigIter = null;
        try {
            contigIter = this.datastore.iterator();
            while (contigIter.hasNext()) {
                Contig contig = (Contig)contigIter.next();
                String contigId = contig.getId();
                transformer.referenceOrConsensus(contigId, contig.getConsensusSequence());
                StreamingIterator readIter = contig.getReadIterator();
                try {
                    while (readIter.hasNext()) {
                        AssembledRead read = (AssembledRead)readIter.next();
                        NucleotideSequence rawSeq = this.rawSequences == null ? null : (NucleotideSequence)this.rawSequences.get(read.getId());
                        QualitySequence rawQual = this.rawQualities == null ? null : (QualitySequence)this.rawQualities.get(read.getId());
                        transformer.aligned(read.getId(), rawSeq, rawQual, null, null, contigId, (int)read.getGappedStartOffset(), read.getDirection(), read.getNucleotideSequence(), read.getReadInfo());
                    }
                }
                finally {
                    IOUtil.closeAndIgnoreErrors(readIter);
                }
            }
            transformer.endAssembly();
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error reading datastore", e);
        }
        finally {
            IOUtil.closeAndIgnoreErrors(contigIter);
        }
    }

    public static final class Builder {
        private final ContigDataStore<?, ?> datastore;
        private NucleotideSequenceDataStore rawSequences;
        private QualitySequenceDataStore rawQualities;

        public Builder(ContigDataStore<?, ?> datastore) {
            if (datastore == null) {
                throw new NullPointerException("datastore can not be null");
            }
            this.datastore = datastore;
        }

        public Builder setRawSequenceDataStore(NucleotideSequenceDataStore datastore) {
            this.rawSequences = datastore;
            return this;
        }

        public Builder setRawQualitiyDataStore(QualitySequenceDataStore datastore) {
            this.rawQualities = datastore;
            return this;
        }

        public ContigDataStoreTransfomationService build() {
            return new ContigDataStoreTransfomationService(this);
        }
    }
}

