/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;

public final class AssemblyUtil {
    private AssemblyUtil() {
    }

    public static NucleotideSequence buildGappedComplementedFullRangeBases(AssembledRead assembledRead, NucleotideSequence ungappedUncomplementedFullRangeBases) {
        return AssemblyUtil.buildGappedComplementedFullRangeBases(assembledRead, ungappedUncomplementedFullRangeBases, false);
    }

    public static NucleotideSequence buildGappedComplementedFullRangeBases(AssembledRead assembledRead, NucleotideSequence ungappedUncomplementedFullRangeBases, boolean turnOffCompression) {
        Direction dir = assembledRead.getDirection();
        Range validRange = assembledRead.getReadInfo().getValidRange();
        NucleotideSequenceBuilder ungappedFullRangeComplimentedBuilder = new NucleotideSequenceBuilder(ungappedUncomplementedFullRangeBases).turnOffDataCompression(turnOffCompression);
        if (dir == Direction.REVERSE) {
            validRange = AssemblyUtil.reverseComplementValidRange(validRange, ungappedUncomplementedFullRangeBases.getLength());
            ungappedFullRangeComplimentedBuilder.reverseComplement();
        }
        NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder((int)(2L * ungappedFullRangeComplimentedBuilder.getLength()));
        builder.append(ungappedFullRangeComplimentedBuilder.copy(new Range.Builder(validRange.getBegin()).build()));
        builder.append(assembledRead.getNucleotideSequence());
        builder.append(ungappedFullRangeComplimentedBuilder.copy(Range.of(validRange.getEnd() + 1L, ungappedFullRangeComplimentedBuilder.getLength() - 1L)));
        return builder.build();
    }

    public static QualitySequence getUngappedComplementedValidRangeQualities(AssembledRead read, QualitySequence fullRangeRawQualities) {
        QualitySequenceBuilder builder = new QualitySequenceBuilder(fullRangeRawQualities);
        builder.trim(read.getReadInfo().getValidRange());
        if (read.getDirection() == Direction.REVERSE) {
            builder.reverse();
        }
        return builder.build();
    }

    public static Range reverseComplementValidRange(Range validRange, long fullLength) {
        if (validRange == null) {
            throw new NullPointerException("valid range can not be null");
        }
        if (fullLength < validRange.getLength()) {
            throw new IllegalArgumentException(String.format("valid range  %s is larger than fullLength %d", validRange, fullLength));
        }
        long newStart = fullLength - validRange.getEnd() - 1L;
        long newEnd = fullLength - validRange.getBegin() - 1L;
        return Range.of(newStart, newEnd);
    }

    public static int convertToUngappedFullRangeOffset(AssembledRead placedRead, int gappedOffset) {
        Range validRange = placedRead.getReadInfo().getValidRange();
        return AssemblyUtil.convertToUngappedFullRangeOffset(placedRead, placedRead.getReadInfo().getUngappedFullLength(), gappedOffset, validRange);
    }

    private static int convertToUngappedFullRangeOffset(AssembledRead placedRead, int fullLength, int gappedOffset, Range validRange) {
        ReferenceMappedNucleotideSequence nucleotideSequence = placedRead.getNucleotideSequence();
        int ungappedOffset = gappedOffset == -1 ? -1 : ((long)gappedOffset == nucleotideSequence.getLength() ? (int)(nucleotideSequence.getUngappedLength() + 1L) : nucleotideSequence.getUngappedOffsetFor(gappedOffset));
        if (placedRead.getDirection() == Direction.REVERSE) {
            return (int)(validRange.getEnd() - (long)ungappedOffset);
        }
        return ungappedOffset + (int)validRange.getBegin();
    }

    public static int getLeftFlankingNonGapIndex(NucleotideSequence gappedNucleotides, int gappedReadIndex) {
        if (gappedReadIndex < 0) {
            return gappedReadIndex;
        }
        if (gappedNucleotides.isGap(gappedReadIndex)) {
            return AssemblyUtil.getLeftFlankingNonGapIndex(gappedNucleotides, gappedReadIndex - 1);
        }
        return gappedReadIndex;
    }

    public static int getRightFlankingNonGapIndex(NucleotideSequence sequence, int gappedOffset) {
        if ((long)gappedOffset > sequence.getLength() - 1L) {
            return gappedOffset;
        }
        if (sequence.isGap(gappedOffset)) {
            return AssemblyUtil.getRightFlankingNonGapIndex(sequence, gappedOffset + 1);
        }
        return gappedOffset;
    }

    public static Range toUngappedRange(NucleotideSequence gappedSequence, Range gappedRange) {
        return gappedSequence.toUngappedRange(gappedRange);
    }
}

