/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.ContigBuilder;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceBuilder;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public abstract class AbstractContigBuilder<P extends AssembledRead, C extends Contig<P>>
implements ContigBuilder<P, C> {
    private static final PhredQuality DEFAULT_QUALITY = PhredQuality.valueOf(30);
    private final NucleotideSequenceBuilder consensus;
    private String id;
    private final Map<String, AssembledReadBuilder<P>> reads;
    protected ConsensusCaller consensusCaller = null;
    private QualitySequenceDataStore qualityDataStore = null;
    private GapQualityValueStrategy qualityValueStrategy = null;

    protected AbstractContigBuilder(String id, NucleotideSequence consensus) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (consensus == null) {
            throw new NullPointerException("consensus can not be null");
        }
        this.id = id;
        this.consensus = new NucleotideSequenceBuilder(consensus);
        this.reads = new LinkedHashMap<String, AssembledReadBuilder<P>>();
    }

    public AbstractContigBuilder<P, C> addRead(String id, int offset, Range validRange, String basecalls, Direction dir, int fullUngappedLength) {
        this.reads.put(id, this.createPlacedReadBuilder(id, offset, validRange, basecalls, dir, fullUngappedLength));
        return this;
    }

    @Override
    public AbstractContigBuilder<P, C> addRead(P read) {
        this.reads.put(read.getId(), this.createPlacedReadBuilder(read));
        return this;
    }

    protected abstract AssembledReadBuilder<P> createPlacedReadBuilder(P var1);

    protected abstract AssembledReadBuilder<P> createPlacedReadBuilder(String var1, int var2, Range var3, String var4, Direction var5, int var6);

    @Override
    public ContigBuilder<P, C> recallConsensus(ConsensusCaller consensusCaller, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy) {
        if (consensusCaller == null) {
            throw new NullPointerException("consensus caller can not be null");
        }
        if (qualityDataStore == null) {
            throw new NullPointerException("quality datastore can not be null");
        }
        this.consensusCaller = consensusCaller;
        this.qualityDataStore = qualityDataStore;
        this.qualityValueStrategy = qualityValueStrategy;
        return this;
    }

    @Override
    public ContigBuilder<P, C> recallConsensus(ConsensusCaller consensusCaller) {
        if (consensusCaller == null) {
            throw new NullPointerException("consensus caller can not be null");
        }
        this.consensusCaller = consensusCaller;
        this.qualityDataStore = null;
        this.qualityValueStrategy = null;
        return this;
    }

    @Override
    public ContigBuilder<P, C> recallConsensusNow() {
        if (this.consensusCaller == null) {
            throw new IllegalStateException("must set consensus caller");
        }
        SliceBuilder[] builders = this.initializeSliceBuilders(this.consensus.build());
        for (AssembledReadBuilder<P> aceReadBuilder : this.reads.values()) {
            int start = (int)aceReadBuilder.getBegin();
            String id = aceReadBuilder.getId();
            Direction dir = aceReadBuilder.getDirection();
            QualitySequence fullQualities = null;
            if (this.qualityDataStore != null) {
                try {
                    fullQualities = (QualitySequence)this.qualityDataStore.get(id);
                }
                catch (DataStoreException e) {
                    throw new IllegalStateException("error recalling consensus", e);
                }
                if (fullQualities == null) {
                    throw new NullPointerException("could not get qualities for " + id);
                }
            }
            NucleotideSequence readSequence = aceReadBuilder.getCurrentNucleotideSequence();
            if (fullQualities == null) {
                byte[] qualArray = new byte[(int)readSequence.getUngappedLength()];
                Arrays.fill(qualArray, DEFAULT_QUALITY.getQualityScore());
                fullQualities = new QualitySequenceBuilder(qualArray).build();
            }
            QualitySequence gappedValidRangequalities = this.qualityValueStrategy.getGappedValidRangeQualitySequenceFor(readSequence, fullQualities, aceReadBuilder.getClearRange(), dir);
            Iterator baseIter = readSequence.iterator();
            Iterator qualIter = gappedValidRangequalities.iterator();
            int i = 0;
            while (baseIter.hasNext()) {
                Nucleotide base = (Nucleotide)baseIter.next();
                PhredQuality quality = (PhredQuality)qualIter.next();
                builders[start + i].add(id, base, quality, dir);
                ++i;
            }
        }
        for (int i = 0; i < builders.length; ++i) {
            SliceBuilder builder = builders[i];
            if (builder.getCurrentCoverageDepth() <= 0) continue;
            Slice slice = builder.build();
            this.consensus.replace(i, this.consensusCaller.callConsensus(slice).getConsensus());
        }
        return this;
    }

    private SliceBuilder[] initializeSliceBuilders(NucleotideSequence consensus) {
        SliceBuilder[] builders = new SliceBuilder[(int)consensus.getLength()];
        int i = 0;
        Iterator iter = consensus.iterator();
        while (iter.hasNext()) {
            builders[i++] = new SliceBuilder().setConsensus((Nucleotide)iter.next());
        }
        return builders;
    }

    @Override
    public abstract C build();

    @Override
    public ContigBuilder<P, C> setContigId(String contigId) {
        this.id = contigId;
        return this;
    }

    @Override
    public String getContigId() {
        return this.id;
    }

    @Override
    public int numberOfReads() {
        return this.reads.size();
    }

    @Override
    public ContigBuilder<P, C> addAllReads(Iterable<P> reads) {
        for (AssembledRead read : reads) {
            this.addRead(read);
        }
        return this;
    }

    @Override
    public Collection<? extends AssembledReadBuilder<P>> getAllAssembledReadBuilders() {
        return this.reads.values();
    }

    @Override
    public AssembledReadBuilder<P> getAssembledReadBuilder(String readId) {
        return this.reads.get(readId);
    }

    @Override
    public ContigBuilder<P, C> removeRead(String readId) {
        this.reads.remove(readId);
        return this;
    }

    @Override
    public NucleotideSequenceBuilder getConsensusBuilder() {
        return this.consensus;
    }
}

